import type { Metadata } from "next"
import PerformanceAudit from "@/components/performance-audit"
import WebVitalsMonitor from "@/components/web-vitals-monitor"
import BundleAnalyzer from "@/components/bundle-analyzer"

export const metadata: Metadata = {
  title: "Audit de Performance Complet - DOGES",
  description: "Audit détaillé des performances, Core Web Vitals et optimisations du site DOGES",
  robots: "noindex, nofollow",
}

export default function PerformanceAuditPage() {
  return (
    <div className="min-h-screen bg-gray-50 py-12">
      <div className="max-w-7xl mx-auto px-4 space-y-8">
        {/* Header */}
        <div className="text-center space-y-4">
          <h1 className="text-4xl font-bold bg-gradient-to-r from-[#002395] to-[#001875] bg-clip-text text-transparent">
            Audit de Performance Complet
          </h1>
          <p className="text-xl text-gray-600 max-w-3xl mx-auto">
            Analyse détaillée des performances, optimisations et métriques du site DOGES
          </p>
        </div>

        {/* Core Web Vitals en temps réel */}
        <div>
          <h2 className="text-2xl font-semibold mb-4">Core Web Vitals</h2>
          <WebVitalsMonitor />
        </div>

        {/* Analyse du bundle */}
        <BundleAnalyzer />

        {/* Audit complet */}
        <PerformanceAudit />

        {/* Recommandations finales */}
        <div className="bg-white rounded-lg p-6 shadow-sm">
          <h2 className="text-2xl font-semibold mb-4">Recommandations Prioritaires</h2>
          <div className="grid md:grid-cols-3 gap-6">
            <div className="space-y-3">
              <h3 className="font-semibold text-green-600">🚀 Performance</h3>
              <ul className="text-sm space-y-1">
                <li>• Implémenter un CDN (Cloudflare/AWS)</li>
                <li>• Optimiser les fonts avec font-display: swap</li>
                <li>• Précharger les ressources critiques</li>
                <li>• Utiliser HTTP/3 si disponible</li>
              </ul>
            </div>
            <div className="space-y-3">
              <h3 className="font-semibold text-blue-600">🔒 Sécurité</h3>
              <ul className="text-sm space-y-1">
                <li>• Ajouter Content Security Policy</li>
                <li>• Implémenter HSTS headers</li>
                <li>• Configurer CORS approprié</li>
                <li>• Audit régulier des dépendances</li>
              </ul>
            </div>
            <div className="space-y-3">
              <h3 className="font-semibold text-purple-600">📊 Monitoring</h3>
              <ul className="text-sm space-y-1">
                <li>• Intégrer Google Analytics 4</li>
                <li>• Configurer Vercel Analytics</li>
                <li>• Monitoring des erreurs (Sentry)</li>
                <li>• Alertes de performance</li>
              </ul>
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}
