import { NextResponse } from "next/server"

export async function GET(request: Request) {
  // Récupérer l'URL complète de la requête
  const url = new URL(request.url)

  // Récupérer les en-têtes de la requête
  const headers: Record<string, string> = {}
  request.headers.forEach((value, key) => {
    headers[key] = value
  })

  // Construire l'objet de réponse avec les informations de débogage
  const debugInfo = {
    requestUrl: url.toString(),
    pathname: url.pathname,
    search: url.search,
    headers,
    timestamp: new Date().toISOString(),
  }

  // Retourner les informations de débogage en JSON
  return NextResponse.json(debugInfo)
}
