import type { Metadata } from "next"
import BlogArticleLayout from "@/components/blog-article-layout"
import { SafeImage } from "@/components/safe-image"

export const metadata: Metadata = {
  title: "IFI et immobilier locatif : stratégies d'optimisation | Dogesadb",
  description: "Comment réduire votre Impôt sur la Fortune Immobilière tout en développant votre patrimoine locatif.",
  alternates: {
    canonical: "https://dogesadb.fr/blog/articles/ifi-immobilier-locatif",
  },
}

export default function IFIImmobilierLocatif() {
  const tableOfContents = [
    { id: "comprendre-ifi", text: "Comprendre l'IFI", level: 2 },
    { id: "calcul-ifi", text: "Comment est calculé l'IFI ?", level: 3 },
    { id: "seuils-taux", text: "Seuils et taux d'imposition", level: 3 },
    { id: "strategies-optimisation", text: "Stratégies d'optimisation fiscale", level: 2 },
    { id: "dette-deductible", text: "Utiliser la dette déductible", level: 3 },
    { id: "sci", text: "La SCI comme outil d'optimisation", level: 3 },
    { id: "demembrement", text: "Le démembrement de propriété", level: 3 },
    { id: "investissements-exoneres", text: "Les investissements partiellement exonérés", level: 2 },
    { id: "biens-professionnels", text: "Biens professionnels", level: 3 },
    { id: "forets-vignobles", text: "Forêts et vignobles", level: 3 },
    { id: "cas-pratiques", text: "Cas pratiques et exemples chiffrés", level: 2 },
    { id: "erreurs-eviter", text: "Les erreurs à éviter", level: 2 },
  ]

  const author = {
    name: "Équipe DOGES",
    role: "Experts en fiscalité immobilière",
    image: "/experts/equipe-doges.jpg",
    bio: "Notre équipe d'experts en fiscalité immobilière vous accompagne pour optimiser votre patrimoine et réduire votre imposition.",
  }

  const relatedArticles = [
    {
      slug: "optimisation-fiscale-proprietaires-2024",
      title: "Guide d'optimisation fiscale pour propriétaires en 2024",
      description: "Découvrez les stratégies d'optimisation fiscale pour propriétaires immobiliers en 2024.",
      image: "/tax-optimization-document.png",
    },
    {
      slug: "lmnp-lmp-comparaison-statuts",
      title: "LMNP vs LMP : Quel statut choisir pour votre investissement locatif ?",
      description: "Analyse comparative des statuts LMNP et LMP pour optimiser votre fiscalité immobilière.",
      image: "/lmnp-lmp-comparison-chart.png",
    },
    {
      slug: "guide-proprietaire-bailleur-2024",
      title: "Guide complet du propriétaire bailleur 2024",
      description: "Toutes les informations essentielles pour les propriétaires bailleurs en 2024.",
      image: "/default-article-image.jpg",
    },
  ]

  return (
    <BlogArticleLayout
      title="IFI et immobilier locatif : stratégies d'optimisation"
      date="10 janvier 2025"
      category="Fiscalité"
      readingTime="11 min"
      image="/ifi-reduction-strategies.png"
      tableOfContents={tableOfContents}
      author={author}
      relatedArticles={relatedArticles}
    >
      <p>
        L'Impôt sur la Fortune Immobilière (IFI) concerne de nombreux propriétaires d'immobilier locatif dont le
        patrimoine dépasse 1,3 million d'euros. Cet impôt, qui a remplacé l'ISF en 2018, cible spécifiquement les actifs
        immobiliers. Comment optimiser votre situation face à l'IFI tout en continuant à développer votre patrimoine
        immobilier ? Découvrez nos stratégies d'optimisation fiscale.
      </p>

      <h2 id="comprendre-ifi">Comprendre l'IFI</h2>

      <p>
        Avant d'aborder les stratégies d'optimisation, il est essentiel de bien comprendre le fonctionnement de l'IFI et
        ses spécificités par rapport à l'ancien ISF.
      </p>

      <h3 id="calcul-ifi">Comment est calculé l'IFI ?</h3>

      <p>
        L'IFI s'applique aux personnes physiques détenant un patrimoine immobilier net taxable supérieur à 1,3 million
        d'euros au 1er janvier de l'année d'imposition. Sont concernés :
      </p>

      <ul>
        <li>Les immeubles bâtis (résidences principales, secondaires, immeubles locatifs)</li>
        <li>Les terrains à bâtir</li>
        <li>Les parts de sociétés immobilières (SCI, SCPI, OPCI)</li>
        <li>Certains actifs immobiliers détenus indirectement</li>
      </ul>

      <p>
        Le patrimoine immobilier est évalué à sa valeur vénale réelle, c'est-à-dire au prix auquel le bien pourrait être
        vendu dans les conditions normales du marché.
      </p>

      <SafeImage
        src="/ifi-calculation-example.png"
        alt="Exemple de calcul de l'IFI"
        width={800}
        height={450}
        className="my-6 rounded-lg"
      />

      <h3 id="seuils-taux">Seuils et taux d'imposition</h3>

      <p>Les taux d'imposition de l'IFI sont progressifs et s'appliquent par tranches :</p>

      <table className="w-full border-collapse my-6">
        <thead>
          <tr className="bg-gray-100">
            <th className="border p-2 text-left">Fraction de la valeur nette taxable du patrimoine</th>
            <th className="border p-2 text-left">Taux applicable</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td className="border p-2">N'excédant pas 800 000 €</td>
            <td className="border p-2">0%</td>
          </tr>
          <tr>
            <td className="border p-2">Entre 800 000 € et 1 300 000 €</td>
            <td className="border p-2">0,50%</td>
          </tr>
          <tr>
            <td className="border p-2">Entre 1 300 000 € et 2 570 000 €</td>
            <td className="border p-2">0,70%</td>
          </tr>
          <tr>
            <td className="border p-2">Entre 2 570 000 € et 5 000 000 €</td>
            <td className="border p-2">1,00%</td>
          </tr>
          <tr>
            <td className="border p-2">Entre 5 000 000 € et 10 000 000 €</td>
            <td className="border p-2">1,25%</td>
          </tr>
          <tr>
            <td className="border p-2">Supérieure à 10 000 000 €</td>
            <td className="border p-2">1,50%</td>
          </tr>
        </tbody>
      </table>

      <SafeImage
        src="/ifi-threshold-chart.png"
        alt="Graphique des seuils et taux de l'IFI"
        width={800}
        height={450}
        className="my-6 rounded-lg"
      />

      <h2 id="strategies-optimisation">Stratégies d'optimisation fiscale</h2>

      <p>
        Plusieurs stratégies peuvent être mises en œuvre pour optimiser votre situation face à l'IFI tout en conservant
        ou développant votre patrimoine immobilier.
      </p>

      <h3 id="dette-deductible">Utiliser la dette déductible</h3>

      <p>
        Les dettes relatives à l'acquisition, la réparation, l'entretien ou l'amélioration des biens immobiliers sont
        déductibles de l'assiette de l'IFI. Cette déductibilité est toutefois encadrée :
      </p>

      <ul>
        <li>Les prêts in fine ne sont déductibles que de manière dégressive</li>
        <li>
          Les dettes contractées auprès d'un membre du foyer fiscal ou d'une société contrôlée ne sont pas déductibles
        </li>
        <li>
          Pour les patrimoines supérieurs à 5 millions d'euros, les dettes excédant 60% de la valeur du patrimoine
          voient leur déductibilité limitée
        </li>
      </ul>

      <p>
        <strong>Stratégie :</strong> Privilégier l'endettement pour vos investissements immobiliers permet de réduire
        votre base taxable à l'IFI tout en conservant le potentiel de rendement et de plus-value de vos biens.
      </p>

      <h3 id="sci">La SCI comme outil d'optimisation</h3>

      <p>
        La Société Civile Immobilière (SCI) peut constituer un excellent outil d'optimisation de l'IFI, notamment dans
        une perspective de transmission :
      </p>

      <ul>
        <li>
          Possibilité de donner des parts en nue-propriété à vos enfants tout en conservant l'usufruit (démembrement)
        </li>
        <li>Application d'une décote sur la valeur des parts (absence de liquidité, minorité)</li>
        <li>Facilitation de la transmission progressive du patrimoine</li>
      </ul>

      <p>
        <strong>Attention :</strong> La SCI ne permet pas d'échapper à l'IFI, les parts de SCI étant incluses dans
        l'assiette taxable. C'est davantage un outil de gestion et de transmission qu'un instrument d'exonération.
      </p>

      <h3 id="demembrement">Le démembrement de propriété</h3>

      <p>
        Le démembrement consiste à séparer la nue-propriété de l'usufruit d'un bien immobilier. Cette technique présente
        plusieurs avantages :
      </p>

      <ul>
        <li>
          Si vous donnez la nue-propriété à vos enfants tout en conservant l'usufruit, seule la valeur de l'usufruit
          sera soumise à l'IFI dans votre patrimoine
        </li>
        <li>
          À l'inverse, si vous achetez un bien en nue-propriété (l'usufruit étant détenu par un tiers), vous n'êtes pas
          soumis à l'IFI sur ce bien pendant la durée de l'usufruit
        </li>
      </ul>

      <p>
        <strong>Stratégie :</strong> L'acquisition de la nue-propriété d'un bien dont l'usufruit est temporaire (10 à 15
        ans) permet d'acquérir un bien avec une décote importante (30 à 40%) tout en étant exonéré d'IFI pendant la
        durée de l'usufruit.
      </p>

      <h2 id="investissements-exoneres">Les investissements partiellement exonérés</h2>

      <p>
        Certains types d'investissements immobiliers bénéficient d'exonérations partielles ou totales au titre de l'IFI.
      </p>

      <h3 id="biens-professionnels">Biens professionnels</h3>

      <p>
        Les biens immobiliers affectés à une activité professionnelle peuvent être exonérés d'IFI sous certaines
        conditions :
      </p>

      <ul>
        <li>
          Biens utilisés pour l'activité principale du contribuable (gérant majoritaire d'une société opérationnelle)
        </li>
        <li>
          Immeubles détenus par une société opérationnelle dont le contribuable détient directement ou indirectement au
          moins 50% des parts
        </li>
      </ul>

      <p>
        <strong>Stratégie :</strong> Si vous êtes entrepreneur, il peut être judicieux de détenir vos locaux
        professionnels directement ou via votre société d'exploitation plutôt que via une SCI qui vous les louerait.
      </p>

      <h3 id="forets-vignobles">Forêts et vignobles</h3>

      <p>
        Les bois, forêts et parts de groupements forestiers bénéficient d'une exonération à hauteur de 75% de leur
        valeur sous condition d'exploitation durable. Les biens ruraux loués à long terme et les parts de GFA
        (Groupement Foncier Agricole) peuvent également bénéficier d'exonérations partielles.
      </p>

      <p>
        <strong>Stratégie :</strong> Diversifier une partie de votre patrimoine vers ces actifs peut réduire
        significativement votre base taxable à l'IFI tout en vous offrant des placements stables sur le long terme.
      </p>

      <h2 id="cas-pratiques">Cas pratiques et exemples chiffrés</h2>

      <p>
        Prenons l'exemple d'un couple possédant un patrimoine immobilier de 3 millions d'euros, comprenant leur
        résidence principale (1,2M€), une résidence secondaire (800k€) et un immeuble de rapport (1M€).
      </p>

      <p>Sans optimisation, leur IFI serait calculé comme suit :</p>
      <ul>
        <li>Valeur brute : 3 000 000 €</li>
        <li>Abattement de 30% sur la résidence principale : -360 000 €</li>
        <li>Base taxable : 2 640 000 €</li>
        <li>IFI dû : environ 14 400 €</li>
      </ul>

      <p>Avec une stratégie d'optimisation :</p>
      <ul>
        <li>Refinancement de l'immeuble de rapport avec un prêt de 600 000 €</li>
        <li>Acquisition de parts de groupements forestiers pour 200 000 €</li>
        <li>Valeur brute : 3 200 000 €</li>
        <li>Abattement résidence principale : -360 000 €</li>
        <li>Dette déductible : -600 000 €</li>
        <li>Exonération de 75% sur les parts forestières : -150 000 €</li>
        <li>Base taxable : 2 090 000 €</li>
        <li>IFI dû : environ 8 500 €</li>
      </ul>

      <p>
        Cette stratégie permet une économie d'IFI d'environ 5 900 € par an, tout en conservant le même patrimoine
        immobilier et en diversifiant les placements.
      </p>

      <h2 id="erreurs-eviter">Les erreurs à éviter</h2>

      <p>Dans votre stratégie d'optimisation de l'IFI, évitez ces erreurs courantes :</p>

      <ul>
        <li>
          <strong>Vendre son immobilier pour échapper à l'IFI</strong> : Cette décision doit être prise en fonction de
          votre stratégie patrimoniale globale, pas uniquement pour des raisons fiscales.
        </li>
        <li>
          <strong>Sous-évaluer ses biens</strong> : L'administration fiscale dispose de nombreux moyens pour vérifier
          les valeurs déclarées et peut appliquer des pénalités importantes.
        </li>
        <li>
          <strong>Négliger les autres impôts</strong> : Une stratégie d'optimisation de l'IFI peut avoir des
          conséquences sur l'impôt sur le revenu ou les droits de succession.
        </li>
        <li>
          <strong>Recourir à des montages complexes non sécurisés</strong> : Privilégiez des stratégies éprouvées et
          conformes à la législation pour éviter les risques de requalification.
        </li>
      </ul>

      <p>
        L'optimisation de votre situation face à l'IFI nécessite une approche globale de votre patrimoine et de vos
        objectifs. Un conseiller spécialisé pourra vous accompagner dans la mise en place de stratégies adaptées à votre
        situation personnelle.
      </p>

      <p>
        N'hésitez pas à nous contacter pour une analyse personnalisée de votre situation patrimoniale et fiscale. Nos
        experts vous aideront à élaborer une stratégie sur mesure pour optimiser votre IFI tout en préservant et
        développant votre patrimoine immobilier.
      </p>
    </BlogArticleLayout>
  )
}
