import type { Metadata } from "next"
import { BlogArticleLayout } from "@/components/blog-article-layout"
import { SafeImage } from "@/components/safe-image"

export const metadata: Metadata = {
  title: "LMNP vs LMP : Comparaison des statuts pour l'investissement locatif | DogesaDB",
  description:
    "Découvrez les différences entre les statuts LMNP et LMP, leurs avantages fiscaux et comment choisir le régime le plus adapté à votre investissement locatif.",
  canonical: "https://www.dogesadb.fr/blog/articles/lmnp-lmp-comparaison-statuts",
}

export default function LmnpLmpComparaisonPage() {
  const tableOfContents = {
    items: [
      { title: "Introduction", url: "#introduction" },
      {
        title: "Définitions : LMNP et LMP",
        url: "#definitions",
        items: [
          { title: "Conditions du statut LMNP", url: "#conditions-lmnp" },
          { title: "Conditions du statut LMP", url: "#conditions-lmp" },
        ],
      },
      {
        title: "Avantages fiscaux des deux statuts",
        url: "#avantages-fiscaux",
        items: [
          { title: "Fiscalité en LMNP", url: "#fiscalite-lmnp" },
          { title: "Fiscalité en LMP", url: "#fiscalite-lmp" },
        ],
      },
      { title: "Tableau comparatif des régimes", url: "#comparaison-regimes" },
      {
        title: "Comment choisir son statut ?",
        url: "#choix-statut",
        items: [
          { title: "Critères de choix", url: "#criteres-choix" },
          { title: "Évolution possible entre les statuts", url: "#evolution-statut" },
        ],
      },
      { title: "Conclusion", url: "#conclusion" },
    ],
  }

  const relatedArticles = [
    {
      slug: "avantages-fiscaux-location-meublee",
      title: "Les avantages fiscaux de la location meublée en 2025",
      description: "Découvrez les avantages fiscaux de la location meublée et comment optimiser votre investissement.",
      image: "/lmnp-fiscal-advantages.png",
      date: "2025-01-15",
      category: "Fiscalité",
    },
    {
      slug: "optimisation-fiscale-proprietaires-2024",
      title: "Guide d'optimisation fiscale pour les propriétaires en 2025",
      description: "Stratégies d'optimisation fiscale pour les propriétaires immobiliers.",
      image: "/tax-optimization-document.png",
      date: "2024-12-10",
      category: "Fiscalité",
    },
    {
      slug: "investir-immobilier-ile-de-france-2024",
      title: "Investir dans l'immobilier en Île-de-France en 2025",
      description: "Les meilleures opportunités d'investissement en Île-de-France.",
      image: "/paris-rental-market.png",
      date: "2024-11-05",
      category: "Investissement",
    },
  ]

  const previousArticle = {
    slug: "avantages-fiscaux-location-meublee",
    title: "Les avantages fiscaux de la location meublée en 2025",
  }

  const nextArticle = {
    slug: "optimisation-fiscale-proprietaires-2024",
    title: "Guide d'optimisation fiscale pour les propriétaires en 2025",
  }

  const metadata = {
    title: "LMNP vs LMP : Comparaison des statuts pour l'investissement locatif",
    description:
      "Découvrez les différences entre les statuts LMNP et LMP, leurs avantages fiscaux et comment choisir le régime le plus adapté à votre investissement locatif.",
    date: "2025-02-10",
    readingTime: "10 min",
    category: "Fiscalité",
    image: "/lmnp-lmp-comparison-chart.png",
    author: {
      name: "Bedis Iddir",
      title: "Expert en gestion locative",
      description:
        "Bedis Iddir est un expert reconnu en gestion locative avec plus de 15 ans d'expérience dans l'immobilier parisien.",
      image: "/confident-leader.png",
      linkedin: "https://www.linkedin.com/in/bedis-iddir/",
    },
    relatedArticles: relatedArticles,
  }

  return (
    <BlogArticleLayout
      metadata={metadata}
      tableOfContents={tableOfContents}
      previousArticle={previousArticle}
      nextArticle={nextArticle}
    >
      <section id="introduction" className="mb-8">
        <h2 className="text-2xl font-bold mb-4">Introduction</h2>
        <p className="mb-4">
          L'investissement dans la location meublée est devenu une stratégie populaire pour les investisseurs
          immobiliers en France. Deux statuts principaux s'offrent à ces investisseurs : le Loueur en Meublé Non
          Professionnel (LMNP) et le Loueur en Meublé Professionnel (LMP). Chacun présente des avantages et des
          contraintes spécifiques, notamment sur le plan fiscal.
        </p>
        <p className="mb-4">
          Cet article compare en détail ces deux statuts pour vous aider à faire le choix le plus adapté à votre
          situation et à vos objectifs d'investissement.
        </p>
        <SafeImage
          src="/lmnp-lmp-comparison-chart.png"
          alt="Comparaison des statuts LMNP et LMP"
          width={800}
          height={450}
          className="rounded-lg my-6"
        />
      </section>

      <section id="definitions" className="mb-8">
        <h2 className="text-2xl font-bold mb-4">Définitions : LMNP et LMP</h2>
        <p className="mb-4">
          Avant d'entrer dans les détails, il est important de comprendre ce que signifient ces deux statuts et quelles
          sont leurs conditions d'application.
        </p>

        <div id="conditions-lmnp" className="mb-6">
          <h3 className="text-xl font-semibold mb-3">Conditions du statut LMNP</h3>
          <p className="mb-4">Le statut de Loueur en Meublé Non Professionnel (LMNP) s'applique aux personnes qui :</p>
          <ul className="list-disc pl-6 mb-4">
            <li>Louent des logements meublés</li>
            <li>Perçoivent moins de 23 000 € de recettes locatives annuelles</li>
            <li>OU ces recettes représentent moins de 50% des revenus globaux du foyer fiscal</li>
          </ul>
          <p className="mb-4">
            Le LMNP est considéré comme une activité complémentaire et non comme l'activité principale du contribuable.
          </p>
        </div>

        <div id="conditions-lmp" className="mb-6">
          <h3 className="text-xl font-semibold mb-3">Conditions du statut LMP</h3>
          <p className="mb-4">
            Le statut de Loueur en Meublé Professionnel (LMP) s'applique lorsque les deux conditions suivantes sont
            remplies :
          </p>
          <ul className="list-disc pl-6 mb-4">
            <li>Les recettes locatives annuelles dépassent 23 000 €</li>
            <li>ET ces recettes représentent plus de 50% des revenus globaux du foyer fiscal</li>
          </ul>
          <p className="mb-4">
            Le LMP est considéré comme une activité professionnelle à part entière, avec toutes les obligations et
            avantages que cela implique.
          </p>
        </div>
      </section>

      <section id="avantages-fiscaux" className="mb-8">
        <h2 className="text-2xl font-bold mb-4">Avantages fiscaux des deux statuts</h2>
        <p className="mb-4">
          Les régimes LMNP et LMP offrent chacun des avantages fiscaux spécifiques qui peuvent influencer
          significativement la rentabilité de votre investissement.
        </p>

        <div id="fiscalite-lmnp" className="mb-6">
          <h3 className="text-xl font-semibold mb-3">Fiscalité en LMNP</h3>
          <p className="mb-4">En tant que LMNP, vous pouvez opter pour :</p>
          <ul className="list-disc pl-6 mb-4">
            <li>
              <strong>Le régime micro-BIC</strong> : si vos recettes sont inférieures à 77 700 €, vous bénéficiez d'un
              abattement forfaitaire de 50% sur vos revenus locatifs.
            </li>
            <li>
              <strong>Le régime réel</strong> : vous pouvez déduire toutes vos charges réelles (intérêts d'emprunt,
              charges de copropriété, taxe foncière, etc.) et amortir le bien immobilier et les meubles.
            </li>
          </ul>
          <p className="mb-4">
            L'amortissement est un avantage majeur du LMNP au régime réel, car il permet de créer un déficit comptable
            (mais pas fiscal) qui réduit l'assiette imposable.
          </p>
          <SafeImage
            src="/lmnp-fiscal-advantages.png"
            alt="Avantages fiscaux du statut LMNP"
            width={800}
            height={450}
            className="rounded-lg my-6"
          />
        </div>

        <div id="fiscalite-lmp" className="mb-6">
          <h3 className="text-xl font-semibold mb-3">Fiscalité en LMP</h3>
          <p className="mb-4">Le statut LMP offre des avantages fiscaux supplémentaires :</p>
          <ul className="list-disc pl-6 mb-4">
            <li>
              Possibilité d'imputer les déficits sur le revenu global (et pas seulement sur les revenus de même nature)
            </li>
            <li>
              Exonération de plus-value professionnelle sous certaines conditions (activité exercée depuis plus de 5 ans
              et recettes inférieures à 250 000 €)
            </li>
            <li>
              Exonération d'IFI (Impôt sur la Fortune Immobilière) si les biens sont considérés comme des actifs
              professionnels
            </li>
          </ul>
          <p className="mb-4">
            En contrepartie, le LMP implique des obligations professionnelles : inscription au Registre du Commerce et
            des Sociétés (RCS), affiliation au régime social des indépendants (RSI), etc.
          </p>
        </div>
      </section>

      <section id="comparaison-regimes" className="mb-8">
        <h2 className="text-2xl font-bold mb-4">Tableau comparatif des régimes</h2>
        <div className="overflow-x-auto">
          <table className="min-w-full bg-white border border-gray-300 rounded-lg">
            <thead>
              <tr className="bg-gray-100">
                <th className="py-3 px-4 border-b text-left">Critères</th>
                <th className="py-3 px-4 border-b text-left">LMNP</th>
                <th className="py-3 px-4 border-b text-left">LMP</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td className="py-3 px-4 border-b font-medium">Seuils d'application</td>
                <td className="py-3 px-4 border-b">Recettes &lt; 23 000 € OU &lt; 50% des revenus globaux</td>
                <td className="py-3 px-4 border-b">
                  Recettes {">"} 23 000 € ET {">"} 50% des revenus globaux
                </td>
              </tr>
              <tr>
                <td className="py-3 px-4 border-b font-medium">Régimes fiscaux disponibles</td>
                <td className="py-3 px-4 border-b">Micro-BIC ou Réel</td>
                <td className="py-3 px-4 border-b">Réel uniquement</td>
              </tr>
              <tr>
                <td className="py-3 px-4 border-b font-medium">Amortissement</td>
                <td className="py-3 px-4 border-b">Oui (au régime réel)</td>
                <td className="py-3 px-4 border-b">Oui</td>
              </tr>
              <tr>
                <td className="py-3 px-4 border-b font-medium">Imputation des déficits</td>
                <td className="py-3 px-4 border-b">Sur les revenus de même nature uniquement</td>
                <td className="py-3 px-4 border-b">Sur le revenu global</td>
              </tr>
              <tr>
                <td className="py-3 px-4 border-b font-medium">Plus-values</td>
                <td className="py-3 px-4 border-b">Régime des plus-values des particuliers</td>
                <td className="py-3 px-4 border-b">Régime des plus-values professionnelles (exonération possible)</td>
              </tr>
              <tr>
                <td className="py-3 px-4 border-b font-medium">IFI</td>
                <td className="py-3 px-4 border-b">Biens imposables</td>
                <td className="py-3 px-4 border-b">Exonération possible (biens professionnels)</td>
              </tr>
              <tr>
                <td className="py-3 px-4 border-b font-medium">Obligations administratives</td>
                <td className="py-3 px-4 border-b">Limitées</td>
                <td className="py-3 px-4 border-b">Inscription au RCS, affiliation RSI</td>
              </tr>
            </tbody>
          </table>
        </div>
      </section>

      <section id="choix-statut" className="mb-8">
        <h2 className="text-2xl font-bold mb-4">Comment choisir son statut ?</h2>
        <p className="mb-4">
          Le choix entre LMNP et LMP dépend de plusieurs facteurs, notamment de votre situation personnelle, de vos
          objectifs d'investissement et de votre stratégie fiscale.
        </p>

        <div id="criteres-choix" className="mb-6">
          <h3 className="text-xl font-semibold mb-3">Critères de choix</h3>
          <p className="mb-4">Voici les principaux critères à prendre en compte :</p>
          <ul className="list-disc pl-6 mb-4">
            <li>
              <strong>Volume d'investissement</strong> : si vous prévoyez d'investir massivement dans l'immobilier
              locatif meublé, le statut LMP peut être plus avantageux.
            </li>
            <li>
              <strong>Niveau de revenus</strong> : si vous avez des revenus élevés, le LMP permet d'imputer les déficits
              sur votre revenu global.
            </li>
            <li>
              <strong>Patrimoine global</strong> : si vous êtes concerné par l'IFI, le statut LMP peut permettre
              d'exonérer vos biens locatifs.
            </li>
            <li>
              <strong>Implication personnelle</strong> : le LMP implique une gestion plus active et des obligations
              administratives plus importantes.
            </li>
          </ul>
        </div>

        <div id="evolution-statut" className="mb-6">
          <h3 className="text-xl font-semibold mb-3">Évolution possible entre les statuts</h3>
          <p className="mb-4">
            Il est possible de passer du statut LMNP au statut LMP (et inversement) en fonction de l'évolution de votre
            activité. Cependant, ce changement peut avoir des conséquences fiscales importantes, notamment en termes de
            plus-values.
          </p>
          <p className="mb-4">
            Il est donc recommandé de planifier soigneusement cette transition et de se faire accompagner par un
            expert-comptable ou un conseiller fiscal.
          </p>
        </div>
      </section>

      <section id="conclusion" className="mb-8">
        <h2 className="text-2xl font-bold mb-4">Conclusion</h2>
        <p className="mb-4">
          Le choix entre LMNP et LMP est une décision stratégique qui peut avoir un impact significatif sur la
          rentabilité de vos investissements immobiliers. Chaque statut présente des avantages et des contraintes
          spécifiques, et le choix optimal dépend de votre situation personnelle et de vos objectifs.
        </p>
        <p className="mb-4">
          Pour les investisseurs débutants ou ceux qui souhaitent limiter leur implication administrative, le statut
          LMNP est souvent plus adapté. Pour les investisseurs plus expérimentés, avec un patrimoine immobilier
          important et une volonté de maximiser les avantages fiscaux, le statut LMP peut être plus intéressant.
        </p>
        <p className="mb-4">
          Chez DogesaDB, nous accompagnons les propriétaires dans la gestion de leur patrimoine immobilier et pouvons
          vous conseiller sur le statut le plus adapté à votre situation. N'hésitez pas à nous contacter pour une
          analyse personnalisée.
        </p>
      </section>
    </BlogArticleLayout>
  )
}
