import type { Metadata } from "next"
import { BlogArticleLayout } from "@/components/blog-article-layout"

export const metadata: Metadata = {
  title: "Les Nouvelles Obligations des Propriétaires Face à la Transition Énergétique | Doges ADB",
  description:
    "Panorama complet des obligations environnementales pour les propriétaires bailleurs en 2025 et des mesures à prendre pour s'y conformer. Guide pratique et conseils d'experts.",
  keywords:
    "transition énergétique, propriétaire bailleur, rénovation énergétique, DPE, audit énergétique, passoire thermique, loi climat, économies d'énergie",
  authors: [{ name: "Doges ADB" }],
  openGraph: {
    title: "Les Nouvelles Obligations des Propriétaires Face à la Transition Énergétique",
    description:
      "Panorama complet des obligations environnementales pour les propriétaires bailleurs en 2025 et des mesures à prendre pour s'y conformer. Guide pratique et conseils d'experts.",
    images: [{ url: "/real-energy-regulations-2025.jpg", width: 1200, height: 630 }],
  },
  alternates: {
    canonical: "https://www.dogesadb.fr/blog/articles/obligations-energetiques-proprietaires-2025",
  },
}

export default function ObligationsEnergetiquesPage() {
  const tableOfContents = [
    {
      id: "cadre-reglementaire",
      title: "Le cadre réglementaire actuel",
      items: [
        { id: "loi-climat", title: "Loi Climat et Résilience" },
        { id: "decret-tertiaire", title: "Décret Tertiaire" },
        { id: "re2020", title: "Réglementation environnementale 2020" },
      ],
    },
    {
      id: "obligations-immediates",
      title: "Les obligations immédiates",
      items: [
        { id: "dpe-obligatoire", title: "DPE obligatoire" },
        { id: "audit-energetique", title: "Audit énergétique" },
        { id: "information-locataires", title: "Information des locataires" },
      ],
    },
    {
      id: "calendrier-interdictions",
      title: "Le calendrier des interdictions de location",
      items: [
        { id: "logements-g-plus", title: "Logements classés G+ (2023)" },
        { id: "logements-g", title: "Logements classés G (2025)" },
        { id: "logements-f", title: "Logements classés F (2028)" },
        { id: "logements-e", title: "Logements classés E (2034)" },
      ],
    },
    {
      id: "obligations-copropriete",
      title: "Les obligations en copropriété",
      items: [
        { id: "plan-travaux", title: "Plan pluriannuel de travaux" },
        { id: "fonds-travaux", title: "Fonds de travaux" },
        { id: "dtg", title: "Diagnostic technique global" },
      ],
    },
    {
      id: "solutions-accompagnement",
      title: "Solutions et accompagnement",
      items: [
        { id: "aides-financieres", title: "Aides financières disponibles" },
        { id: "travaux-prioritaires", title: "Travaux prioritaires" },
        { id: "accompagnement-technique", title: "Accompagnement technique" },
      ],
    },
  ]

  const relatedArticles = [
    {
      slug: "dpe-2025-changements-proprietaires",
      title: "DPE 2025 : Les changements qui impactent les propriétaires",
      excerpt: "Découvrez les nouvelles règles du DPE et leur impact sur la valeur de votre bien immobilier.",
      date: "2025-03-15",
    },
    {
      slug: "guide-proprietaire-bailleur-2025",
      title: "Guide complet du propriétaire bailleur en 2025",
      excerpt: "Toutes les informations essentielles pour gérer efficacement votre bien locatif cette année.",
      date: "2025-02-10",
    },
    {
      slug: "travaux-renovation-valeur-locative",
      title: "Comment les travaux de rénovation augmentent la valeur locative",
      excerpt: "Analyse des investissements les plus rentables pour valoriser votre bien immobilier.",
      date: "2025-01-22",
    },
  ]

  return (
    <BlogArticleLayout
      title="Les Nouvelles Obligations des Propriétaires Face à la Transition Énergétique"
      description="Panorama complet des obligations environnementales pour les propriétaires bailleurs et les mesures à prendre pour s'y conformer."
      date="2025-04-18"
      category="Réglementation"
      readingTime="12 min"
      author={{
        name: "Bedis Iddir",
        role: "Expert en gestion locative",
        image: "/experts/bedis-iddir.jpg",
        linkedIn: "https://www.linkedin.com/in/bedis-iddir/",
      }}
      mainImage="/real-energy-regulations-2025.jpg"
      mainImageAlt="Bâtiment moderne avec panneaux solaires et certification énergétique"
      tableOfContents={tableOfContents}
      relatedArticles={relatedArticles}
      previousArticle={{
        slug: "guide-proprietaire-bailleur-2025",
        title: "Guide complet du propriétaire bailleur en 2025",
      }}
      nextArticle={{
        slug: "dpe-2025-changements-proprietaires",
        title: "DPE 2025 : Les changements qui impactent les propriétaires",
      }}
    >
      <p className="text-lg font-medium text-gray-700 mb-6">
        La transition énergétique s'accélère et impose aux propriétaires bailleurs un nombre croissant d'obligations.
        Entre interdiction progressive de location des passoires thermiques, audits énergétiques obligatoires et
        nouvelles normes de construction, le cadre réglementaire se durcit considérablement. Découvrez les principales
        obligations qui s'imposent aux propriétaires en 2025 et les solutions pour y faire face.
      </p>

      <h2 id="cadre-reglementaire" className="scroll-mt-20">
        Le cadre réglementaire actuel
      </h2>

      <p>
        Plusieurs textes législatifs et réglementaires structurent aujourd'hui les obligations des propriétaires en
        matière environnementale.
      </p>

      <h3 id="loi-climat" className="scroll-mt-20">
        Loi Climat et Résilience
      </h3>

      <p>
        Promulguée le 22 août 2021, la loi Climat et Résilience constitue le texte fondateur des nouvelles obligations
        énergétiques des propriétaires. Elle vise à réduire les émissions de gaz à effet de serre de 40% d'ici 2030 par
        rapport à 1990. Pour le secteur immobilier, elle prévoit notamment :
      </p>

      <ul>
        <li>L'interdiction progressive de location des logements énergivores</li>
        <li>L'obligation d'audit énergétique pour la vente de certains biens</li>
        <li>Le gel des loyers pour les passoires thermiques</li>
        <li>L'obligation d'information renforcée des acquéreurs et locataires</li>
      </ul>

      <h3 id="decret-tertiaire" className="scroll-mt-20">
        Décret Tertiaire
      </h3>

      <p>
        Pour les propriétaires de bâtiments tertiaires (bureaux, commerces, hôtels...) de plus de 1 000 m², le Décret
        Tertiaire impose des objectifs ambitieux de réduction de la consommation énergétique :
      </p>

      <ul>
        <li>-40% d'ici 2030</li>
        <li>-50% d'ici 2040</li>
        <li>-60% d'ici 2050</li>
      </ul>

      <p>Ces objectifs s'accompagnent d'obligations de reporting annuel sur la plateforme OPERAT de l'ADEME.</p>

      <h3 id="re2020" className="scroll-mt-20">
        Réglementation environnementale 2020
      </h3>

      <p>
        Entrée en vigueur le 1er janvier 2022, la RE2020 remplace la RT2012 et fixe de nouvelles exigences pour les
        constructions neuves :
      </p>

      <ul>
        <li>Amélioration de la performance énergétique et réduction des consommations</li>
        <li>Diminution de l'impact carbone des bâtiments</li>
        <li>Adaptation aux conditions climatiques futures</li>
        <li>Amélioration du confort d'été</li>
      </ul>

      <p>
        Cette réglementation concerne principalement les propriétaires qui font construire ou qui investissent dans le
        neuf.
      </p>

      <h2 id="obligations-immediates" className="scroll-mt-20">
        Les obligations immédiates
      </h2>

      <p>Plusieurs obligations s'imposent dès maintenant aux propriétaires bailleurs.</p>

      <h3 id="dpe-obligatoire" className="scroll-mt-20">
        DPE obligatoire
      </h3>

      <p>
        Le Diagnostic de Performance Énergétique (DPE) est obligatoire pour toute mise en location ou vente. Depuis
        juillet 2021, sa méthode de calcul a été réformée et il est devenu opposable, engageant juridiquement le
        propriétaire :
      </p>

      <ul>
        <li>Validité de 10 ans pour les DPE réalisés après le 1er juillet 2021</li>
        <li>Obligation d'afficher la classe énergétique dans les annonces immobilières</li>
        <li>
          Possibilité pour le locataire ou l'acquéreur de se retourner contre le propriétaire en cas d'information
          erronée
        </li>
      </ul>

      <h3 id="audit-energetique" className="scroll-mt-20">
        Audit énergétique
      </h3>

      <p>
        Depuis le 1er avril 2023, un audit énergétique est obligatoire pour la vente de logements classés F ou G. Cette
        obligation s'étendra progressivement :
      </p>

      <ul>
        <li>Aux logements classés E à partir du 1er janvier 2025</li>
        <li>Aux logements classés D à partir du 1er janvier 2034</li>
      </ul>

      <p>
        Cet audit doit proposer un parcours de travaux permettant d'atteindre la classe C, avec des étapes
        intermédiaires et une estimation des coûts.
      </p>

      <h3 id="information-locataires" className="scroll-mt-20">
        Information des locataires
      </h3>

      <p>
        Les propriétaires bailleurs doivent informer clairement leurs locataires sur la performance énergétique du
        logement. Depuis le 1er janvier 2023, les annonces immobilières doivent obligatoirement mentionner :
      </p>

      <ul>
        <li>La classe énergétique du logement</li>
        <li>Le montant des dépenses théoriques d'énergie</li>
        <li>L'existence d'éventuelles anomalies ou non-conformités</li>
      </ul>

      <p>
        En cas de non-respect de ces obligations d'information, le locataire peut engager la responsabilité du
        propriétaire.
      </p>

      <h2 id="calendrier-interdictions" className="scroll-mt-20">
        Le calendrier des interdictions de location
      </h2>

      <p>
        La loi Climat et Résilience prévoit une interdiction progressive de location des logements les plus énergivores,
        selon le calendrier suivant :
      </p>

      <h3 id="logements-g-plus" className="scroll-mt-20">
        Logements classés G+ (2023)
      </h3>

      <p>
        Depuis le 1er janvier 2023, les logements classés G+ (consommation supérieure à 450 kWh/m²/an) ne peuvent plus
        être loués. Cette interdiction concerne les nouveaux contrats de location et les renouvellements.
      </p>

      <h3 id="logements-g" className="scroll-mt-20">
        Logements classés G (2025)
      </h3>

      <p>À partir du 1er janvier 2025, l'interdiction de location s'étendra à tous les logements classés G.</p>

      <h3 id="logements-f" className="scroll-mt-20">
        Logements classés F (2028)
      </h3>

      <p>
        À partir du 1er janvier 2028, les logements classés F seront également concernés par l'interdiction de location.
      </p>

      <h3 id="logements-e" className="scroll-mt-20">
        Logements classés E (2034)
      </h3>

      <p>Enfin, à partir du 1er janvier 2034, les logements classés E ne pourront plus être mis en location.</p>

      <p>
        Il est donc crucial pour les propriétaires de réaliser des travaux de rénovation énergétique pour éviter de se
        retrouver dans l'impossibilité de louer leurs biens.
      </p>

      <h2 id="obligations-copropriete" className="scroll-mt-20">
        Les obligations en copropriété
      </h2>

      <p>
        Les copropriétés sont également soumises à des obligations spécifiques en matière de transition énergétique.
      </p>

      <h3 id="plan-travaux" className="scroll-mt-20">
        Plan pluriannuel de travaux
      </h3>

      <p>
        Les copropriétés de plus de 15 ans doivent obligatoirement établir un plan pluriannuel de travaux (PPT) visant à
        améliorer la performance énergétique du bâtiment. Ce plan doit être voté en assemblée générale et financé par
        les copropriétaires.
      </p>

      <h3 id="fonds-travaux" className="scroll-mt-20">
        Fonds de travaux
      </h3>

      <p>
        Pour financer les travaux prévus dans le PPT, les copropriétés doivent constituer un fonds de travaux alimenté
        par des cotisations obligatoires des copropriétaires.
      </p>

      <h3 id="dtg" className="scroll-mt-20">
        Diagnostic technique global
      </h3>

      <p>
        Le Diagnostic Technique Global (DTG) est un diagnostic complet de l'état du bâtiment, qui inclut un audit
        énergétique. Il est obligatoire pour les copropriétés de plus de 10 ans lors de la mise en copropriété d'un
        immeuble ou en cas de procédure pour insalubrité.
      </p>

      <h2 id="solutions-accompagnement" className="scroll-mt-20">
        Solutions et accompagnement
      </h2>

      <p>
        Face à ces nouvelles obligations, les propriétaires peuvent bénéficier de nombreuses aides et d'un
        accompagnement technique pour réaliser leurs travaux de rénovation énergétique.
      </p>

      <h3 id="aides-financieres" className="scroll-mt-20">
        Aides financières disponibles
      </h3>

      <p>De nombreuses aides financières sont disponibles pour les travaux de rénovation énergétique :</p>

      <ul>
        <li>MaPrimeRénov'</li>
        <li>Eco-prêt à taux zéro</li>
        <li>Certificats d'économies d'énergie (CEE)</li>
        <li>Aides des collectivités locales</li>
      </ul>

      <p>
        Il est important de se renseigner auprès des organismes compétents pour connaître les conditions d'éligibilité
        et les montants des aides.
      </p>

      <h3 id="travaux-prioritaires" className="scroll-mt-20">
        Travaux prioritaires
      </h3>

      <p>Pour améliorer la performance énergétique d'un logement, certains travaux sont prioritaires :</p>

      <ul>
        <li>Isolation des combles et des murs</li>
        <li>Remplacement des fenêtres</li>
        <li>Installation d'un système de chauffage performant</li>
        <li>Amélioration de la ventilation</li>
      </ul>

      <p>Il est conseillé de réaliser un audit énergétique pour identifier les travaux les plus pertinents.</p>

      <h3 id="accompagnement-technique" className="scroll-mt-20">
        Accompagnement technique
      </h3>

      <p>
        Pour accompagner les propriétaires dans leurs projets de rénovation énergétique, plusieurs dispositifs sont mis
        en place :
      </p>

      <ul>
        <li>Conseillers France Rénov'</li>
        <li>Plateformes de rénovation énergétique</li>
        <li>Accompagnateurs Rénov'</li>
      </ul>

      <p>
        Ces professionnels peuvent vous aider à définir votre projet, à choisir les entreprises qualifiées et à monter
        les dossiers de demande d'aides financières.
      </p>
    </BlogArticleLayout>
  )
}
