import { Skeleton } from "@/components/ui/skeleton"

export default function CalculateursLoading() {
  return (
    <div className="container mx-auto px-4 py-16">
      <Skeleton className="h-12 w-3/4 mx-auto mb-4" />
      <Skeleton className="h-6 w-2/3 mx-auto mb-12" />

      <div className="max-w-4xl mx-auto">
        <Skeleton className="h-10 w-full mb-6" />
        <Skeleton className="h-6 w-full mb-4" />
        <Skeleton className="h-6 w-full mb-4" />
        <Skeleton className="h-6 w-3/4 mb-8" />

        <div className="grid grid-cols-1 md:grid-cols-2 gap-6 mb-12">
          <Skeleton className="h-64 w-full rounded-lg" />
          <Skeleton className="h-64 w-full rounded-lg" />
        </div>

        <Skeleton className="h-10 w-full mb-6" />
        <div className="space-y-4 mb-12">
          <Skeleton className="h-12 w-full rounded-lg" />
          <Skeleton className="h-12 w-full rounded-lg" />
          <Skeleton className="h-12 w-full rounded-lg" />
          <Skeleton className="h-12 w-full rounded-lg" />
        </div>

        <div className="h-96 w-full rounded-lg">
          <Skeleton className="h-full w-full" />
        </div>
      </div>
    </div>
  )
}
