import type { Metadata } from "next"
import PageHeader from "@/components/page-header"
import CalculateursClient from "./CalculateursClient"
import { FAQSchema } from "@/components/schema/faq-schema"
import { BreadcrumbSchema } from "@/components/schema/breadcrumb-schema"
// Ajouter l'import pour le schéma HowTo
import { HowToSchemaCalculateurs } from "@/components/schema/howto-schema-calculateurs"

export const metadata: Metadata = {
  title: "Calculateurs Immobiliers Gratuits | DOGES - Outils de Simulation Immobilière",
  description:
    "Utilisez nos calculateurs immobiliers gratuits : frais de gestion locative, simulation de prêt, rentabilité d'investissement et estimation de transaction. Des outils essentiels pour propriétaires et investisseurs en Île-de-France.",
  keywords:
    "calculateur immobilier, simulation prêt immobilier, calculateur frais de gestion, calculateur rentabilité locative, estimation frais de transaction, outils immobiliers, Paris, Île-de-France",
  alternates: {
    canonical: "https://dogesadb.fr/calculateurs",
  },
  openGraph: {
    title: "Calculateurs Immobiliers Gratuits | DOGES",
    description:
      "Outils de simulation pour la gestion locative, les prêts immobiliers, les transactions et la rentabilité",
    url: "https://dogesadb.fr/calculateurs",
    siteName: "DOGES Administrateur de Biens",
    locale: "fr_FR",
    type: "website",
  },
}

// FAQ pour le rich snippet
const faqItems = [
  {
    question: "Comment calculer les frais de gestion locative ?",
    answer:
      "Pour calculer les frais de gestion locative, utilisez notre calculateur qui prend en compte le montant du loyer mensuel et applique le pourcentage de frais correspondant. Vous pouvez comparer nos tarifs avec ceux du marché pour constater les économies réalisées.",
  },
  {
    question: "Comment estimer ma capacité d'emprunt immobilier ?",
    answer:
      "Notre calculateur de prêt immobilier vous permet d'estimer votre capacité d'emprunt en fonction de vos revenus, de la durée du prêt et du taux d'intérêt. Il calcule également les mensualités et le coût total du crédit.",
  },
  {
    question: "Comment calculer la rentabilité d'un investissement locatif ?",
    answer:
      "Pour calculer la rentabilité d'un investissement locatif, notre calculateur prend en compte le prix d'achat, les frais annexes, le loyer mensuel, les charges et la fiscalité. Il vous donne la rentabilité brute, la rentabilité nette et le cash-flow mensuel.",
  },
  {
    question: "Comment estimer les frais de transaction immobilière ?",
    answer:
      "Notre calculateur de transaction immobilière vous permet d'estimer les frais d'achat (frais de notaire, droits d'enregistrement) et les frais de vente (commission d'agence, plus-value immobilière) en fonction du prix du bien.",
  },
  {
    question: "Les calculateurs de DOGES sont-ils gratuits ?",
    answer:
      "Oui, tous nos calculateurs immobiliers sont entièrement gratuits et accessibles sans inscription. Ils sont mis à disposition pour vous aider dans vos projets immobiliers et vous permettre de prendre des décisions éclairées.",
  },
]

export default function CalculateursPage() {
  return (
    <>
      <PageHeader
        title="Calculateurs Immobiliers"
        description="Des outils gratuits pour vous aider dans vos projets immobiliers"
        breadcrumbs={[{ label: "Calculateurs", href: "/calculateurs" }]}
        backgroundImage="/paris-panorama.png"
      />

      <main className="pb-16">
        {/* Calculateurs */}
        <section className="py-12">
          <div className="container mx-auto px-4">
            <CalculateursClient />
          </div>
        </section>

        {/* Introduction SEO */}
        <section className="py-12 bg-gray-50">
          <div className="container mx-auto px-4">
            <div className="max-w-4xl mx-auto">
              <h1 className="text-3xl font-bold text-[#002395] mb-6 text-center">
                Calculateurs Immobiliers Gratuits pour Propriétaires et Investisseurs
              </h1>
              <p className="text-lg text-gray-700 mb-6">
                Bienvenue sur notre page de calculateurs immobiliers, conçue pour vous aider à prendre des décisions
                éclairées dans tous vos projets immobiliers. Que vous soyez propriétaire, investisseur ou à la recherche
                de votre futur bien, nos outils de simulation vous permettront d'obtenir rapidement des estimations
                précises et personnalisées.
              </p>
              <p className="text-lg text-gray-700 mb-6">
                DOGES met à votre disposition quatre calculateurs essentiels pour la gestion et l'investissement
                immobilier en Île-de-France : un calculateur de frais de gestion locative, un simulateur de prêt
                immobilier, un estimateur de frais de transaction et un calculateur de rentabilité locative. Ces outils
                gratuits vous aideront à optimiser vos décisions financières et à maximiser la rentabilité de vos
                investissements.
              </p>
              <div className="grid grid-cols-1 md:grid-cols-2 gap-6 mt-8">
                <div className="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                  <h3 className="font-semibold text-[#002395] mb-2">Pourquoi utiliser nos calculateurs ?</h3>
                  <ul className="list-disc pl-5 space-y-2 text-gray-700">
                    <li>Estimations précises basées sur le marché immobilier actuel</li>
                    <li>Interface intuitive et facile à utiliser</li>
                    <li>Résultats instantanés et personnalisables</li>
                    <li>Outils gratuits et accessibles sans inscription</li>
                    <li>Développés par des experts en immobilier</li>
                  </ul>
                </div>
                <div className="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                  <h3 className="font-semibold text-[#002395] mb-2">Nos calculateurs vous aident à :</h3>
                  <ul className="list-disc pl-5 space-y-2 text-gray-700">
                    <li>Comparer les coûts de gestion locative</li>
                    <li>Déterminer votre capacité d'emprunt</li>
                    <li>Estimer les frais d'achat et de vente</li>
                    <li>Analyser la rentabilité de vos investissements</li>
                    <li>Optimiser votre stratégie patrimoniale</li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </section>

        {/* FAQ Section */}
        <section className="py-12 bg-gray-50" id="faq">
          <div className="container mx-auto px-4">
            <div className="max-w-4xl mx-auto">
              <h2 className="text-2xl font-bold text-[#002395] mb-8 text-center">
                Questions fréquentes sur nos calculateurs immobiliers
              </h2>
              <div className="space-y-6">
                {faqItems.map((item, index) => (
                  <div key={index} className="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                    <h3 className="font-semibold text-lg text-[#002395] mb-2">{item.question}</h3>
                    <p className="text-gray-700">{item.answer}</p>
                  </div>
                ))}
              </div>
            </div>
          </div>
        </section>

        {/* CTA Section */}
        <section className="py-12 bg-[#002395] text-white">
          <div className="container mx-auto px-4 text-center">
            <h2 className="text-2xl font-bold mb-6">Besoin d'un conseil personnalisé ?</h2>
            <p className="text-lg mb-8 max-w-3xl mx-auto">
              Nos calculateurs vous donnent une première estimation, mais chaque situation est unique. Contactez nos
              experts immobiliers pour une analyse détaillée de votre projet.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <a
                href="/contact?tab=devis"
                className="bg-white text-[#002395] hover:bg-gray-100 px-8 py-3 rounded-lg font-medium inline-block"
              >
                Demander un devis gratuit
              </a>
              <a
                href="https://www.ringover.me/EU_X6dOeNDCcD+g58Q"
                target="_blank"
                rel="noopener noreferrer"
                className="border border-white text-white hover:bg-white/10 px-8 py-3 rounded-lg font-medium inline-block"
              >
                Appelez-nous
              </a>
            </div>
          </div>
        </section>
      </main>

      {/* Schema.org structured data */}
      <BreadcrumbSchema
        items={[
          { name: "Accueil", item: "https://dogesadb.fr/" },
          { name: "Calculateurs", item: "https://dogesadb.fr/calculateurs" },
        ]}
      />
      <FAQSchema faqs={faqItems} />
      {/* Ajouter le schéma HowTo juste avant la fermeture de la balise <> */}
      <HowToSchemaCalculateurs
        name="Comment utiliser les calculateurs immobiliers DOGES"
        description="Guide étape par étape pour utiliser les calculateurs immobiliers de DOGES et obtenir des estimations précises pour vos projets immobiliers."
        steps={[
          {
            name: "Choisissez le calculateur adapté à votre besoin",
            text: "Sélectionnez parmi nos quatre calculateurs : frais de gestion, prêt immobilier, transaction ou rentabilité locative.",
          },
          {
            name: "Renseignez les informations demandées",
            text: "Complétez les champs avec vos données personnelles (montant du loyer, prix d'achat, durée du prêt, etc.).",
          },
          {
            name: "Consultez les résultats",
            text: "Analysez les résultats affichés instantanément et ajustez les paramètres si nécessaire pour affiner votre simulation.",
          },
          {
            name: "Contactez nos experts pour plus de précisions",
            text: "Si vous avez des questions ou besoin d'une analyse plus approfondie, n'hésitez pas à contacter notre équipe d'experts.",
          },
        ]}
      />
    </>
  )
}
