"use client"

import type React from "react"

import { useState } from "react"
import { ArrowRight } from "lucide-react"
import { Button } from "@/components/ui/button"
import PageHeader from "@/components/page-header"

export default function EspaceClientPage() {
  const [isLogin, setIsLogin] = useState(true)
  const [email, setEmail] = useState("")
  const [password, setPassword] = useState("")
  const [name, setName] = useState("")
  const [confirmPassword, setConfirmPassword] = useState("")
  const [forgotPassword, setForgotPassword] = useState(false)

  const handleSubmit = (e: React.FormEvent) => {
    e.preventDefault()
    // Redirection vers l'interface externe
    window.location.href = "https://doges.monespaceclient.immo/"
  }

  const handleForgotPassword = (e: React.FormEvent) => {
    e.preventDefault()
    // Logique de récupération de mot de passe à implémenter
    console.log("Récupération de mot de passe pour", email)
    alert("Un email de récupération a été envoyé à " + email)
    setForgotPassword(false)
  }

  // Fonctionnalités de l'espace client
  const clientFeatures = [
    {
      title: "Suivi des loyers",
      description: "Consultez l'historique des loyers perçus et le détail des charges pour chacun de vos biens.",
      icon: "💰",
    },
    {
      title: "Documents en ligne",
      description: "Accédez à tous vos documents : baux, quittances, relevés de gérance, factures, etc.",
      icon: "📄",
    },
    {
      title: "Suivi des travaux",
      description: "Suivez en temps réel l'avancement des travaux dans vos biens et consultez les devis et factures.",
      icon: "🔨",
    },
    {
      title: "Messagerie sécurisée",
      description: "Communiquez directement avec votre gestionnaire via notre messagerie intégrée.",
      icon: "✉️",
    },
    {
      title: "Déclaration d'incidents",
      description: "Signalez rapidement tout incident ou problème concernant vos biens.",
      icon: "⚠️",
    },
    {
      title: "Tableau de bord",
      description: "Visualisez les indicateurs clés de performance de votre patrimoine immobilier.",
      icon: "📊",
    },
  ]

  return (
    <>
      <PageHeader
        title="Espace Client"
        description="Accédez à votre espace personnel pour gérer votre patrimoine immobilier"
        breadcrumbs={[{ label: "Espace Client", href: "/espace-client" }]}
        backgroundImage="/property-management-team-discuss.png"
      />

      <section className="py-16">
        <div className="container mx-auto px-4">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold mb-6 text-[#002395]">Gérez votre patrimoine en toute simplicité</h2>
            <p className="text-lg text-gray-700 mb-8 max-w-3xl mx-auto">
              Notre espace client vous permet de suivre et de gérer votre patrimoine immobilier en temps réel, où que
              vous soyez. Accédez à vos documents, suivez vos loyers et communiquez facilement avec votre gestionnaire.
            </p>
            <div className="mb-10">
              <Button
                onClick={() => (window.location.href = "https://doges.monespaceclient.immo/")}
                className="bg-gradient-to-r from-[#002395] to-[#001875] text-white px-8 py-4 rounded-md shadow-md hover:shadow-lg transition-all text-lg"
              >
                Accéder à votre espace client
                <ArrowRight className="ml-2 h-5 w-5" />
              </Button>
            </div>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6 max-w-5xl mx-auto">
            {clientFeatures.map((feature, index) => (
              <div
                key={index}
                className="bg-white rounded-lg shadow-sm p-6 border border-gray-100 hover:shadow-md transition-all"
              >
                <div className="text-4xl mb-4">{feature.icon}</div>
                <h3 className="text-xl font-semibold mb-3">{feature.title}</h3>
                <p className="text-gray-600">{feature.description}</p>
              </div>
            ))}
          </div>

          <div className="mt-16 bg-gray-50 p-8 rounded-xl max-w-3xl mx-auto">
            <h3 className="text-2xl font-bold mb-4 text-[#002395]">Besoin d'aide pour vous connecter ?</h3>
            <p className="text-gray-700 mb-4">
              Si vous rencontrez des difficultés pour accéder à votre espace client ou si vous n'avez pas encore reçu
              vos identifiants, notre équipe est à votre disposition pour vous accompagner.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Button
                onClick={() => (window.location.href = "/contact")}
                variant="outline"
                className="border-[#002395] text-[#002395]"
              >
                Nous contacter
              </Button>
              <Button
                onClick={() => (window.location.href = "tel:+33123456789")}
                variant="outline"
                className="border-[#002395] text-[#002395]"
              >
                Appeler notre service client
              </Button>
            </div>
          </div>
        </div>
      </section>
    </>
  )
}
