import Link from "next/link"
import PageHeader from "@/components/page-header"

export default function MentionsLegalesPage() {
  return (
    <>
      <PageHeader
        title="Mentions Légales"
        description="Informations légales concernant DOGES et l'utilisation de notre site"
        breadcrumbs={[{ label: "Mentions Légales", href: "/mentions-legales" }]}
        backgroundImage="https://images.unsplash.com/photo-1542435503-956c469947f6?q=80&w=2074&auto=format&fit=crop"
      />

      <section className="py-16">
        <div className="container mx-auto px-4 max-w-4xl">
          <div className="bg-white rounded-xl shadow-sm p-8 border border-gray-100">
            <h2 className="text-2xl font-bold mb-6 text-[#002395]">Informations légales</h2>
            <p className="mb-6">
              Conformément aux dispositions des articles 6-III et 19 de la Loi n° 2004-575 du 21 juin 2004 pour la
              Confiance dans l'économie numérique, dite L.C.E.N., nous portons à la connaissance des utilisateurs et
              visiteurs du site les informations suivantes :
            </p>

            <h3 className="text-xl font-semibold mb-3">1. Informations légales</h3>
            <p className="mb-6">
              <strong>Dénomination sociale :</strong> Doges SAS – Société Par Actions Simplifiée au capital de 5000
              euros
              <br />
              <strong>Adresse siège social :</strong> 92, Avenue de Saint-Mandé 75012 PARIS
              <br />
              <strong>SIRET :</strong> 949445571
              <br />
              <strong>RCS :</strong> Créteil sous le numéro 949445571
              <br />
              <strong>N° TVA Intracommunautaire :</strong> FR13949445571
              <br />
              <strong>Email :</strong> contact@dogesadb.fr
              <br />
              <strong>Carte professionnelle :</strong> CPI 7501 2023 000000431 délivrée par la Chambre de Commerce et
              d'Industrie de Paris
              <br />
              <strong>Assurance RCP :</strong> MMA, numéro A148537109, 14, Boulevard Marie et Alexandre Oyon – 72030 Le
              Mans Cedex 9
              <br />
              <strong>Garantie financière :</strong> 120 000 € délivrée par la SOCAF, 26, Avenue de Suffre – 75015 Paris
            </p>

            <h3 className="text-xl font-semibold mb-3">2. Directeur de la publication</h3>
            <p className="mb-6">
              <strong>Nom :</strong> Bedis Iddir
              <br />
              <strong>Fonction :</strong> Directeur de la publication
              <br />
              <strong>Email :</strong> contact@dogesadb.fr
            </p>

            <h3 className="text-xl font-semibold mb-3">3. Hébergement</h3>
            <p className="mb-6">
              <strong>Raison sociale :</strong> O2Switch
              <br />
              <strong>Adresse :</strong> Chem. des Pardiaux, 63000 Clermont-Ferrand
              <br />
              <strong>Site web :</strong> o2switch.fr
            </p>

            <h3 className="text-xl font-semibold mb-3">4. Conditions générales d'utilisation</h3>
            <p className="mb-6">
              L'utilisation du site www.doges.fr implique l'acceptation pleine et entière des conditions générales
              d'utilisation décrites ci-après. Ces conditions d'utilisation sont susceptibles d'être modifiées ou
              complétées à tout moment, les utilisateurs du site sont donc invités à les consulter de manière régulière.
            </p>

            <h3 className="text-xl font-semibold mb-3">5. Propriété intellectuelle</h3>
            <p className="mb-6">
              DOGES est propriétaire des droits de propriété intellectuelle ou détient les droits d'usage sur tous les
              éléments accessibles sur le site, notamment les textes, images, graphismes, logo, icônes, sons, logiciels.
              Toute reproduction, représentation, modification, publication, adaptation de tout ou partie des éléments
              du site, quel que soit le moyen ou le procédé utilisé, est interdite, sauf autorisation écrite préalable
              de DOGES.
            </p>

            <h3 className="text-xl font-semibold mb-3">6. Liens hypertextes et cookies</h3>
            <p className="mb-6">
              Le site www.doges.fr contient un certain nombre de liens hypertextes vers d'autres sites, mis en place
              avec l'autorisation de DOGES. Cependant, DOGES n'a pas la possibilité de vérifier le contenu des sites
              ainsi visités, et n'assumera en conséquence aucune responsabilité de ce fait.
              <br />
              <br />
              La navigation sur le site www.doges.fr est susceptible de provoquer l'installation de cookie(s) sur
              l'ordinateur de l'utilisateur. Un cookie est un fichier de petite taille, qui ne permet pas
              l'identification de l'utilisateur, mais qui enregistre des informations relatives à la navigation d'un
              ordinateur sur un site. Pour en savoir plus sur notre utilisation des cookies, veuillez consulter notre{" "}
              <Link href="/politique-confidentialite" className="text-[#002395] hover:underline">
                politique de confidentialité
              </Link>
              .
            </p>

            <h3 className="text-xl font-semibold mb-3">7. Protection des données personnelles</h3>
            <p className="mb-6">
              DOGES s'engage à respecter la confidentialité des données personnelles communiquées par l'utilisateur et à
              les traiter dans le respect de la loi Informatique et Libertés du 6 janvier 1978 modifiée et du Règlement
              (UE) 2016/679 du Parlement européen et du Conseil du 27 avril 2016 relatif à la protection des personnes
              physiques à l'égard du traitement des données à caractère personnel et à la libre circulation de ces
              données (RGPD).
              <br />
              <br />
              Pour plus d'informations sur la façon dont nous traitons vos données personnelles, veuillez consulter
              notre{" "}
              <Link href="/politique-confidentialite" className="text-[#002395] hover:underline">
                politique de confidentialité
              </Link>
              .
            </p>

            <h3 className="text-xl font-semibold mb-3">8. Loi applicable et juridiction</h3>
            <p className="mb-6">
              Les présentes mentions légales sont régies par la loi française. En cas de litige, les tribunaux français
              seront seuls compétents.
            </p>

            <h3 className="text-xl font-semibold mb-3">9. Contact</h3>
            <p>
              Pour toute question relative aux présentes mentions légales, vous pouvez nous contacter à l'adresse
              suivante : contact@doges.fr ou par courrier à DOGES, 123 Avenue des Champs-Élysées, 75008 Paris.
            </p>
          </div>
        </div>
      </section>
    </>
  )
}
