import Link from "next/link"
import PageHeader from "@/components/page-header"

export default function SiteMapPage() {
  // Update the corePages array with the actual pages
  const corePages = [
    { name: "Accueil", href: "/" },
    {
      name: "À Propos",
      href: "/a-propos",
      description: "Découvrez notre agence et notre expertise",
    },
    {
      name: "Services",
      href: "/services",
      description: "Vue d'ensemble de nos services",
      children: [
        {
          name: "Gestion Locative",
          href: "/services/gestion-locative",
          description: "Notre service principal de gestion locative",
        },
        { name: "Transaction", href: "/services/transaction", description: "Services d'achat et de vente immobilière" },
        { name: "Juridique", href: "/services/juridique", description: "Conseil et assistance juridique" },
        {
          name: "Garantie Loyers Impayés",
          href: "/services/garantie-loyers-impayes",
          description: "Protection contre les impayés",
        },
        { name: "Assurance PNO", href: "/services/assurance-pno", description: "Assurance Propriétaire Non Occupant" },
        {
          name: "Service Commercial",
          href: "/services/service-commercial",
          description: "Services pour biens commerciaux",
        },
        { name: "Professionnels", href: "/services/professionnels", description: "Services dédiés aux professionnels" },
      ],
    },
    {
      name: "Tarifs",
      href: "/tarifs",
      description: "Nos tarifs compétitifs (à partir de 2% HT)",
    },
    {
      name: "Témoignages Clients",
      href: "/temoignages",
      description: "Témoignages détaillés de nos clients",
    },
    {
      name: "Calculateurs",
      href: "/calculateurs",
      description: "Outils de calcul pour vos projets immobiliers",
    },
    {
      name: "FAQ",
      href: "/faq",
      description: "Questions fréquentes par catégorie de service",
    },
    {
      name: "Espace Client",
      href: "/espace-client",
      description: "Portail sécurisé pour les clients existants",
    },
    {
      name: "Contact",
      href: "/contact",
      description: "Formulaire et coordonnées détaillées",
    },
  ]

  // Services régionaux
  const regionalServices = [
    {
      name: "Gestion Locative Paris",
      href: "/services/gestion-locative-paris",
      description: "Services à Paris",
      children: [
        { name: "1er Arrondissement", href: "/services/gestion-locative-paris/1er-arrondissement" },
        { name: "2ème Arrondissement", href: "/services/gestion-locative-paris/2eme-arrondissement" },
        { name: "3ème Arrondissement", href: "/services/gestion-locative-paris/3eme-arrondissement" },
        { name: "4ème Arrondissement", href: "/services/gestion-locative-paris/4eme-arrondissement" },
        { name: "5ème Arrondissement", href: "/services/gestion-locative-paris/5eme-arrondissement" },
        { name: "6ème Arrondissement", href: "/services/gestion-locative-paris/6eme-arrondissement" },
        { name: "7ème Arrondissement", href: "/services/gestion-locative-paris/7eme-arrondissement" },
        { name: "8ème Arrondissement", href: "/services/gestion-locative-paris/8eme-arrondissement" },
        { name: "9ème Arrondissement", href: "/services/gestion-locative-paris/9eme-arrondissement" },
        { name: "10ème Arrondissement", href: "/services/gestion-locative-paris/10eme-arrondissement" },
        { name: "11ème Arrondissement", href: "/services/gestion-locative-paris/11eme-arrondissement" },
        { name: "12ème Arrondissement", href: "/services/gestion-locative-paris/12eme-arrondissement" },
        { name: "13ème Arrondissement", href: "/services/gestion-locative-paris/13eme-arrondissement" },
        { name: "14ème Arrondissement", href: "/services/gestion-locative-paris/14eme-arrondissement" },
        { name: "15ème Arrondissement", href: "/services/gestion-locative-paris/15eme-arrondissement" },
        { name: "16ème Arrondissement", href: "/services/gestion-locative-paris/16eme-arrondissement" },
        { name: "17ème Arrondissement", href: "/services/gestion-locative-paris/17eme-arrondissement" },
        { name: "18ème Arrondissement", href: "/services/gestion-locative-paris/18eme-arrondissement" },
        { name: "19ème Arrondissement", href: "/services/gestion-locative-paris/19eme-arrondissement" },
        { name: "20ème Arrondissement", href: "/services/gestion-locative-paris/20eme-arrondissement" },
      ],
    },
    {
      name: "Administrateur de Biens Paris",
      href: "/services/administrateur-biens-paris",
      description: "Services d'administration à Paris",
      children: [
        { name: "Paris 5-6-7", href: "/services/administrateur-biens-paris-5-6-7" },
        { name: "Paris 13-14-15", href: "/services/administrateur-biens-paris-13-14-15" },
      ],
    },
    {
      name: "Gestion Locative Île-de-France",
      href: "/services/gestion-locative-ile-de-france",
      description: "Services en Île-de-France",
      children: [
        { name: "Neuilly-sur-Seine", href: "/services/gestion-locative-ile-de-france/neuilly-sur-seine" },
        { name: "Levallois-Perret", href: "/services/gestion-locative-ile-de-france/levallois-perret" },
        { name: "Boulogne-Billancourt", href: "/services/gestion-locative-ile-de-france/boulogne-billancourt" },
        { name: "Issy-les-Moulineaux", href: "/services/gestion-locative-ile-de-france/issy-les-moulineaux" },
        { name: "Saint-Cloud", href: "/services/gestion-locative-ile-de-france/saint-cloud" },
        { name: "Sèvres", href: "/services/gestion-locative-ile-de-france/sevres" },
        { name: "Versailles", href: "/services/gestion-locative-ile-de-france/versailles" },
        { name: "Saint-Germain-en-Laye", href: "/services/gestion-locative-ile-de-france/saint-germain-en-laye" },
        { name: "Rueil-Malmaison", href: "/services/gestion-locative-ile-de-france/rueil-malmaison" },
        { name: "Courbevoie", href: "/services/gestion-locative-ile-de-france/courbevoie" },
        { name: "Puteaux", href: "/services/gestion-locative-ile-de-france/puteaux" },
        { name: "Suresnes", href: "/services/gestion-locative-ile-de-france/suresnes" },
        { name: "Nanterre", href: "/services/gestion-locative-ile-de-france/nanterre" },
        { name: "Vincennes", href: "/services/gestion-locative-ile-de-france/vincennes" },
        { name: "Saint-Mandé", href: "/services/gestion-locative-ile-de-france/saint-mande" },
        { name: "Montreuil", href: "/services/gestion-locative-ile-de-france/montreuil" },
        { name: "Asnières-sur-Seine", href: "/services/gestion-locative-ile-de-france/asnieres-sur-seine" },
        { name: "Clichy", href: "/services/gestion-locative-ile-de-france/clichy" },
        { name: "La Défense", href: "/services/gestion-locative-ile-de-france/la-defense" },
        { name: "Antony", href: "/services/gestion-locative-ile-de-france/antony" },
      ],
    },
    {
      name: "Gestion Locative France",
      href: "/services/gestion-locative-france",
      description: "Services dans toute la France",
      children: [
        { name: "Lyon", href: "/services/gestion-locative-france/lyon" },
        { name: "Marseille", href: "/services/gestion-locative-france/marseille" },
        { name: "Toulouse", href: "/services/gestion-locative-france/toulouse" },
        { name: "Nice", href: "/services/gestion-locative-france/nice" },
        { name: "Nantes", href: "/services/gestion-locative-france/nantes" },
        { name: "Strasbourg", href: "/services/gestion-locative-france/strasbourg" },
        { name: "Montpellier", href: "/services/gestion-locative-france/montpellier" },
        { name: "Bordeaux", href: "/services/gestion-locative-france/bordeaux" },
        { name: "Lille", href: "/services/gestion-locative-france/lille" },
        { name: "Rennes", href: "/services/gestion-locative-france/rennes" },
        { name: "Aix-en-Provence", href: "/services/gestion-locative-france/aix-en-provence" },
      ],
    },
    {
      name: "Administrateur de Biens Paris",
      href: "/services/administrateur-biens-paris",
      description: "Administration à Paris",
    },
    {
      name: "Administrateur de Biens Hauts-de-Seine",
      href: "/services/administrateur-biens-hauts-de-seine",
      description: "Administration dans le 92",
    },
    {
      name: "Administrateur de Biens Val-d'Oise",
      href: "/services/administrateur-biens-val-doise",
      description: "Administration dans le 95",
    },
    {
      name: "Syndic de Copropriété Paris",
      href: "/services/syndic-copropriete-paris",
      description: "Gestion de copropriétés à Paris",
    },
    {
      name: "Administrateur de Biens Île-de-France",
      href: "/services/administrateur-biens-ile-de-france",
      description: "Administration en Île-de-France",
    },
    {
      name: "Gestion Immobilière Professionnelle",
      href: "/services/gestion-immobiliere-professionnelle",
      description: "Services professionnels",
    },
    {
      name: "Assurance Loyers Impayés",
      href: "/services/assurance-loyers-impayes",
      description: "Protection contre les impayés",
    },
  ]

  // Update the secondaryPages array with actual pages
  const secondaryPages = [
    {
      name: "Comparatif Gestionnaires",
      href: "/comparatif-gestionnaires-immobiliers",
      description: "Comparez les différents gestionnaires immobiliers",
    },
    {
      name: "Trouver un Gestionnaire",
      href: "/trouver-gestionnaire-immobilier",
      description: "Aide à la recherche d'un gestionnaire immobilier",
    },
    {
      name: "Carrières",
      href: "/carrieres",
      description: "Offres d'emploi et culture d'entreprise",
    },
  ]

  // Blog pages
  const blogPages = [
    {
      name: "Blog",
      href: "/blog",
      description: "Articles sur le marché immobilier et conseils",
      children: [
        { name: "Recherche", href: "/blog/search", description: "Rechercher des articles" },
        {
          name: "Carte Interactive Paris",
          href: "/blog/carte-interactive-paris",
          description: "Carte des quartiers de Paris",
        },
        {
          name: "Données Locatives Paris",
          href: "/blog/donnees-locatives-paris",
          description: "Statistiques locatives à Paris",
        },
        { name: "Catégorie Guide", href: "/blog/categories/guide", description: "Articles guides et tutoriels" },
        {
          name: "Catégorie Réglementation",
          href: "/blog/categories/reglementation",
          description: "Articles sur la réglementation",
        },
        {
          name: "Catégorie Investissement",
          href: "/blog/categories/investissement",
          description: "Articles sur l'investissement",
        },
        { name: "Catégorie Fiscalité", href: "/blog/categories/fiscalite", description: "Articles sur la fiscalité" },
        {
          name: "Catégorie Gestion Locative",
          href: "/blog/categories/gestion-locative",
          description: "Articles sur la gestion locative",
        },
        { name: "Catégorie Assurance", href: "/blog/categories/assurance", description: "Articles sur les assurances" },
        {
          name: "Catégorie Rénovation",
          href: "/blog/categories/renovation",
          description: "Articles sur la rénovation",
        },
      ],
    },
  ]

  // Blog articles
  const blogArticles = [
    { name: "Guide Propriétaire Bailleur 2025", href: "/blog/articles/guide-proprietaire-bailleur-2025" },
    { name: "Guide Propriétaire Bailleur 2024", href: "/blog/articles/guide-proprietaire-bailleur-2024" },
    { name: "DPE 2024 - Changements", href: "/blog/articles/dpe-2024-changements-proprietaires" },
    { name: "Erreurs en Gestion Locative", href: "/blog/articles/erreurs-gestion-locative-eviter" },
    { name: "Obligations Transition Énergétique", href: "/blog/articles/obligations-transition-energetique" },
    { name: "Obligations Énergétiques 2024", href: "/blog/articles/obligations-energetiques-proprietaires-2024" },
    {
      name: "Calculer Rentabilité Investissement",
      href: "/blog/articles/calculer-rentabilite-investissement-locatif-paris",
    },
    { name: "LMNP vs LMP", href: "/blog/articles/lmnp-lmp-comparaison-statuts" },
    { name: "Gestion Locative: Déléguer?", href: "/blog/articles/gestion-locative-soi-meme-ou-deleguer" },
    { name: "Éviter Impayés Loyer", href: "/blog/articles/eviter-impayes-loyer-guide" },
    { name: "Avantages Fiscaux Location Meublée", href: "/blog/articles/avantages-fiscaux-location-meublee" },
    { name: "Investir Ancien vs Neuf", href: "/blog/articles/investir-ancien-vs-neuf-ile-de-france" },
    { name: "IFI et Immobilier Locatif", href: "/blog/articles/ifi-immobilier-locatif" },
    { name: "Encadrement Loyers Paris", href: "/blog/articles/encadrement-loyers-paris-bilan" },
    { name: "Optimisation Fiscale 2024", href: "/blog/articles/optimisation-fiscale-proprietaires-2024" },
    { name: "Assurance Loyers Impayés 2024", href: "/blog/articles/assurance-loyers-impayes-2024" },
    { name: "Meilleurs Quartiers Paris 2024", href: "/blog/articles/meilleurs-quartiers-paris-investir-2024" },
    { name: "Investir en Île-de-France 2024", href: "/blog/articles/investir-immobilier-ile-de-france-2024" },
    { name: "Travaux Rénovation et Valeur", href: "/blog/articles/travaux-renovation-valeur-locative" },
    { name: "Colocation: Avantages Fiscaux", href: "/blog/articles/colocation-avantages-fiscaux-gestion" },
    { name: "Exemple de Guide Pratique", href: "/blog/articles/exemple-howto-guide" },
  ]

  // Update the legalPages array with actual pages
  const legalPages = [
    { name: "Mentions Légales", href: "/mentions-legales" },
    { name: "Politique de Confidentialité", href: "/politique-confidentialite" },
    { name: "Plan du Site", href: "/plan-site" },
  ]

  return (
    <>
      <PageHeader
        title="Plan du Site"
        description="Retrouvez l'ensemble des pages de notre site pour une navigation facilitée."
        breadcrumbs={[{ label: "Plan du Site", href: "/plan-site" }]}
      />

      <section className="py-16">
        <div className="container mx-auto px-4">
          <div className="grid md:grid-cols-2 gap-16">
            {/* Core Pages */}
            <div>
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Pages Principales</h2>
              <ul className="space-y-6">
                {corePages.map((page) => (
                  <li key={page.href} className="border-b border-gray-200 pb-6">
                    <Link href={page.href} className="text-lg font-semibold hover:text-[#002395] transition-colors">
                      {page.name}
                    </Link>
                    {page.description && <p className="text-gray-600 mt-1">{page.description}</p>}

                    {/* Child pages */}
                    {page.children && (
                      <ul className="mt-3 pl-6 space-y-2">
                        {page.children.map((child) => (
                          <li key={child.href}>
                            <Link href={child.href} className="text-gray-700 hover:text-[#002395] transition-colors">
                              {child.name}
                            </Link>
                            {child.description && (
                              <span className="text-gray-500 text-sm ml-2">— {child.description}</span>
                            )}
                          </li>
                        ))}
                      </ul>
                    )}
                  </li>
                ))}
              </ul>

              <h2 className="text-2xl font-bold my-6 text-[#002395]">Services par Région</h2>
              <ul className="space-y-6">
                {regionalServices.map((service) => (
                  <li key={service.href} className="border-b border-gray-200 pb-6">
                    <Link href={service.href} className="text-lg font-semibold hover:text-[#002395] transition-colors">
                      {service.name}
                    </Link>
                    {service.description && <p className="text-gray-600 mt-1">{service.description}</p>}

                    {/* Child pages - with show more/less for long lists */}
                    {service.children && (
                      <div className="mt-3 pl-6">
                        <details>
                          <summary className="cursor-pointer text-sm font-medium text-[#002395] mb-2">
                            Voir les villes/arrondissements ({service.children.length})
                          </summary>
                          <ul className="space-y-2 mt-2">
                            {service.children.map((child) => (
                              <li key={child.href}>
                                <Link
                                  href={child.href}
                                  className="text-gray-700 hover:text-[#002395] transition-colors"
                                >
                                  {child.name}
                                </Link>
                              </li>
                            ))}
                          </ul>
                        </details>
                      </div>
                    )}
                  </li>
                ))}
              </ul>
            </div>

            {/* Secondary, Blog and Legal Pages */}
            <div>
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Pages Secondaires</h2>
              <ul className="space-y-6 mb-12">
                {secondaryPages.map((page) => (
                  <li key={page.href} className="border-b border-gray-200 pb-6">
                    <Link href={page.href} className="text-lg font-semibold hover:text-[#002395] transition-colors">
                      {page.name}
                    </Link>
                    {page.description && <p className="text-gray-600 mt-1">{page.description}</p>}
                  </li>
                ))}
              </ul>

              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Blog</h2>
              <ul className="space-y-6 mb-6">
                {blogPages.map((page) => (
                  <li key={page.href} className="border-b border-gray-200 pb-6">
                    <Link href={page.href} className="text-lg font-semibold hover:text-[#002395] transition-colors">
                      {page.name}
                    </Link>
                    {page.description && <p className="text-gray-600 mt-1">{page.description}</p>}
                    {page.children && (
                      <ul className="mt-3 pl-6 space-y-2">
                        {page.children.map((child) => (
                          <li key={child.href}>
                            <Link href={child.href} className="text-gray-700 hover:text-[#002395] transition-colors">
                              {child.name}
                            </Link>
                            {child.description && (
                              <span className="text-gray-500 text-sm ml-2">— {child.description}</span>
                            )}
                          </li>
                        ))}
                      </ul>
                    )}
                  </li>
                ))}
              </ul>

              <h3 className="text-xl font-bold mb-4 text-[#002395]">Articles de Blog</h3>
              <div className="mb-12">
                <details>
                  <summary className="cursor-pointer text-sm font-medium text-[#002395] mb-4">
                    Voir tous les articles ({blogArticles.length})
                  </summary>
                  <ul className="grid grid-cols-1 gap-2 pl-4">
                    {blogArticles.map((article) => (
                      <li key={article.href}>
                        <Link href={article.href} className="text-gray-700 hover:text-[#002395] transition-colors">
                          {article.name}
                        </Link>
                      </li>
                    ))}
                  </ul>
                </details>
              </div>

              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Informations Légales</h2>
              <ul className="space-y-4">
                {legalPages.map((page) => (
                  <li key={page.href}>
                    <Link href={page.href} className="text-gray-700 hover:text-[#002395] transition-colors">
                      {page.name}
                    </Link>
                  </li>
                ))}
              </ul>
            </div>
          </div>
        </div>
      </section>
    </>
  )
}
