import PageHeader from "@/components/page-header"

export default function PolitiqueConfidentialitePage() {
  return (
    <>
      <PageHeader
        title="Politique de Confidentialité"
        description="Informations concernant la protection de vos données et l'utilisation de notre site"
        breadcrumbs={[{ label: "Politique de Confidentialité", href: "/politique-confidentialite" }]}
        backgroundImage="https://images.unsplash.com/photo-1512758017271-d7b84c2113f1?q=80&w=2070&auto=format&fit=crop"
      />

      <section className="py-16">
        <div className="container mx-auto px-4 max-w-4xl">
          <div className="bg-white rounded-xl shadow-sm p-8 border border-gray-100">
            <h2 className="text-2xl font-bold mb-6 text-[#002395]">Propriété intellectuelle</h2>
            <p className="mb-6">
              Le Site appartient et est exploité par Doges SAS. Tous les éléments composant le Site, y incluant les
              marques, logos, noms de domaine et autres signes distinctifs apparaissant sur le Site sont protégés par la
              législation en vigueur sur la propriété intellectuelle et le droit d'auteur, et appartiennent à Doges SAS
              ou font l'objet d'une autorisation d'utilisation. Tous les droits de reproduction sont réservés. La
              reproduction sur support papier est autorisée sous réserve de respecter l'intégralité des documents
              reproduits (pas de modification ni d'altération).
            </p>

            <p className="mb-6">
              Toute exploitation non autorisée du Site ou de son contenu engagerait votre responsabilité et
              constituerait une contrefaçon sanctionnée par les articles L335-2 et suivants du Code de la Propriété
              Intellectuelle.
            </p>

            <h2 className="text-2xl font-bold mb-6 text-[#002395]">Limitations de responsabilité</h2>
            <p className="mb-6">
              Doges SAS ne peut garantir l'exactitude, la complétude, l'actualité des informations diffusées sur le
              Site. Doges SAS met tout en œuvre pour diffuser des informations exactes et mises à jour. Vous
              reconnaissez utiliser ces informations sous votre responsabilité.
            </p>

            <p className="mb-6">
              Doges SAS propose aux utilisateurs un contenu informatif sous différentes formes : des articles, des
              infographies, des simulations de loyer ou des indices de rentabilité locative. Ces contenus visent à
              fournir aux utilisateurs des informations pratiques, à améliorer leurs connaissances générales de
              l'immobilier et à les aider à préparer, à élaborer et à conduire leurs projets immobiliers.
            </p>

            <p className="mb-6">
              Doges SAS sélectionne puis délivre ces informations à titre purement indicatif ; en aucun cas le contenu
              présenté n'a vocation à être exhaustif. Compte tenu de l'évolution permanente des règles juridiques en
              matière d'immobilier et de fiscalité, Doges SAS ne garantit en aucune façon ni l'exactitude ni
              l'actualisation des informations fournies. De plus, la pertinence des simulations de loyer s'apprécie
              individuellement, en regard de chaque situation particulière d'un utilisateur, notamment de son profil et
              de la nature de son projet.
            </p>

            <p className="mb-6">Doges SAS ne peut être tenue responsable :</p>
            <ul className="list-disc pl-6 mb-6">
              <li>des erreurs ou omissions des informations diffusées sur le Site ;</li>
              <li>des dommages directs ou indirects qui pourraient résulter de l'accès ou de l'utilisation du Site.</li>
            </ul>

            <h2 className="text-2xl font-bold mb-6 text-[#002395]">Biens immobiliers</h2>
            <p className="mb-6">
              Les informations données sur le Site n'ont pas un caractère contractuel. Les caractéristiques des biens à
              louer ainsi que leur prix, bien que faisant l'objet d'une attention particulière, sont données sous
              réserve d'erreurs de saisie ou de disponibilité au moment de leur consultation.
            </p>

            <h2 className="text-2xl font-bold mb-6 text-[#002395]">Disponibilité du site</h2>
            <p className="mb-6">
              Le Site est accessible 24 heures sur 24 et 7 jours sur 7 à l'exception des cas de force majeure,
              difficultés informatiques, difficultés liées aux réseaux de télécommunications ou difficultés techniques.
              Pour des raisons de maintenance, Doges SAS pourra interrompre l'accès au Site.
            </p>

            <p className="mb-6">Doges SAS ne pourra voir sa responsabilité engagée :</p>
            <ul className="list-disc pl-6 mb-6">
              <li>
                en cas d'interruption, momentanée ou définitive, de l'accès et de la disponibilité du Site, notamment
                pour des besoins de maintenance technique, d'actualisation des informations publiées ou de toute
                évolution nécessitant l'interruption du service ;
              </li>
              <li>
                ce, quels que soient les dommages éventuels causés à l'utilisateur qui résulterait des contenus, de
                l'impossibilité d'accès, ou de l'utilisation du Site.
              </li>
            </ul>

            <h2 className="text-2xl font-bold mb-6 text-[#002395]">Avis diffusés sur le site internet</h2>
            <p className="mb-6">
              Les avis diffusés sur le Site sont recueillis, vérifiés et gérés par des applications tierces (Trustpilot,
              Google, Facebook). Ils ont été sélectionnés par Doges SAS.
            </p>

            <p className="mb-6">
              Ces avis ne font pas l'objet de contrepartie financière. Leurs auteurs ne sont pas rémunérés par Doges
              SAS.
            </p>

            <h2 className="text-2xl font-bold mb-6 text-[#002395]">Election de domicile</h2>
            <p className="mb-6">
              Pour l'exécution du présent acte et de ses suites, les parties font élection de domicile en leurs demeures
              respectives.
            </p>

            <h2 className="text-2xl font-bold mb-6 text-[#002395]">Loi applicable</h2>
            <p className="mb-6">
              Le contenu du Site est assujetti au droit applicable en France. Tout utilisateur reconnaît la compétence
              du tribunal compétent de Paris pour tout ce qui concerne le contenu et l'utilisation du Site ou les
              recours en découlant.
            </p>

            <div className="mt-8 pt-6 border-t border-gray-200">
              <p>
                Pour toute question relative à notre politique de confidentialité, vous pouvez nous contacter à
                l'adresse suivante :{" "}
                <a href="mailto:contact@doges.fr" className="text-[#002395] hover:underline">
                  contact@doges.fr
                </a>{" "}
                ou par courrier à DOGES, 92, Avenue de Saint-Mandé 75012 PARIS.
              </p>
            </div>
          </div>
        </div>
      </section>
    </>
  )
}
