"use client"

import { useEffect } from "react"

export default function RedirectPolitiqueConfidentialite() {
  useEffect(() => {
    // Force la redirection côté client
    window.location.href = "/politique-confidentialite"
  }, [])

  return (
    <div className="min-h-screen flex items-center justify-center">
      <div className="text-center">
        <h1 className="text-2xl font-bold mb-4">Redirection en cours...</h1>
        <p>Vous allez être redirigé vers notre page Politique de Confidentialité.</p>
        <p className="mt-4">
          Si la redirection ne fonctionne pas,{" "}
          <a
            href="/politique-confidentialite"
            className="text-blue-600 hover:underline"
            onClick={(e) => {
              e.preventDefault()
              window.location.href = "/politique-confidentialite"
            }}
          >
            cliquez ici
          </a>
        </p>
      </div>
    </div>
  )
}
