import type { Metadata } from "next"
import Link from "next/link"
import ServiceHeader from "@/components/service-header"

export const metadata: Metadata = {
  title: "Administrateur de Biens Immeubles Haussmanniens Paris | DOGES",
  description:
    "Expertise spécialisée pour la gestion des immeubles haussmanniens à Paris. Administration de biens adaptée aux problématiques particulières du patrimoine haussmannien.",
  alternates: {
    canonical: "https://www.doges.fr/services/administrateur-biens-immeubles-haussmanniens",
  },
}

export default function AdministrateurBiensImmeublesHaussmanniensPage() {
  return (
    <div className="min-h-screen bg-gray-50">
      {/* En-tête de page avec image de fond */}
      <ServiceHeader
        title="Administrateur de Biens Immeubles Haussmanniens"
        description="Expertise spécifique pour la gestion des immeubles haussmanniens et leurs problématiques particulières"
        breadcrumbItems={[
          { name: "Accueil", url: "/" },
          { name: "Services", url: "/services" },
          { name: "Immeubles Haussmanniens", url: "/services/administrateur-biens-immeubles-haussmanniens" },
        ]}
        backgroundImage="https://images.unsplash.com/photo-1502602898536-47ad22581b52?q=80&w=2073&auto=format&fit=crop"
      />

      {/* Contenu principal */}
      <div className="container mx-auto px-4 py-12">
        <div className="grid grid-cols-1 lg:grid-cols-3 gap-8">
          {/* Main Content */}
          <div className="lg:col-span-2">
            <section className="mb-12">
              <h2 className="text-2xl font-bold text-[#002395] mb-6">L'expertise DOGES des immeubles haussmanniens</h2>

              <div className="bg-white p-6 rounded-lg shadow-md mb-8">
                <h3 className="text-xl font-semibold mb-3 text-[#002395]">Un patrimoine architectural unique</h3>
                <p className="text-gray-600 mb-4">
                  <strong>XIXe siècle - Architecture emblématique de Paris</strong>
                </p>
                <p className="text-gray-600 mb-4">
                  Les immeubles haussmanniens constituent l'essence même du paysage urbain parisien. Construits entre
                  1850 et 1870 sous l'impulsion du Baron Haussmann, ces bâtiments présentent des caractéristiques
                  architecturales et techniques spécifiques qui nécessitent une expertise particulière en matière de
                  gestion et d'administration.
                </p>
                <p className="text-gray-600">
                  DOGES a développé une expertise unique dans la gestion de ce patrimoine exceptionnel, maîtrisant
                  parfaitement les contraintes techniques, réglementaires et patrimoniales liées à ces immeubles
                  d'exception.
                </p>
              </div>

              <div className="bg-white p-6 rounded-lg shadow-md mb-8">
                <h3 className="text-xl font-semibold mb-3 text-[#002395]">
                  Les spécificités des immeubles haussmanniens
                </h3>
                <p className="text-gray-600 mb-4">
                  La gestion des immeubles haussmanniens présente des défis particuliers :
                </p>
                <ul className="list-disc pl-6 space-y-2 text-gray-600">
                  <li>Architecture et matériaux d'époque nécessitant un savoir-faire spécialisé</li>
                  <li>Contraintes patrimoniales et réglementaires strictes</li>
                  <li>Systèmes techniques anciens à moderniser avec précaution</li>
                  <li>Copropriétés complexes avec de nombreux lots</li>
                  <li>Travaux de restauration et de mise aux normes spécifiques</li>
                  <li>Valorisation patrimoniale et optimisation énergétique</li>
                </ul>
              </div>
            </section>

            <section className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Nos services spécialisés</h2>

              <div className="grid md:grid-cols-2 gap-6">
                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">Syndic spécialisé haussmannien</h3>
                  <ul className="list-disc pl-6 space-y-2 text-gray-600">
                    <li>Expertise des contraintes patrimoniales</li>
                    <li>Gestion des travaux de restauration</li>
                    <li>Relations avec les Architectes des Bâtiments de France</li>
                    <li>Assemblées générales adaptées aux enjeux</li>
                    <li>Optimisation des charges historiques</li>
                    <li>Conseil en valorisation patrimoniale</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">Gestion locative patrimoniale</h3>
                  <ul className="list-disc pl-6 space-y-2 text-gray-600">
                    <li>Sélection de locataires respectueux du patrimoine</li>
                    <li>Gestion d'appartements de caractère</li>
                    <li>Entretien préventif et curatif spécialisé</li>
                    <li>Respect des contraintes architecturales</li>
                    <li>Valorisation des éléments d'époque</li>
                    <li>Locations meublées haut de gamme</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">Travaux et rénovation</h3>
                  <ul className="list-disc pl-6 space-y-2 text-gray-600">
                    <li>Diagnostic technique spécialisé</li>
                    <li>Planification des travaux de restauration</li>
                    <li>Sélection d'artisans qualifiés</li>
                    <li>Respect des techniques traditionnelles</li>
                    <li>Mise aux normes respectueuse du patrimoine</li>
                    <li>Amélioration énergétique adaptée</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">Conseil patrimonial</h3>
                  <ul className="list-disc pl-6 space-y-2 text-gray-600">
                    <li>Valorisation du patrimoine haussmannien</li>
                    <li>Optimisation fiscale spécialisée</li>
                    <li>Stratégie de transmission</li>
                    <li>Conseil en investissement patrimonial</li>
                    <li>Expertise en monuments historiques</li>
                    <li>Montage de dossiers de défiscalisation</li>
                  </ul>
                </div>
              </div>
            </section>

            <section className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">
                Les caractéristiques des immeubles haussmanniens
              </h2>

              <div className="space-y-6">
                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">Architecture et structure</h3>
                  <p className="text-gray-600 mb-4">
                    Les immeubles haussmanniens présentent des caractéristiques architecturales distinctives :
                  </p>
                  <ul className="list-disc pl-6 space-y-1 text-gray-600">
                    <li>Façades en pierre de taille avec modénatures</li>
                    <li>Hauteur uniforme de 6 étages sur rez-de-chaussée</li>
                    <li>Balcons filants aux 2e et 5e étages</li>
                    <li>Toitures en zinc avec lucarnes</li>
                    <li>Cours d'honneur et escaliers d'apparat</li>
                    <li>Appartements traversants avec beaux volumes</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">Défis techniques spécifiques</h3>
                  <p className="text-gray-600 mb-4">
                    La gestion technique des immeubles haussmanniens nécessite une expertise particulière :
                  </p>
                  <ul className="list-disc pl-6 space-y-1 text-gray-600">
                    <li>Réseaux anciens à moderniser (plomberie, électricité)</li>
                    <li>Isolation thermique respectueuse du patrimoine</li>
                    <li>Entretien des façades en pierre de taille</li>
                    <li>Réfection des toitures en zinc</li>
                    <li>Mise aux normes ascenseurs et sécurité</li>
                    <li>Gestion de l'humidité et des infiltrations</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">Contraintes réglementaires</h3>
                  <p className="text-gray-600 mb-4">
                    Les immeubles haussmanniens sont soumis à des réglementations spécifiques :
                  </p>
                  <ul className="list-disc pl-6 space-y-1 text-gray-600">
                    <li>Protection au titre des sites et monuments</li>
                    <li>Autorisation préalable pour les travaux de façade</li>
                    <li>Respect du Plan Local d'Urbanisme parisien</li>
                    <li>Contraintes des Architectes des Bâtiments de France</li>
                    <li>Réglementations sur les matériaux et techniques</li>
                    <li>Obligations de conservation des éléments patrimoniaux</li>
                  </ul>
                </div>
              </div>
            </section>

            <section className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Notre réseau de partenaires spécialisés</h2>

              <div className="bg-white p-6 rounded-lg shadow-md mb-6">
                <h3 className="text-xl font-semibold mb-3 text-[#002395]">Artisans et entreprises qualifiés</h3>
                <p className="text-gray-600 mb-4">
                  DOGES travaille avec un réseau sélectionné de professionnels spécialisés dans le patrimoine
                  haussmannien :
                </p>
                <ul className="list-disc pl-6 space-y-2 text-gray-600">
                  <li>Tailleurs de pierre et restaurateurs de façades</li>
                  <li>Couvreurs spécialisés en zinc et ardoise</li>
                  <li>Menuisiers experts en fenêtres d'époque</li>
                  <li>Plombiers et électriciens patrimoniaux</li>
                  <li>Architectes du patrimoine et bureaux d'études</li>
                  <li>Entreprises de ravalement agréées monuments historiques</li>
                </ul>
              </div>

              <div className="bg-white p-6 rounded-lg shadow-md">
                <h3 className="text-xl font-semibold mb-3 text-[#002395]">Expertise technique et juridique</h3>
                <p className="text-gray-600 mb-4">
                  Notre équipe maîtrise tous les aspects de la gestion haussmannienne :
                </p>
                <ul className="list-disc pl-6 space-y-2 text-gray-600">
                  <li>Diagnostics techniques spécialisés</li>
                  <li>Montage de dossiers de subventions patrimoine</li>
                  <li>Négociation avec les assurances spécialisées</li>
                  <li>Conseil en défiscalisation monuments historiques</li>
                  <li>Accompagnement dans les démarches administratives</li>
                  <li>Veille réglementaire patrimoine et urbanisme</li>
                </ul>
              </div>
            </section>
          </div>

          {/* Sidebar */}
          <div className="lg:col-span-1">
            <div className="sticky top-8 space-y-6">
              <div className="bg-white p-6 rounded-lg shadow-md">
                <h3 className="text-lg font-semibold mb-4 text-[#002395]">Besoin d'aide ?</h3>
                <p className="mb-4 text-gray-600">
                  Nos experts du patrimoine haussmannien sont à votre disposition pour la gestion de vos biens
                  d'exception.
                </p>
                <Link
                  href="/contact"
                  className="block w-full py-3 px-4 bg-[#002395] text-white text-center rounded-md hover:bg-blue-800 transition-colors"
                >
                  Nous contacter
                </Link>
              </div>

              <div className="bg-white p-6 rounded-lg shadow-md">
                <h3 className="text-lg font-semibold mb-4 text-[#002395]">Services associés</h3>
                <ul className="space-y-3">
                  <li>
                    <Link href="/services/administrateur-biens-paris" className="text-[#002395] hover:underline">
                      Administrateur de biens Paris
                    </Link>
                  </li>
                  <li>
                    <Link href="/services/administrateur-biens-paris-centre" className="text-[#002395] hover:underline">
                      Administrateur de biens Paris Centre
                    </Link>
                  </li>
                  <li>
                    <Link
                      href="/services/administrateur-biens-paris-8-16-17"
                      className="text-[#002395] hover:underline"
                    >
                      Administrateur de biens Paris 8-16-17
                    </Link>
                  </li>
                  <li>
                    <Link href="/services/syndic-copropriete-paris" className="text-[#002395] hover:underline">
                      Syndic de copropriété Paris
                    </Link>
                  </li>
                </ul>
              </div>

              <div className="bg-white p-6 rounded-lg shadow-md">
                <h3 className="text-lg font-semibold mb-4 text-[#002395]">Avantages fiscaux</h3>
                <p className="mb-4 text-gray-600 text-sm">
                  Les immeubles haussmanniens peuvent bénéficier d'avantages fiscaux spécifiques :
                </p>
                <ul className="space-y-2 text-sm text-gray-600">
                  <li>• Défiscalisation Malraux</li>
                  <li>• Monuments Historiques</li>
                  <li>• Déficit foncier</li>
                  <li>• Subventions ANAH</li>
                </ul>
              </div>
            </div>
          </div>
        </div>

        {/* CTA Section */}
        <section className="mt-16 text-center">
          <div className="bg-[#002395] text-white p-8 rounded-lg">
            <h2 className="text-2xl font-bold mb-4">Vous possédez un immeuble haussmannien ?</h2>
            <p className="mb-6 text-lg">
              Bénéficiez de notre expertise spécialisée pour valoriser et préserver votre patrimoine exceptionnel.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Link
                href="/contact"
                className="bg-white text-[#002395] px-8 py-3 rounded-lg font-semibold hover:bg-gray-100 transition-colors"
              >
                Demander un devis
              </Link>
              <Link
                href="/services/transaction"
                className="border-2 border-white text-white px-8 py-3 rounded-lg font-semibold hover:bg-white hover:text-[#002395] transition-colors"
              >
                Estimation gratuite
              </Link>
            </div>
          </div>
        </section>
      </div>
    </div>
  )
}
