import Image from "next/image"

const AdministrateurBiensParis = () => {
  return (
    <div className="container mx-auto py-12">
      <h1 className="text-3xl font-bold text-center mb-8">Administrateur de Biens à Paris 5, 6 et 7</h1>

      <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
        {/* Left Column: Text Content */}
        <div>
          <p className="mb-4">
            Vous recherchez un administrateur de biens de confiance à Paris 5, 6 ou 7 ? Notre agence immobilière est
            spécialisée dans la gestion locative et l'administration de biens immobiliers dans ces quartiers prestigieux
            de Paris.
          </p>
          <p className="mb-4">
            Nous offrons une gamme complète de services pour les propriétaires, incluant la recherche de locataires, la
            gestion des contrats de location, le recouvrement des loyers, la gestion des travaux et la représentation
            auprès des syndics de copropriété.
          </p>
          <p className="mb-4">
            Notre connaissance approfondie du marché immobilier parisien et notre engagement envers un service
            personnalisé font de nous le partenaire idéal pour la gestion de vos biens immobiliers.
          </p>
          <p className="mb-4">
            Contactez-nous dès aujourd'hui pour discuter de vos besoins et découvrir comment nous pouvons vous aider à
            optimiser la rentabilité de vos investissements immobiliers.
          </p>
        </div>

        {/* Right Column: Image */}
        <div>
          <Image
            src="https://images.unsplash.com/photo-1582741114644-794df08514e9?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" // Replace with an appropriate Unsplash image URL
            alt="Appartement Parisien"
            width={700}
            height={500}
            className="rounded-lg shadow-md"
            style={{
              maxWidth: "100%",
              height: "auto",
            }}
          />
        </div>
      </div>

      {/* Services Section */}
      <div className="mt-12">
        <h2 className="text-2xl font-bold text-center mb-4">Nos Services</h2>
        <ul className="list-disc list-inside">
          <li>Recherche de locataires</li>
          <li>Gestion des contrats de location</li>
          <li>Recouvrement des loyers</li>
          <li>Gestion des travaux</li>
          <li>Représentation auprès des syndics de copropriété</li>
          <li>Suivi administratif et comptable</li>
        </ul>
      </div>

      {/* Call to Action */}
      <div className="mt-12 text-center">
        <p className="text-lg">
          Confiez la gestion de vos biens immobiliers à des experts. Contactez-nous pour une consultation gratuite.
        </p>
        <a
          href="/contact"
          className="inline-block bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded mt-4"
        >
          Contactez-nous
        </a>
      </div>
    </div>
  )
}

export default AdministrateurBiensParis
