import type { Metadata } from "next"
import Link from "next/link"
import  PageHeader  from "@/components/page-header"

export const metadata: Metadata = {
  title: "Administrateur de Biens Paris 8e, 16e, 17e | DOGES",
  description:
    "Services d'administration de biens immobiliers dans l'Ouest parisien (8e, 16e, 17e arrondissements). Quartiers résidentiels de standing et immeubles de prestige.",
  alternates: {
    canonical: "https://www.doges.fr/services/administrateur-biens-paris-8-16-17",
  },
}

export default function AdministrateurBiensParis81617Page() {
  return (
    <div className="min-h-screen bg-gray-50">
      {/* En-tête de page avec image de fond */}
      <PageHeader
        title="Administrateur de Biens Paris 8e, 16e, 17e"
        description="Expertise des quartiers résidentiels de l'Ouest parisien et immeubles de standing"
        breadcrumbs={[
          { label: "Services", href: "/services" },
          { label: "Administrateur de Biens Paris", href: "/services/administrateur-biens-paris" },
          { label: "Paris 8e, 16e et 17e", href: "/services/administrateur-biens-paris-8-16-17" },
        ]}
        backgroundImage="https://images.unsplash.com/photo-1502602898536-47ad22581b52?q=80&w=2073&auto=format&fit=crop"
      />

      {/* Contenu principal */}
      <div className="container mx-auto px-4 py-12">
        <div className="grid grid-cols-1 lg:grid-cols-3 gap-8">
          {/* Main Content */}
          <div className="lg:col-span-2">
            <section className="mb-12">
              <h2 className="text-2xl font-bold text-[#002395] mb-6">
                L'Ouest parisien : 8e, 16e et 17e arrondissements
              </h2>

              <div className="bg-white p-6 rounded-lg shadow-md mb-8">
                <h3 className="text-xl font-semibold mb-3 text-[#002395]">Les quartiers résidentiels de prestige</h3>
                <p className="text-gray-600 mb-4">
                  <strong>Champs-Élysées, Trocadéro, Passy, Monceau, Batignolles</strong>
                </p>
                <p className="text-gray-600 mb-4">
                  Les 8e, 16e et 17e arrondissements constituent l'Ouest parisien, réputé pour ses quartiers
                  résidentiels de standing et ses immeubles haussmanniens de prestige. Ces arrondissements attirent une
                  clientèle aisée, française et internationale, à la recherche de qualité de vie et de prestations haut
                  de gamme.
                </p>
                <p className="text-gray-600">
                  Du Triangle d'Or aux jardins du Trocadéro, en passant par les parcs Monceau et les Batignolles, ces
                  quartiers offrent un cadre de vie exceptionnel avec de nombreux espaces verts, commerces de luxe et
                  établissements scolaires réputés.
                </p>
              </div>

              <div className="bg-white p-6 rounded-lg shadow-md mb-8">
                <h3 className="text-xl font-semibold mb-3 text-[#002395]">Un marché immobilier haut de gamme</h3>
                <p className="text-gray-600 mb-4">Le marché immobilier de l'Ouest parisien se caractérise par :</p>
                <ul className="list-disc pl-6 space-y-2 text-gray-600">
                  <li>Prix au m² élevés, reflet de la qualité des biens et des quartiers</li>
                  <li>Demande soutenue de familles et d'investisseurs internationaux</li>
                  <li>Immeubles haussmanniens parfaitement entretenus</li>
                  <li>Appartements familiaux avec de beaux volumes</li>
                  <li>Prestations haut de gamme et services de conciergerie</li>
                  <li>Stabilité des prix et potentiel de valorisation durable</li>
                </ul>
              </div>
            </section>

            <section className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Nos services adaptés aux quartiers de standing</h2>

              <div className="grid md:grid-cols-2 gap-6">
                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">Gestion locative haut de gamme</h3>
                  <ul className="list-disc pl-6 space-y-2 text-gray-600">
                    <li>Sélection de locataires de qualité</li>
                    <li>Gestion d'appartements familiaux de standing</li>
                    <li>Services de conciergerie et maintenance</li>
                    <li>Gestion des locations meublées de luxe</li>
                    <li>Suivi personnalisé et reporting détaillé</li>
                    <li>Relations privilégiées avec les gardiens</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">Syndic de copropriétés de prestige</h3>
                  <ul className="list-disc pl-6 space-y-2 text-gray-600">
                    <li>Gestion d'immeubles haussmanniens</li>
                    <li>Travaux de rénovation et embellissement</li>
                    <li>Gestion des services de conciergerie</li>
                    <li>Assemblées générales de qualité</li>
                    <li>Suivi des charges et optimisation</li>
                    <li>Relations avec les copropriétaires exigeants</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">Transaction résidentielle</h3>
                  <ul className="list-disc pl-6 space-y-2 text-gray-600">
                    <li>Estimation d'appartements familiaux</li>
                    <li>Marketing ciblé et discret</li>
                    <li>Réseau d'acquéreurs qualifiés</li>
                    <li>Visites accompagnées et sécurisées</li>
                    <li>Négociation et conseil juridique</li>
                    <li>Accompagnement personnalisé</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">Conseil patrimonial familial</h3>
                  <ul className="list-disc pl-6 space-y-2 text-gray-600">
                    <li>Optimisation fiscale résidence principale</li>
                    <li>Conseil en investissement familial</li>
                    <li>Transmission patrimoniale</li>
                    <li>Valorisation et rénovation</li>
                    <li>Montage SCI familiales</li>
                    <li>Stratégie d'acquisition</li>
                  </ul>
                </div>
              </div>
            </section>

            <section className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Notre connaissance des arrondissements</h2>

              <div className="space-y-6">
                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">8e arrondissement - Élysée</h3>
                  <p className="text-gray-600 mb-4">
                    Quartier prestigieux des Champs-Élysées, Triangle d'Or et Faubourg Saint-Honoré. Immeubles
                    haussmanniens de grand standing et commerces de luxe.
                  </p>
                  <ul className="list-disc pl-6 space-y-1 text-gray-600">
                    <li>Appartements avec vue sur les Champs-Élysées</li>
                    <li>Immeubles de prestige avenue Montaigne</li>
                    <li>Bureaux et commerces de luxe</li>
                    <li>Résidences sécurisées avec services</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">16e arrondissement - Passy</h3>
                  <p className="text-gray-600 mb-4">
                    Arrondissement résidentiel par excellence, prisé des familles pour ses écoles, parcs et qualité de
                    vie. Immeubles bourgeois et appartements familiaux.
                  </p>
                  <ul className="list-disc pl-6 space-y-1 text-gray-600">
                    <li>Appartements familiaux avec balcons</li>
                    <li>Immeubles avec jardins et cours</li>
                    <li>Résidences près des écoles internationales</li>
                    <li>Duplex et triplex de standing</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">17e arrondissement - Batignolles</h3>
                  <p className="text-gray-600 mb-4">
                    Arrondissement en pleine transformation, mêlant quartiers bourgeois traditionnels et nouveaux
                    écoquartiers. Attractif pour les familles et jeunes actifs.
                  </p>
                  <ul className="list-disc pl-6 space-y-1 text-gray-600">
                    <li>Appartements près du parc Monceau</li>
                    <li>Nouveaux programmes écologiques</li>
                    <li>Immeubles rénovés des Batignolles</li>
                    <li>Bureaux et espaces de coworking</li>
                  </ul>
                </div>
              </div>
            </section>
          </div>

          {/* Sidebar */}
          <div className="lg:col-span-1">
            <div className="sticky top-8 space-y-6">
              <div className="bg-white p-6 rounded-lg shadow-md">
                <h3 className="text-lg font-semibold mb-4 text-[#002395]">Besoin d'aide ?</h3>
                <p className="mb-4 text-gray-600">
                  Nos experts de l'Ouest parisien sont à votre disposition pour la gestion de vos biens de standing.
                </p>
                <Link
                  href="/contact"
                  className="block w-full py-3 px-4 bg-[#002395] text-white text-center rounded-md hover:bg-blue-800 transition-colors"
                >
                  Nous contacter
                </Link>
              </div>

              <div className="bg-white p-6 rounded-lg shadow-md">
                <h3 className="text-lg font-semibold mb-4 text-[#002395]">Services associés</h3>
                <ul className="space-y-3">
                  <li>
                    <Link href="/services/administrateur-biens-paris" className="text-[#002395] hover:underline">
                      Administrateur de biens Paris
                    </Link>
                  </li>
                  <li>
                    <Link href="/services/administrateur-biens-paris-centre" className="text-[#002395] hover:underline">
                      Administrateur de biens Paris Centre
                    </Link>
                  </li>
                  <li>
                    <Link
                      href="/services/administrateur-biens-immeubles-haussmanniens"
                      className="text-[#002395] hover:underline"
                    >
                      Immeubles haussmanniens
                    </Link>
                  </li>
                  <li>
                    <Link href="/services/gestion-locative-paris" className="text-[#002395] hover:underline">
                      Gestion locative Paris
                    </Link>
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </div>

        {/* CTA Section */}
        <section className="mt-16 text-center">
          <div className="bg-[#002395] text-white p-8 rounded-lg">
            <h2 className="text-2xl font-bold mb-4">Vous possédez un bien dans l'Ouest parisien ?</h2>
            <p className="mb-6 text-lg">
              Bénéficiez de notre expertise des quartiers de standing pour optimiser la gestion de votre patrimoine.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Link
                href="/contact"
                className="bg-white text-[#002395] px-8 py-3 rounded-lg font-semibold hover:bg-gray-100 transition-colors"
              >
                Demander un devis
              </Link>
              <Link
                href="/services/transaction"
                className="border-2 border-white text-white px-8 py-3 rounded-lg font-semibold hover:bg-white hover:text-[#002395] transition-colors"
              >
                Estimation gratuite
              </Link>
            </div>
          </div>
        </section>
      </div>
    </div>
  )
}
