import type { Metadata } from "next"
import Link from "next/link"
import  PageHeader  from "@/components/page-header"

export const metadata: Metadata = {
  title: "Administrateur de Biens Paris 9e, 10e, 18e | DOGES",
  description:
    "Services d'administration de biens immobiliers dans le Nord de Paris (9e, 10e, 18e arrondissements). Quartiers en mutation entre tradition et dynamisme urbain.",
  alternates: {
    canonical: "https://www.doges.fr/services/administrateur-biens-paris-9-10-18",
  },
}

export default function AdministrateurBiensParis91018Page() {
  return (
    <div className="min-h-screen bg-gray-50">
      {/* En-tête de page avec image de fond */}
      <PageHeader
        title="Administrateur de Biens Paris 9e, 10e, 18e"
        description="Gestion de proximité pour des quartiers en pleine mutation, entre tradition et dynamisme urbain"
        breadcrumbs={[
          { label: "Services", href: "/services" },
          { label: "Administrateur de Biens Paris", href: "/services/administrateur-biens-paris" },
          { label: "Paris 9e, 10e et 18e", href: "/services/administrateur-biens-paris-9-10-18" },
        ]}
        backgroundImage="https://images.unsplash.com/photo-1502602898536-47ad22581b52?q=80&w=2073&auto=format&fit=crop"
      />

      {/* Contenu principal */}
      <div className="container mx-auto px-4 py-12">
        <div className="grid grid-cols-1 lg:grid-cols-3 gap-8">
          {/* Main Content */}
          <div className="lg:col-span-2">
            <section className="mb-12">
              <h2 className="text-2xl font-bold text-[#002395] mb-6">
                Le Nord de Paris : 9e, 10e et 18e arrondissements
              </h2>

              <div className="bg-white p-6 rounded-lg shadow-md mb-8">
                <h3 className="text-xl font-semibold mb-3 text-[#002395]">Des quartiers en pleine transformation</h3>
                <p className="text-gray-600 mb-4">
                  <strong>Opéra, République, Montmartre, Canal Saint-Martin</strong>
                </p>
                <p className="text-gray-600 mb-4">
                  Les 9e, 10e et 18e arrondissements forment un ensemble dynamique du Nord parisien, caractérisé par une
                  forte diversité urbaine et sociale. Ces quartiers connaissent une transformation remarquable, attirant
                  de nouveaux habitants séduits par leur authenticité et leur potentiel.
                </p>
                <p className="text-gray-600">
                  Du quartier de l'Opéra aux pentes de Montmartre, en passant par les berges du Canal Saint-Martin, ces
                  arrondissements offrent un mélange unique entre patrimoine historique, vie culturelle intense et
                  modernité urbaine.
                </p>
              </div>

              <div className="bg-white p-6 rounded-lg shadow-md mb-8">
                <h3 className="text-xl font-semibold mb-3 text-[#002395]">Un marché immobilier en évolution</h3>
                <p className="text-gray-600 mb-4">
                  Le marché immobilier du Nord parisien présente des opportunités intéressantes :
                </p>
                <ul className="list-disc pl-6 space-y-2 text-gray-600">
                  <li>Prix au m² plus accessibles que dans le centre de Paris</li>
                  <li>Forte demande locative de jeunes actifs et créatifs</li>
                  <li>Potentiel de valorisation important dans les secteurs en mutation</li>
                  <li>Diversité architecturale : haussmannien, années 30, contemporain</li>
                  <li>Excellente desserte en transports en commun</li>
                  <li>Dynamisme commercial et culturel croissant</li>
                </ul>
              </div>
            </section>

            <section className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Nos services adaptés aux quartiers en mutation</h2>

              <div className="grid md:grid-cols-2 gap-6">
                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">Gestion locative dynamique</h3>
                  <ul className="list-disc pl-6 space-y-2 text-gray-600">
                    <li>Ciblage de locataires jeunes actifs</li>
                    <li>Gestion d'appartements rénovés et atypiques</li>
                    <li>Locations meublées pour une clientèle mobile</li>
                    <li>Suivi technique adapté aux immeubles anciens</li>
                    <li>Optimisation des délais de relocation</li>
                    <li>Gestion des colocations et espaces partagés</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">Syndic de copropriétés mixtes</h3>
                  <ul className="list-disc pl-6 space-y-2 text-gray-600">
                    <li>Gestion d'immeubles en cours de rénovation</li>
                    <li>Accompagnement des projets de valorisation</li>
                    <li>Gestion des copropriétés mixtes (logements/commerces)</li>
                    <li>Assemblées générales participatives</li>
                    <li>Optimisation énergétique et travaux</li>
                    <li>Relations avec des copropriétaires diversifiés</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">Transaction et investissement</h3>
                  <ul className="list-disc pl-6 space-y-2 text-gray-600">
                    <li>Estimation de biens en cours de valorisation</li>
                    <li>Conseil en investissement locatif</li>
                    <li>Accompagnement primo-accédants</li>
                    <li>Négociation et sécurisation</li>
                    <li>Expertise des biens atypiques</li>
                    <li>Conseil en rénovation et aménagement</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">Conseil en valorisation</h3>
                  <ul className="list-disc pl-6 space-y-2 text-gray-600">
                    <li>Optimisation fiscale investissement</li>
                    <li>Stratégie de rénovation rentable</li>
                    <li>Conseil en aménagement d'espaces</li>
                    <li>Accompagnement projets de division</li>
                    <li>Analyse du potentiel de valorisation</li>
                    <li>Montage financier et défiscalisation</li>
                  </ul>
                </div>
              </div>
            </section>

            <section className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Notre expertise des arrondissements du Nord</h2>

              <div className="space-y-6">
                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">9e arrondissement - Opéra</h3>
                  <p className="text-gray-600 mb-4">
                    Quartier central mêlant bureaux, commerces et résidences. Secteur Pigalle en pleine gentrification
                    et quartier de l'Opéra prestigieux.
                  </p>
                  <ul className="list-disc pl-6 space-y-1 text-gray-600">
                    <li>Appartements haussmanniens près de l'Opéra</li>
                    <li>Lofts et espaces atypiques à Pigalle</li>
                    <li>Bureaux et commerces boulevard Haussmann</li>
                    <li>Immeubles rénovés Nouvelle Athènes</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">10e arrondissement - Enclos-St-Laurent</h3>
                  <p className="text-gray-600 mb-4">
                    Arrondissement en pleine mutation avec le Canal Saint-Martin, République et les nouveaux quartiers
                    branchés. Très prisé des jeunes actifs.
                  </p>
                  <ul className="list-disc pl-6 space-y-1 text-gray-600">
                    <li>Appartements avec vue sur le canal</li>
                    <li>Lofts industriels réhabilités</li>
                    <li>Immeubles familiaux près des écoles</li>
                    <li>Espaces de coworking et commerces</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">18e arrondissement - Butte-Montmartre</h3>
                  <p className="text-gray-600 mb-4">
                    Arrondissement contrasté entre Montmartre touristique et quartiers populaires en transformation.
                    Fort potentiel de valorisation.
                  </p>
                  <ul className="list-disc pl-6 space-y-1 text-gray-600">
                    <li>Appartements avec vue sur Paris</li>
                    <li>Maisons et ateliers d'artistes</li>
                    <li>Immeubles en cours de rénovation</li>
                    <li>Nouveaux programmes près des métros</li>
                  </ul>
                </div>
              </div>
            </section>
          </div>

          {/* Sidebar */}
          <div className="lg:col-span-1">
            <div className="sticky top-8 space-y-6">
              <div className="bg-white p-6 rounded-lg shadow-md">
                <h3 className="text-lg font-semibold mb-4 text-[#002395]">Besoin d'aide ?</h3>
                <p className="mb-4 text-gray-600">
                  Nos experts du Nord parisien sont à votre disposition pour optimiser votre investissement.
                </p>
                <Link
                  href="/contact"
                  className="block w-full py-3 px-4 bg-[#002395] text-white text-center rounded-md hover:bg-blue-800 transition-colors"
                >
                  Nous contacter
                </Link>
              </div>

              <div className="bg-white p-6 rounded-lg shadow-md">
                <h3 className="text-lg font-semibold mb-4 text-[#002395]">Services associés</h3>
                <ul className="space-y-3">
                  <li>
                    <Link href="/services/administrateur-biens-paris" className="text-[#002395] hover:underline">
                      Administrateur de biens Paris
                    </Link>
                  </li>
                  <li>
                    <Link href="/services/administrateur-biens-paris-19" className="text-[#002395] hover:underline">
                      Administrateur de biens Paris 19e
                    </Link>
                  </li>
                  <li>
                    <Link
                      href="/services/administrateur-biens-paris-11-12-20"
                      className="text-[#002395] hover:underline"
                    >
                      Administrateur de biens Paris 11-12-20
                    </Link>
                  </li>
                  <li>
                    <Link href="/services/gestion-locative-paris" className="text-[#002395] hover:underline">
                      Gestion locative Paris
                    </Link>
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </div>

        {/* CTA Section */}
        <section className="mt-16 text-center">
          <div className="bg-[#002395] text-white p-8 rounded-lg">
            <h2 className="text-2xl font-bold mb-4">Vous possédez un bien dans le Nord de Paris ?</h2>
            <p className="mb-6 text-lg">
              Profitez de notre expertise locale pour maximiser le potentiel de votre patrimoine immobilier.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Link
                href="/contact"
                className="bg-white text-[#002395] px-8 py-3 rounded-lg font-semibold hover:bg-gray-100 transition-colors"
              >
                Demander un devis
              </Link>
              <Link
                href="/services/transaction"
                className="border-2 border-white text-white px-8 py-3 rounded-lg font-semibold hover:bg-white hover:text-[#002395] transition-colors"
              >
                Estimation gratuite
              </Link>
            </div>
          </div>
        </section>
      </div>
    </div>
  )
}
