type VilleData = {
  nom: string
  slug: string
  region: string
  shortDescription?: string
  description: string
  quartiers: string[]
  image?: string
  statistiques?: {
    prixMoyen?: number
    delaiLocation?: string
    tauxVacance?: string
    rendementMoyen?: string
  }
  particularites?: string[]
  typologieDemandee?: string[]
  transportCommun?: string[]
  pointsInteret?: string[]
  tendances?: string
}

export const villesData: VilleData[] = [
  {
    nom: "Paris",
    slug: "paris",
    region: "Île-de-France",
    shortDescription: "La capitale française, centre économique et culturel de premier plan.",
    description:
      "Paris, capitale de la France, est une des villes les plus attractives au monde pour l'investissement locatif. Le marché parisien est caractérisé par une forte demande et une offre limitée, ce qui assure une excellente valorisation des biens et un faible taux de vacance locative.",
    quartiers: [
      "Le Marais",
      "Saint-Germain-des-Prés",
      "Montmartre",
      "Bastille",
      "Quartier Latin",
      "Batignolles",
      "Butte-aux-Cailles",
      "Belleville",
    ],
    statistiques: {
      prixMoyen: 11500,
      delaiLocation: "7 à 14 jours",
      tauxVacance: "3,2%",
      rendementMoyen: "2,5% à 3,5%",
    },
    particularites: [
      "Demande locative très forte, notamment chez les cadres et étudiants",
      "Encadrement des loyers en vigueur",
      "Marché très concurrentiel pour les petites surfaces",
      "Valorisation patrimoniale exceptionnelle sur le long terme",
    ],
    typologieDemandee: [
      "Studios et 2 pièces pour étudiants et jeunes actifs",
      "3 et 4 pièces pour familles dans l'ouest parisien",
      "Appartements haussmanniens avec cachet",
    ],
    transportCommun: [
      "Réseau de métro dense avec 16 lignes",
      "RER connectant Paris à sa banlieue",
      "Nombreuses lignes de bus",
      "Vélib' et pistes cyclables en développement",
    ],
    pointsInteret: [
      "Monuments emblématiques (Tour Eiffel, Arc de Triomphe)",
      "Musées de renommée mondiale (Louvre, Orsay)",
      "Grandes écoles et universités prestigieuses",
      "Quartiers d'affaires dynamiques (La Défense)",
    ],
    tendances:
      "Le marché parisien reste robuste malgré les fluctuations économiques. La tendance est à la rénovation énergétique des biens anciens et à la valorisation des espaces extérieurs depuis la crise sanitaire.",
  },
  {
    nom: "Lyon",
    slug: "lyon",
    region: "Auvergne-Rhône-Alpes",
    shortDescription: "Métropole dynamique avec un riche patrimoine historique et gastronomique.",
    description:
      "Lyon, troisième ville de France, est un pôle économique majeur avec un marché immobilier dynamique. Sa qualité de vie, son patrimoine classé UNESCO et son développement économique en font une destination prisée pour l'investissement locatif.",
    quartiers: ["Presqu'île", "Vieux Lyon", "Croix-Rousse", "Confluence", "Part-Dieu", "Gerland", "Brotteaux", "Vaise"],
    statistiques: {
      prixMoyen: 5400,
      delaiLocation: "15 à 25 jours",
      tauxVacance: "4,1%",
      rendementMoyen: "3,8% à 4,5%",
    },
    particularites: [
      "Forte demande locative étudiante (150 000 étudiants)",
      "Marché dynamisé par les cadres et professions libérales",
      "Développement de quartiers neufs (Confluence)",
      "Bonne valorisation patrimoniale des biens anciens",
    ],
    typologieDemandee: [
      "Studios et T2 pour étudiants près des campus",
      "Appartements canut dans la Croix-Rousse",
      "Biens avec extérieur dans les quartiers résidentiels",
    ],
  },
  {
    nom: "Marseille",
    slug: "marseille",
    region: "Provence-Alpes-Côte d'Azur",
    shortDescription: "Principale ville méditerranéenne française en pleine mutation urbaine.",
    description:
      "Marseille, deuxième ville de France, connaît une importante transformation urbaine qui redynamise son marché immobilier. La cité phocéenne bénéficie d'un cadre exceptionnel entre mer et collines, avec un ensoleillement record.",
    quartiers: ["Vieux-Port", "Le Panier", "Prado", "Vauban", "Castellane", "Endoume", "Joliette", "Belle de Mai"],
    statistiques: {
      prixMoyen: 3900,
      delaiLocation: "20 à 30 jours",
      tauxVacance: "5,2%",
      rendementMoyen: "4,5% à 6%",
    },
  },
  {
    nom: "Bordeaux",
    slug: "bordeaux",
    region: "Nouvelle-Aquitaine",
    shortDescription: "Ville élégante en plein essor grâce à ses excellentes connexions.",
    description:
      "Bordeaux a connu une métamorphose spectaculaire ces dernières années, devenant l'une des villes les plus attractives de France. Son patrimoine architectural exceptionnel, sa qualité de vie et son dynamisme économique attirent de nombreux investisseurs.",
    quartiers: [
      "Centre historique",
      "Les Chartrons",
      "Saint-Michel",
      "Bastide",
      "Les Quinconces",
      "Saint-Pierre",
      "Mériadeck",
      "Caudéran",
    ],
    statistiques: {
      prixMoyen: 4800,
      delaiLocation: "15 à 25 jours",
      tauxVacance: "3,8%",
      rendementMoyen: "3,5% à 4,2%",
    },
  },
  {
    nom: "Toulouse",
    slug: "toulouse",
    region: "Occitanie",
    shortDescription: "Capitale de l'aéronautique avec un marché immobilier dynamique.",
    description:
      "Toulouse, surnommée la ville rose, est le cœur de l'industrie aéronautique et spatiale française. Son dynamisme économique, sa population jeune et sa qualité de vie en font une ville très attractive pour l'investissement locatif.",
    quartiers: [
      "Capitole",
      "Saint-Cyprien",
      "Carmes",
      "Saint-Michel",
      "Compans-Caffarelli",
      "Rangueil",
      "Minimes",
      "Ponts-Jumeaux",
    ],
    statistiques: {
      prixMoyen: 3700,
      delaiLocation: "15 à 20 jours",
      tauxVacance: "3,5%",
      rendementMoyen: "4,2% à 5,0%",
    },
  },
  {
    nom: "Nice",
    slug: "nice",
    region: "Provence-Alpes-Côte d'Azur",
    shortDescription: "Joyau de la Côte d'Azur avec un marché immobilier haut de gamme.",
    description:
      "Nice, située sur la Côte d'Azur, bénéficie d'un climat exceptionnel et d'un cadre de vie prisé. Son marché immobilier est porté par une clientèle nationale et internationale, avec une forte demande pour les locations saisonnières et à l'année.",
    quartiers: [
      "Promenade des Anglais",
      "Vieux-Nice",
      "Carré d'Or",
      "Cimiez",
      "Libération",
      "Musiciens",
      "Port",
      "Mont Boron",
    ],
    statistiques: {
      prixMoyen: 4500,
      delaiLocation: "15 à 25 jours",
      tauxVacance: "4,0%",
      rendementMoyen: "3,8% à 5,0%",
    },
  },
  {
    nom: "Nantes",
    slug: "nantes",
    region: "Pays de la Loire",
    shortDescription: "Ville verte et créative avec un marché immobilier en plein essor.",
    description:
      "Nantes s'est imposée comme l'une des villes les plus dynamiques de l'ouest français. Son attractivité économique, sa politique urbaine innovante et sa qualité de vie en font une destination de choix pour les investisseurs immobiliers.",
    quartiers: [
      "Centre-ville",
      "Île de Nantes",
      "Graslin",
      "Bouffay",
      "Chantenay",
      "Procé",
      "Hauts-Pavés",
      "Saint-Donatien",
    ],
    statistiques: {
      prixMoyen: 3900,
      delaiLocation: "15 à 20 jours",
      tauxVacance: "3,3%",
      rendementMoyen: "4,0% à 4,8%",
    },
  },
  {
    nom: "Strasbourg",
    slug: "strasbourg",
    region: "Grand Est",
    shortDescription: "Capitale européenne avec un patrimoine exceptionnel.",
    description:
      "Strasbourg, siège de plusieurs institutions européennes, bénéficie d'un rayonnement international. Son centre historique classé à l'UNESCO, son économie dynamique et sa position frontalière en font un marché immobilier attractif et stable.",
    quartiers: [
      "Grande Île",
      "Petite France",
      "Krutenau",
      "Quartier Européen",
      "Neudorf",
      "Robertsau",
      "Contades",
      "Orangerie",
    ],
    statistiques: {
      prixMoyen: 3500,
      delaiLocation: "15 à 25 jours",
      tauxVacance: "3,7%",
      rendementMoyen: "4,2% à 5,0%",
    },
  },
  {
    nom: "Montpellier",
    slug: "montpellier",
    region: "Occitanie",
    shortDescription: "Ville universitaire méditerranéenne en forte croissance.",
    description:
      "Montpellier connaît l'une des plus fortes croissances démographiques de France. Son climat méditerranéen, ses nombreux étudiants et son secteur de la santé florissant en font un marché locatif particulièrement dynamique.",
    quartiers: [
      "Écusson",
      "Antigone",
      "Beaux-Arts",
      "Boutonnet",
      "Port Marianne",
      "Arceaux",
      "Gambetta",
      "Aiguelongue",
    ],
    statistiques: {
      prixMoyen: 3300,
      delaiLocation: "15 à 20 jours",
      tauxVacance: "3,5%",
      rendementMoyen: "4,5% à 5,5%",
    },
  },
  {
    nom: "Lille",
    slug: "lille",
    region: "Hauts-de-France",
    shortDescription: "Métropole du nord reconnue pour son dynamisme économique et culturel.",
    description:
      "Lille est le centre économique et culturel du nord de la France. Sa position stratégique près de la Belgique, son important pôle universitaire et son dynamisme économique en font une ville attractive pour l'investissement locatif.",
    quartiers: [
      "Vieux-Lille",
      "Centre",
      "Wazemmes",
      "Moulins",
      "Fives",
      "Saint-Maurice",
      "Bois-Blancs",
      "Vauban-Esquermes",
    ],
    statistiques: {
      prixMoyen: 3200,
      delaiLocation: "15 à 25 jours",
      tauxVacance: "3,9%",
      rendementMoyen: "4,5% à 5,5%",
    },
  },
]
