import type { Metadata } from "next"
import { ConsultationCTA } from "@/components/consultation-cta"
import { villesData } from "./villes-data"
import TableOfContentsWidget from "@/components/table-of-contents-widget"
import ContactWidget from "@/components/contact-widget"
import FeeCalculator from "@/components/fee-calculator"
import ServicesSidebarWidgets from "@/components/services-sidebar-widgets"
import ServiceHeader from "@/components/service-header"
import VilleCard from "@/components/ville-card"
import Image from "next/image"

export const metadata: Metadata = {
  title: "Gestion Locative Île-de-France | DOGES",
  description:
    "Services de gestion locative professionnelle en Île-de-France. Confiez la gestion de votre bien immobilier à DOGES, administrateur de biens.",
  openGraph: {
    title: "Gestion Locative Île-de-France | DOGES",
    description:
      "Services de gestion locative professionnelle en Île-de-France. Confiez la gestion de votre bien immobilier à DOGES, administrateur de biens.",
    url: "https://www.dogesadb.fr/services/gestion-locative-ile-de-france",
    siteName: "DOGES",
    locale: "fr_FR",
    type: "website",
  },
}

export default function GestionLocativeIleDeFrancePage() {
  // Définir les éléments de la table des matières
  const tocItems = [
    { id: "presentation", title: "Présentation" },
    { id: "services-par-ville", title: "Services par ville" },
    { id: "pourquoi-choisir", title: "Pourquoi nous choisir" },
  ]

  // Définir les éléments du fil d'Ariane
  const breadcrumbItems = [
    { name: "Accueil", url: "/" },
    { name: "Services", url: "/services" },
    { name: "Gestion Locative Île-de-France", url: "/services/gestion-locative-ile-de-france" },
  ]

  // Image de l'en-tête générée par le service de placeholder
  const headerImageUrl = `/placeholder.svg?height=600&width=1200&query=immobilier ile de france`

  return (
    <div className="bg-white">
      {/* En-tête de service standardisé */}
      <ServiceHeader
        title="Gestion Locative en Île-de-France"
        description="Services professionnels de gestion locative dans toute l'Île-de-France. Confiez la gestion de votre patrimoine immobilier à nos experts."
        breadcrumbItems={breadcrumbItems}
        backgroundImage={headerImageUrl}
      />

      <div className="container mx-auto px-4 py-8">
        <div className="grid grid-cols-1 lg:grid-cols-3 gap-8">
          {/* Contenu principal */}
          <div className="lg:col-span-2">
            <div id="presentation" className="mb-12">
              <div className="relative h-80 w-full mb-6 rounded-lg overflow-hidden">
                <Image
                  src={`/placeholder.svg?height=400&width=800&query=gestion locative ile de france`}
                  alt="Gestion locative en Île-de-France"
                  width={800}
                  height={400}
                  className="w-full h-80 object-cover rounded-lg"
                />
              </div>
              <p className="mb-4 text-lg">
                DOGES vous propose des services de gestion locative professionnelle dans toute l'Île-de-France. Notre
                équipe d'experts connaît parfaitement le marché immobilier local et vous accompagne dans la gestion
                quotidienne de votre bien, que ce soit à Paris ou dans les communes environnantes.
              </p>
              <p className="mb-4">
                Avec notre expertise locale et notre approche personnalisée, nous vous garantissons une gestion optimale
                de votre patrimoine immobilier. Découvrez nos services de gestion locative dans les principales villes
                d'Île-de-France.
              </p>
            </div>

            <h2 id="services-par-ville" className="text-2xl font-bold mb-6">
              Nos services de gestion locative par ville
            </h2>

            <div className="grid grid-cols-1 md:grid-cols-2 gap-6 mb-12">
              {villesData.map((ville) => (
                <VilleCard key={ville.slug} nom={ville.nom} slug={ville.slug} description={ville.description} />
              ))}
            </div>

            <div id="pourquoi-choisir" className="mb-12">
              <h2 className="text-2xl font-bold mb-4">
                Pourquoi choisir DOGES pour la gestion locative en Île-de-France ?
              </h2>
              <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
                <div className="bg-gray-50 p-6 rounded-lg">
                  <h3 className="text-xl font-semibold mb-2">Expertise locale</h3>
                  <p>
                    Notre équipe connaît parfaitement les spécificités du marché immobilier de chaque ville
                    d'Île-de-France.
                  </p>
                </div>
                <div className="bg-gray-50 p-6 rounded-lg">
                  <h3 className="text-xl font-semibold mb-2">Service sur mesure</h3>
                  <p>
                    Nous adaptons nos services à vos besoins spécifiques et aux particularités de votre bien immobilier.
                  </p>
                </div>
                <div className="bg-gray-50 p-6 rounded-lg">
                  <h3 className="text-xl font-semibold mb-2">Proximité et réactivité</h3>
                  <p>Notre présence dans toute l'Île-de-France nous permet d'intervenir rapidement en cas de besoin.</p>
                </div>
              </div>
            </div>

            <ConsultationCTA
              title="Besoin d'un gestionnaire locatif en Île-de-France ?"
              description="Contactez-nous pour une consultation personnalisée et sans engagement."
              buttonText="Prendre rendez-vous"
              buttonLink="/contact"
            />
          </div>

          {/* Sidebar avec widgets */}
          <div className="space-y-6">
            <TableOfContentsWidget items={tocItems} />
            <FeeCalculator />
            <ContactWidget />
            <ServicesSidebarWidgets />
          </div>
        </div>
      </div>
    </div>
  )
}
