type VilleData = {
  nom: string
  slug: string
  description: string
  quartiers: string[]
  image?: string
  statistiques?: {
    prixMoyen?: number // Prix moyen au m²
    delaiLocation?: string // Délai moyen de location
    tauxVacance?: string // Taux de vacance locative
    rendementMoyen?: string // Rendement locatif moyen
  }
  particularites?: string[] // Particularités du marché local
  typologieDemandee?: string[] // Types de biens les plus demandés
  transportCommun?: string[] // Principaux transports en commun
  pointsInteret?: string[] // Points d'intérêt notables
  tendances?: string // Tendances du marché local
}

export const villesData: VilleData[] = [
  {
    nom: "Neuilly-sur-Seine",
    slug: "neuilly-sur-seine",
    description:
      "Neuilly-sur-Seine est une commune résidentielle haut de gamme située aux portes de Paris. Le marché immobilier y est particulièrement dynamique avec des biens de standing recherchés par une clientèle exigeante.",
    quartiers: ["Sablons", "Saint-James", "Bagatelle", "Bois de Boulogne", "Île de la Jatte"],
    image: "/villes/neuilly-sur-seine.jpg",
    statistiques: {
      prixMoyen: 11500, // 11 500€/m²
      delaiLocation: "2 à 3 semaines",
      tauxVacance: "2.1%",
      rendementMoyen: "2.8%",
    },
    particularites: [
      "Marché immobilier haut de gamme",
      "Forte demande pour les grands appartements familiaux",
      "Proximité avec les écoles internationales",
      "Environnement sécurisé et prisé",
    ],
    typologieDemandee: [
      "Appartements familiaux 4-5 pièces",
      "Appartements avec terrasse ou jardin",
      "Immeubles haussmanniens",
    ],
    transportCommun: ["Métro Ligne 1 (Les Sablons, Pont de Neuilly)", "Bus 43, 73, 82, 93", "Proximité du RER C"],
    pointsInteret: ["Bois de Boulogne", "Île de la Jatte", "Avenue Charles de Gaulle", "Jardin d'Acclimatation"],
    tendances:
      "Marché stable avec une légère hausse des prix, demande soutenue pour les biens de qualité avec extérieur depuis la crise sanitaire.",
  },
  {
    nom: "Levallois-Perret",
    slug: "levallois-perret",
    description:
      "Levallois-Perret est une commune attractive qui allie dynamisme économique et qualité de vie. Son marché locatif est porté par la présence de nombreuses entreprises et sa proximité avec Paris et La Défense.",
    quartiers: ["Front de Seine", "Centre-Ville", "Eiffel", "Villiers", "Greffuhle"],
    image: "/villes/levallois-perret.jpg",
    statistiques: {
      prixMoyen: 9800, // 9 800€/m²
      delaiLocation: "2 à 4 semaines",
      tauxVacance: "2.5%",
      rendementMoyen: "3.2%",
    },
    particularites: [
      "Forte présence d'entreprises internationales",
      "Mixité entre habitat et bureaux",
      "Nombreux commerces et services de proximité",
      "Ville densément peuplée et bien aménagée",
    ],
    typologieDemandee: [
      "Studios et 2 pièces pour jeunes actifs",
      "Appartements 3-4 pièces pour familles",
      "Logements récents avec prestations modernes",
    ],
    transportCommun: [
      "Métro Ligne 3 (Louise Michel, Anatole France, Pont de Levallois)",
      "Bus 53, 93, 167",
      "Proximité du RER C",
    ],
    pointsInteret: ["Parc de la Planchette", "Berges de Seine", "Centre commercial So Ouest", "Hôtel de Ville"],
    tendances:
      "Marché dynamique avec une demande soutenue, notamment pour les petites et moyennes surfaces. Attractivité croissante pour les cadres travaillant à La Défense.",
  },
  {
    nom: "Boulogne-Billancourt",
    slug: "boulogne-billancourt",
    description:
      "Boulogne-Billancourt est la première ville des Hauts-de-Seine en termes de population. Son marché immobilier est diversifié, allant des appartements haussmanniens aux constructions contemporaines.",
    quartiers: ["Centre-Ville", "Billancourt", "Les Princes", "République", "Rives de Seine"],
    image: "/villes/boulogne-billancourt.jpg",
  },
  {
    nom: "Issy-les-Moulineaux",
    slug: "issy-les-moulineaux",
    description:
      "Issy-les-Moulineaux est une ville en pleine mutation, devenue un pôle d'innovation numérique. Son parc immobilier se modernise constamment avec de nombreux programmes neufs.",
    quartiers: ["Centre-Ville", "Les Épinettes", "Les Hauts d'Issy", "Val de Seine", "Corentin Celton"],
    image: "/villes/issy-les-moulineaux.jpg",
  },
  {
    nom: "Saint-Cloud",
    slug: "saint-cloud",
    description:
      "Saint-Cloud est une commune résidentielle prisée pour son cadre verdoyant et ses vues sur Paris. Le marché locatif y est stable avec une demande soutenue pour les appartements familiaux.",
    quartiers: ["Centre", "Montretout", "Coteaux", "Pasteur", "Hippodrome"],
    image: "/villes/saint-cloud.jpg",
  },
  {
    nom: "Sèvres",
    slug: "sevres",
    description:
      "Sèvres est une ville à taille humaine offrant un cadre de vie agréable entre forêt et Seine. Le marché immobilier y est diversifié avec des biens de caractère recherchés.",
    quartiers: ["Centre-Ville", "Brancas", "Danton", "Binelles", "Croix-Bosset"],
    image: "/villes/sevres.jpg",
  },
  {
    nom: "Versailles",
    slug: "versailles",
    description:
      "Versailles, ville royale par excellence, offre un patrimoine architectural exceptionnel. Son marché locatif est porté par les familles et les cadres travaillant à Paris ou dans les pôles d'activité environnants.",
    quartiers: ["Notre-Dame", "Saint-Louis", "Montreuil", "Satory", "Chantiers"],
    image: "/villes/versailles.jpg",
  },
  {
    nom: "Saint-Germain-en-Laye",
    slug: "saint-germain-en-laye",
    description:
      "Saint-Germain-en-Laye est une ville historique alliant charme et dynamisme. Son marché immobilier est porté par une clientèle familiale à la recherche d'un cadre de vie privilégié.",
    quartiers: ["Centre historique", "Bel-Air", "Alsace", "Rotondes", "Pontel"],
    image: "/villes/saint-germain-en-laye.jpg",
  },
  {
    nom: "Rueil-Malmaison",
    slug: "rueil-malmaison",
    description:
      "Rueil-Malmaison est une commune résidentielle qui séduit par son équilibre entre espaces verts et zones urbaines. Le marché locatif y est dynamique avec une offre diversifiée.",
    quartiers: ["Centre-Ville", "Buzenval", "Mont-Valérien", "Plaine des Closeaux", "Jonchère"],
    image: "/villes/rueil-malmaison.jpg",
  },
  {
    nom: "Courbevoie",
    slug: "courbevoie",
    description:
      "Courbevoie, adjacente à La Défense, bénéficie d'un marché immobilier dynamique porté par les cadres travaillant dans le quartier d'affaires. L'offre locative y est variée et moderne.",
    quartiers: ["Bécon", "Faubourg de l'Arche", "Gambetta", "Centre", "Charras"],
    image: "/villes/courbevoie.jpg",
  },
  {
    nom: "Puteaux",
    slug: "puteaux",
    description:
      "Puteaux, qui accueille une partie de La Défense, connaît un marché immobilier en constante évolution. Les appartements modernes y côtoient un centre-ville au charme préservé.",
    quartiers: ["Centre-Ville", "La Défense", "Bergères", "Vieux Puteaux", "Île de Puteaux"],
    image: "/villes/puteaux.jpg",
  },
  {
    nom: "Suresnes",
    slug: "suresnes",
    description:
      "Suresnes offre un cadre de vie agréable entre Seine et Mont-Valérien. Son marché locatif est équilibré avec une demande soutenue pour les appartements familiaux bien situés.",
    quartiers: ["Centre-Ville", "Cité-Jardins", "Liberté", "Mont-Valérien", "République"],
    image: "/villes/suresnes.jpg",
  },
  {
    nom: "Nanterre",
    slug: "nanterre",
    description:
      "Nanterre, préfecture des Hauts-de-Seine, connaît une transformation urbaine importante. Son marché immobilier est en plein développement avec de nombreux programmes neufs.",
    quartiers: ["Centre", "Université", "Préfecture", "Mont-Valérien", "Petit Nanterre"],
    image: "/villes/nanterre.jpg",
  },
  {
    nom: "Vincennes",
    slug: "vincennes",
    description:
      "Vincennes est une commune prisée pour sa qualité de vie et sa proximité avec Paris. Le marché locatif y est tendu avec une forte demande pour des biens de qualité.",
    quartiers: ["Centre", "Est", "Ouest", "Château", "Sorano"],
    image: "/villes/vincennes.jpg",
  },
  {
    nom: "Saint-Mandé",
    slug: "saint-mande",
    description:
      "Saint-Mandé est une petite commune résidentielle aux portes de Paris. Son marché immobilier est caractérisé par des biens de standing dans un environnement calme et verdoyant.",
    quartiers: ["Centre", "Tourelle", "Lac", "Alouettes", "Bois"],
    image: "/villes/saint-mande.jpg",
  },
  {
    nom: "Montreuil",
    slug: "montreuil",
    description:
      "Montreuil est une ville en pleine mutation qui attire une population jeune et créative. Son marché immobilier est dynamique avec des quartiers en gentrification.",
    quartiers: ["Bas-Montreuil", "Centre-Ville", "La Noue", "Bel Air", "Ruffins"],
    image: "/villes/montreuil.jpg",
  },
  {
    nom: "Asnières-sur-Seine",
    slug: "asnieres-sur-seine",
    description:
      "Asnières-sur-Seine connaît un renouveau urbain important. Son marché locatif est porté par sa proximité avec Paris et les nombreux projets de développement en cours.",
    quartiers: ["Centre-Ville", "Bords de Seine", "Grésillons", "Bécon", "Flachat"],
    image: "/villes/asnieres-sur-seine.jpg",
  },
  {
    nom: "Clichy",
    slug: "clichy",
    description:
      "Clichy bénéficie d'une attractivité croissante grâce à sa proximité avec Paris et ses prix plus accessibles. Le marché locatif y est dynamique avec une offre en constante évolution.",
    quartiers: ["Centre", "Victor Hugo", "Berges de Seine", "Beaujon", "Entrée de Ville"],
    image: "/villes/clichy.jpg",
  },
  {
    nom: "La Défense",
    slug: "la-defense",
    description:
      "La Défense, premier quartier d'affaires européen, offre un parc immobilier moderne et haut de gamme. Le marché locatif y est porté par les cadres travaillant dans les nombreuses entreprises du secteur.",
    quartiers: ["Esplanade", "Arche Nord", "Arche Sud", "Reflets", "Iris"],
    image: "/villes/la-defense.jpg",
  },
  {
    nom: "Antony",
    slug: "antony",
    description:
      "Antony est une commune résidentielle appréciée pour son cadre de vie équilibré. Son marché immobilier est stable avec une demande soutenue pour les appartements familiaux et les maisons.",
    quartiers: ["Centre-Ville", "Croix de Berny", "Parc Heller", "Fontaine Michalon", "Noyer Doré"],
    image: "/villes/antony.jpg",
  },
]
