"use client"

import { Check, ArrowRight, Phone, MapPin, Clock, Quote } from "lucide-react"
import { Button } from "@/components/ui/button"
import PageHeader from "@/components/page-header"
import ManagementFeeCalculator from "@/components/management-fee-calculator"
import Link from "next/link"

export default function GestionLocativeClient() {
  // Liste des villes où nous opérons pour le SEO
  const citiesWeServe = [
    "Paris",
    "Paris 8ème",
    "Paris 16ème",
    "Paris 17ème",
    "Neuilly-sur-Seine",
    "Levallois-Perret",
    "Boulogne-Billancourt",
    "Issy-les-Moulineaux",
    "Courbevoie",
    "Puteaux",
    "La Défense",
    "Saint-Cloud",
    "Suresnes",
    "Clichy",
    "Asnières-sur-Seine",
  ]

  // Table des matières
  const tableOfContents = [
    { id: "introduction", text: "Gestion locative professionnelle à Paris", level: 2 },
    { id: "zones", text: "Nos zones d'intervention à Paris", level: 2 },
    { id: "services", text: "Nos services de gestion locative à Paris", level: 2 },
    { id: "pourquoi", text: "Pourquoi choisir DOGES ?", level: 2 },
    { id: "niveaux-service", text: "Tarifs de gestion locative à Paris", level: 2 },
    { id: "calculateur", text: "Calculateur de frais de gestion", level: 2 },
    { id: "temoignage", text: "Témoignages de propriétaires", level: 2 },
    { id: "faq", text: "Questions fréquentes", level: 2 },
    { id: "contact", text: "Nous contacter", level: 2 },
  ]

  return (
    <>
      <PageHeader
        title="Gestion Locative à Paris"
        description="Une gestion complète et personnalisée de votre bien immobilier avec un suivi régulier et transparent."
        breadcrumbs={[
          { label: "Services", href: "/services" },
          { label: "Gestion Locative", href: "/services/gestion-locative" },
        ]}
        backgroundImage="https://hebbkx1anhila5yf.public.blob.vercel-storage.com/image-UDE5agUSEDXPqtcdayYWNuFnjfcukR.png"
      />

      {/* Main Content */}
      <section className="py-16">
        <div className="container mx-auto px-4">
          <div className="grid lg:grid-cols-3 gap-12">
            {/* Main Content - 2/3 width */}
            <div className="lg:col-span-2 space-y-12">
              {/* Introduction */}
              <div id="introduction">
                <h2 className="text-3xl font-bold mb-6 text-[#002395]">Gestion locative professionnelle à Paris</h2>
                <p className="text-lg text-gray-700 mb-6">
                  Chez DOGES, nous proposons une gestion locative complète et personnalisée pour votre bien immobilier à
                  Paris et en région parisienne. Notre équipe d'experts s'occupe de tout, de la recherche de locataires
                  à la gestion quotidienne, en passant par les aspects administratifs et techniques.
                </p>
                <p className="text-lg text-gray-700">
                  Grâce à notre expertise du marché immobilier parisien, nous vous offrons un service de qualité
                  supérieure à des tarifs compétitifs, vous permettant de profiter sereinement de votre investissement.
                </p>
              </div>

              {/* Zones géographiques */}
              <div id="zones">
                <h3 className="text-2xl font-semibold mb-6">Nos zones d'intervention à Paris</h3>
                <p className="text-lg text-gray-700 mb-6">
                  DOGES est votre administrateur de biens de confiance à Paris et en région parisienne. Nous intervenons
                  principalement dans les zones suivantes :
                </p>
                <div className="flex flex-wrap gap-2 mb-6">
                  {citiesWeServe.map((city, index) => (
                    <span key={index} className="bg-gray-100 text-gray-800 text-sm px-3 py-1 rounded-full">
                      {city}
                    </span>
                  ))}
                </div>
                <p className="text-gray-700">
                  N'hésitez pas à nous contacter même si votre bien se situe dans une autre zone, nous étudierons votre
                  demande avec attention.
                </p>
              </div>

              {/* Features */}
              <div id="services">
                <h3 className="text-2xl font-semibold mb-6">Nos services de gestion locative à Paris</h3>
                <div className="grid md:grid-cols-2 gap-6">
                  {[
                    "Recherche et sélection de locataires",
                    "Rédaction des baux et états des lieux",
                    "Encaissement des loyers et charges",
                    "Gestion des travaux et interventions",
                    "Suivi des assurances et garanties",
                    "Gestion des sinistres",
                    "Régularisation des charges",
                    "Représentation en assemblée générale",
                  ].map((feature, index) => (
                    <div key={index} className="flex items-start">
                      <div className="mt-1 mr-3 bg-[#002395] rounded-full p-1">
                        <Check className="h-4 w-4 text-white" />
                      </div>
                      <p>{feature}</p>
                    </div>
                  ))}
                </div>
              </div>

              {/* Pourquoi choisir DOGES */}
              <div id="pourquoi">
                <h3 className="text-2xl font-semibold mb-6">Pourquoi choisir DOGES ?</h3>
                <div className="grid md:grid-cols-2 gap-8">
                  {[
                    {
                      title: "Expertise locale",
                      description: "Une connaissance approfondie du marché immobilier parisien et de ses spécificités.",
                    },
                    {
                      title: "Réactivité",
                      description: "Une équipe disponible et réactive pour répondre à toutes vos demandes.",
                    },
                    {
                      title: "Transparence",
                      description: "Des honoraires clairs et un reporting régulier sur la gestion de votre bien.",
                    },
                    {
                      title: "Personnalisation",
                      description: "Des solutions adaptées à vos besoins spécifiques et à votre patrimoine.",
                    },
                  ].map((item, index) => (
                    <div key={index} className="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                      <h4 className="text-xl font-medium mb-3 text-[#002395]">{item.title}</h4>
                      <p className="text-gray-700">{item.description}</p>
                    </div>
                  ))}
                </div>
              </div>

              {/* Niveaux de service */}
              <div id="niveaux-service" className="space-y-6">
                <h3 className="text-2xl font-semibold mb-6">
                  <Link href="/tarifs" className="hover:text-[#001875] hover:underline">
                    Tarifs de gestion locative à Paris
                  </Link>
                </h3>
                <div className="grid md:grid-cols-3 gap-6">
                  {[
                    {
                      name: "Essentiel",
                      price: "3.9% HT",
                      description:
                        "La solution idéale pour les propriétaires qui souhaitent une gestion simple et efficace.",
                      features: [
                        "Recherche de locataires",
                        "Rédaction du bail",
                        "Encaissement des loyers",
                        "Quittances mensuelles",
                        "Révision annuelle du loyer",
                      ],
                    },
                    {
                      name: "Premium",
                      price: "4.9% HT",
                      description:
                        "Notre formule la plus populaire avec des services complets pour une gestion sans souci.",
                      features: [
                        "Tous les services Essentiel",
                        "Gestion des travaux",
                        "Suivi des assurances",
                        "Gestion des sinistres",
                        "Régularisation des charges",
                        "Aide à la déclaration fiscale",
                      ],
                      highlighted: true,
                    },
                    {
                      name: "Sérénité",
                      price: "6.9% HT",
                      description: "Une gestion tout inclus pour une tranquillité totale et une valorisation optimale.",
                      features: [
                        "Tous les services Premium",
                        "Garantie loyers impayés incluse",
                        "Visite annuelle du bien",
                        "Conseils en optimisation fiscale",
                        "Représentation en AG de copropriété",
                        "Rapport de gestion trimestriel",
                      ],
                    },
                  ].map((plan, index) => (
                    <div
                      key={index}
                      className={`rounded-xl border ${
                        plan.highlighted ? "border-[#002395] shadow-lg shadow-blue-100" : "border-gray-200 shadow-sm"
                      } overflow-hidden`}
                    >
                      <div
                        className={`p-6 ${
                          plan.highlighted ? "bg-gradient-to-r from-[#002395] to-[#001875] text-white" : "bg-white"
                        }`}
                      >
                        <h4 className="text-xl font-bold">{plan.name}</h4>
                        <div className="mt-2 text-2xl font-bold">{plan.price}</div>
                        <p className={`mt-2 text-sm ${plan.highlighted ? "text-blue-100" : "text-gray-500"}`}>
                          {plan.description}
                        </p>
                      </div>
                      <div className="p-6 bg-white">
                        <ul className="space-y-3">
                          {plan.features.map((feature, i) => (
                            <li key={i} className="flex items-center">
                              <Check
                                className={`h-4 w-4 mr-2 ${plan.highlighted ? "text-[#002395]" : "text-gray-400"}`}
                              />
                              <span className="text-sm">{feature}</span>
                            </li>
                          ))}
                        </ul>
                        <Button
                          className={`w-full mt-6 ${
                            plan.highlighted
                              ? "bg-[#002395] hover:bg-[#001875] text-white"
                              : "bg-white border border-[#002395] text-[#002395] hover:bg-[#002395] hover:text-white"
                          }`}
                        >
                          Choisir ce forfait
                        </Button>
                      </div>
                    </div>
                  ))}
                </div>
              </div>

              {/* Testimonial */}
              <div id="temoignage" className="bg-gray-50 p-8 rounded-xl border border-gray-100">
                <Quote className="h-10 w-10 text-[#002395] mb-4 opacity-50" />
                <p className="text-lg italic mb-6">
                  "DOGES gère mes trois appartements dans le 16ème arrondissement de Paris depuis plusieurs années. Leur
                  professionnalisme et leur réactivité m'ont permis de ne jamais avoir de période de vacance locative.
                  Je recommande vivement leurs services."
                </p>
                <div className="flex items-center">
                  <div className="w-12 h-12 rounded-full bg-gray-300 mr-4"></div>
                  <div>
                    <p className="font-semibold">Jean-Pierre M.</p>
                    <p className="text-sm text-gray-600">Propriétaire à Paris 16ème</p>
                  </div>
                </div>
              </div>

              {/* FAQ pour SEO */}
              <div id="faq">
                <h3 className="text-2xl font-semibold mb-6">Questions fréquentes</h3>
                <div className="space-y-6">
                  {[
                    {
                      question: "Pourquoi faire appel à un gestionnaire immobilier professionnel à Paris ?",
                      answer:
                        "Un gestionnaire immobilier professionnel comme DOGES vous fait gagner du temps et de l'argent en gérant tous les aspects de votre location : recherche de locataires, gestion administrative, suivi des loyers, gestion des incidents, etc. À Paris, où le marché immobilier est particulièrement dynamique et réglementé, notre expertise locale est un atout majeur.",
                    },
                    {
                      question: "Quels sont les tarifs pour la gestion locative à Paris ?",
                      answer:
                        "Nos honoraires de gestion locative à Paris débutent à 3.9% HT des loyers encaissés pour notre formule Essentiel. Nous proposons différents forfaits adaptés à vos besoins spécifiques. Contactez-nous pour un devis personnalisé.",
                    },
                    {
                      question: "Comment protéger mon bien contre les loyers impayés ?",
                      answer:
                        "Nous proposons une garantie loyers impayés (GLI) qui vous protège contre les impayés, les dégradations et prend en charge les frais de procédure. Cette assurance est particulièrement recommandée pour les propriétaires souhaitant sécuriser leurs revenus locatifs.",
                    },
                  ].map((item, index) => (
                    <div key={index} className="bg-white rounded-lg shadow-sm p-6 border border-gray-100">
                      <h4 className="text-lg font-semibold mb-2">{item.question}</h4>
                      <p className="text-gray-700">{item.answer}</p>
                    </div>
                  ))}
                </div>
              </div>

              {/* CTA */}
              <div id="contact" className="bg-gradient-to-r from-[#002395] to-[#001875] text-white p-8 rounded-xl">
                <h3 className="text-2xl font-bold mb-4">Confiez-nous la gestion de votre bien à Paris</h3>
                <p className="mb-6">
                  Contactez-nous dès aujourd'hui pour bénéficier de notre expertise et de nos tarifs compétitifs.
                </p>
                <div className="flex flex-col sm:flex-row gap-4">
                  <Button className="bg-white text-[#002395] hover:bg-gray-100">Prendre rendez-vous</Button>
                  <Link href="/contact">
                    <Button
                      variant="outline"
                      className="border-white text-white bg-transparent hover:bg-white hover:text-[#002395]"
                    >
                      Demander un devis
                      <ArrowRight className="ml-2 h-4 w-4" />
                    </Button>
                  </Link>
                </div>
              </div>
            </div>

            {/* Sidebar - 1/3 width */}
            <div className="space-y-8">
              {/* Table des matières */}
              <div className="bg-white rounded-xl shadow-lg p-6 border border-gray-100">
                <h3 className="text-xl font-semibold mb-4">Table des matières</h3>
                <div className="space-y-1">
                  {tableOfContents.map((item) => (
                    <div key={item.id} className="border-l-2 border-gray-200 pl-3 hover:border-[#002395]">
                      <a
                        href={`#${item.id}`}
                        className="block py-2 text-gray-700 hover:text-[#002395] transition-colors"
                      >
                        {item.text}
                      </a>
                    </div>
                  ))}
                </div>
              </div>

              {/* Calculateur de frais de gestion */}
              <div className="bg-white rounded-xl shadow-lg p-6 border border-gray-100">
                <h3 className="text-xl font-semibold mb-4 text-[#002395]">Calculateur de frais de gestion</h3>
                <ManagementFeeCalculator />
              </div>

              {/* Downloads */}
              <div className="bg-gray-50 rounded-xl p-6">
                <h3 className="text-xl font-semibold mb-4">Documents utiles</h3>
                <ul className="space-y-3">
                  {[
                    "Guide du propriétaire bailleur",
                    "Fiche tarifaire gestion locative",
                    "Contrat de mandat type",
                    "Checklist des documents à fournir",
                  ].map((doc, index) => (
                    <li key={index}>
                      <a href="#" className="flex items-center text-[#002395] hover:underline">
                        <ArrowRight className="h-4 w-4 mr-2" />
                        {doc}
                      </a>
                    </li>
                  ))}
                </ul>
              </div>

              {/* Contact Card */}
              <div className="bg-white rounded-xl shadow-lg p-6 border border-gray-100">
                <h3 className="text-xl font-semibold mb-4">Besoin d'informations ?</h3>
                <p className="text-gray-600 mb-6">
                  Notre équipe est à votre disposition pour répondre à toutes vos questions sur la gestion locative à
                  Paris.
                </p>
                <div className="space-y-4 mb-6">
                  <div className="flex items-center">
                    <Phone className="h-5 w-5 text-[#002395] mr-3" />
                    <span>01 84 80 98 10</span>
                  </div>
                  <div className="flex items-center">
                    <MapPin className="h-5 w-5 text-[#002395] mr-3" />
                    <span>92, Avenue de Saint-Mandé Paris 12e</span>
                  </div>
                  <div className="flex items-center">
                    <Clock className="h-5 w-5 text-[#002395] mr-3" />
                    <span>Lun-Ven: 9h-18h</span>
                  </div>
                </div>
                <Link href="/contact">
                  <Button className="w-full bg-[#002395] hover:bg-[#001875] text-white">Nous contacter</Button>
                </Link>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Related Services */}
      <section className="py-16 bg-gray-50">
        <div className="container mx-auto px-4">
          <h2 className="text-3xl font-bold mb-10 text-center">Services complémentaires</h2>
          <div className="grid md:grid-cols-3 gap-8">
            {[
              {
                title: "Garantie Loyers Impayés",
                description: "Protégez vos revenus locatifs contre les impayés et les dégradations.",
                link: "/services/garantie-loyers-impayes",
              },
              {
                title: "Assurance PNO",
                description: "Une assurance sur mesure pour votre bien non occupé.",
                link: "/services/assurance-pno",
              },
              {
                title: "Transactions",
                description: "Achat, vente ou location, nous vous accompagnons dans vos projets.",
                link: "/services/transactions",
              },
            ].map((service, index) => (
              <div key={index} className="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                <h3 className="text-xl font-semibold mb-3">{service.title}</h3>
                <p className="text-gray-600 mb-4">{service.description}</p>
                <Link href={service.link} className="text-[#002395] font-medium hover:underline flex items-center">
                  En savoir plus
                  <ArrowRight className="ml-2 h-4 w-4" />
                </Link>
              </div>
            ))}
          </div>
        </div>
      </section>
    </>
  )
}
