import type { Metadata } from "next"
import Link from "next/link"
import { Check, FileText, Home, Shield, Clock, Coins, Settings, Users } from "lucide-react"

// Replace PageHeader import with ServiceHeader
import ServiceHeader from "@/components/service-header"

import ServicesSidebarWidgets from "@/components/services-sidebar-widgets"
import ContactWidget from "@/components/contact-widget"
import { FAQSchema } from "@/components/schema/faq-schema"
// Correction de l'import pour utiliser l'export par défaut
import  ManagementFeeCalculator  from "@/components/management-fee-calculator"
import TableOfContentsWidget from "@/components/table-of-contents-widget"

export const metadata: Metadata = {
  title: "Gestion Locative à Paris et en Île-de-France | DOGES",
  description:
    "Confiez la gestion locative de votre bien immobilier à DOGES. Services complets pour propriétaires à Paris et en Île-de-France. Devis gratuit.",
}

export default function GestionLocativePage() {
  // Données pour la table des matières
  const tocItems = [
    { id: "presentation", title: "Présentation" },
    { id: "services", title: "Nos services" },
    { id: "avantages", title: "Avantages" },
    { id: "formules", title: "Nos formules" },
    { id: "faq", title: "Questions fréquentes" },
  ]

  // Données pour le schéma FAQ
  const faqItems = [
    {
      question: "Quels sont les tarifs de la gestion locative ?",
      answer:
        "Nos honoraires de gestion locative débutent à 2% HT des loyers encaissés. Nous proposons différents forfaits adaptés à vos besoins spécifiques. Contactez-nous pour un devis personnalisé.",
    },
    {
      question: "Quels services sont inclus dans la gestion locative ?",
      answer:
        "Notre service de gestion locative comprend la recherche et la sélection de locataires, la rédaction des baux, l'encaissement des loyers, la gestion des travaux, le suivi des assurances, la gestion des sinistres et la régularisation des charges.",
    },
    {
      question: "Comment protéger mon bien contre les loyers impayés ?",
      answer:
        "Nous proposons une garantie loyers impayés (GLI) qui vous protège contre les impayés, les dégradations et prend en charge les frais de procédure. Cette assurance est particulièrement recommandée pour les propriétaires souhaitant sécuriser vos revenus locatifs.",
    },
    {
      question: "Quelle est la différence entre gestion locative simple et gestion locative complète ?",
      answer:
        "La gestion locative simple comprend les services essentiels comme l'encaissement des loyers et la gestion administrative. La gestion locative complète inclut en plus la recherche de locataires, la gestion technique du bien, le suivi des travaux et la garantie loyers impayés.",
    },
    {
      question: "Combien de temps prend la mise en location d'un bien ?",
      answer:
        "Le délai moyen de mise en location varie selon le type de bien et sa localisation. À Paris et en Île-de-France, nous parvenons généralement à louer un bien dans un délai de 2 à 4 semaines grâce à notre réseau et notre connaissance approfondie du marché local.",
    },
  ]

  return (
    <>
      {/* En-tête de page avec image de fond */}
      {/* Replace PageHeader component with ServiceHeader */}
      <ServiceHeader
        title="Gestion Locative"
        description="Confiez la gestion de votre bien immobilier à des experts"
        breadcrumbItems={[
          { name: "Accueil", url: "/" },
          { name: "Services", url: "/services" },
          { name: "Gestion Locative", url: "/services/gestion-locative" },
        ]}
        backgroundImage="/modern-apartment-interior.png"
      />

      {/* Schéma FAQ pour le SEO */}
      <FAQSchema faqs={faqItems} />

      {/* Contenu principal */}
      <div className="container mx-auto px-4 py-12">
        <div className="flex flex-col lg:flex-row gap-8">
          {/* Contenu principal */}
          <div className="lg:w-2/3">
            {/* Section de présentation */}
            <section id="presentation" className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Gestion locative professionnelle</h2>
              <p className="text-lg mb-4">
                Chez DOGES, nous proposons une gestion locative complète et personnalisée pour les propriétaires à Paris
                et en Île-de-France.
              </p>
              <p className="mb-6">
                Notre équipe d'experts s'occupe de tout, de la recherche de locataires à la gestion quotidienne, en
                passant par les aspects administratifs et techniques. Nous vous permettons de profiter sereinement de
                votre investissement immobilier sans les contraintes de la gestion au quotidien.
              </p>

              <div className="bg-blue-50 p-6 rounded-lg border border-blue-100 my-8">
                <h3 className="text-xl font-medium mb-3">Pourquoi choisir DOGES pour votre gestion locative ?</h3>
                <ul className="space-y-2">
                  <li className="flex items-start">
                    <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                    <span>Plus de 15 ans d'expérience sur le marché immobilier parisien</span>
                  </li>
                  <li className="flex items-start">
                    <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                    <span>Une équipe dédiée et réactive pour chaque propriétaire</span>
                  </li>
                  <li className="flex items-start">
                    <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                    <span>Des outils digitaux innovants pour suivre votre bien en temps réel</span>
                  </li>
                  <li className="flex items-start">
                    <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                    <span>Une connaissance approfondie des réglementations immobilières</span>
                  </li>
                </ul>
              </div>
            </section>

            {/* Section des services */}
            <section id="services" className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Nos services de gestion locative</h2>
              <div className="grid md:grid-cols-2 gap-6">
                <div className="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                  <div className="flex items-center mb-4">
                    <FileText className="h-6 w-6 text-[#002395] mr-3" />
                    <h3 className="text-lg font-medium">Gestion administrative</h3>
                  </div>
                  <ul className="space-y-2 text-gray-700">
                    <li>• Rédaction et signature des baux</li>
                    <li>• Réalisation des états des lieux</li>
                    <li>• Encaissement et quittancement des loyers</li>
                    <li>• Révision annuelle des loyers</li>
                    <li>• Régularisation des charges</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                  <div className="flex items-center mb-4">
                    <Home className="h-6 w-6 text-[#002395] mr-3" />
                    <h3 className="text-lg font-medium">Gestion technique</h3>
                  </div>
                  <ul className="space-y-2 text-gray-700">
                    <li>• Suivi des travaux d'entretien</li>
                    <li>• Organisation des interventions</li>
                    <li>• Gestion des sinistres</li>
                    <li>• Visites techniques annuelles</li>
                    <li>• Mise en conformité réglementaire</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                  <div className="flex items-center mb-4">
                    <Shield className="h-6 w-6 text-[#002395] mr-3" />
                    <h3 className="text-lg font-medium">Sécurisation des revenus</h3>
                  </div>
                  <ul className="space-y-2 text-gray-700">
                    <li>• Sélection rigoureuse des locataires</li>
                    <li>• Vérification des dossiers et garanties</li>
                    <li>• Garantie loyers impayés (en option)</li>
                    <li>• Suivi des paiements</li>
                    <li>• Relances et procédures de recouvrement</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                  <div className="flex items-center mb-4">
                    <Users className="h-6 w-6 text-[#002395] mr-3" />
                    <h3 className="text-lg font-medium">Relation locataires</h3>
                  </div>
                  <ul className="space-y-2 text-gray-700">
                    <li>• Accueil et information des locataires</li>
                    <li>• Gestion des demandes et réclamations</li>
                    <li>• Médiation en cas de conflit</li>
                    <li>• Accompagnement lors du départ</li>
                    <li>• Assistance juridique</li>
                  </ul>
                </div>
              </div>

              <div className="mt-8">
                <p className="text-lg font-medium mb-4">Nos services spécifiques par zone géographique :</p>
                <div className="grid md:grid-cols-2 gap-6">
                  <div className="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                    <h3 className="text-xl font-medium mb-3">Gestion Locative à Paris</h3>
                    <p className="mb-4">
                      Découvrez nos services de gestion locative adaptés aux spécificités du marché parisien.
                    </p>
                    <Link
                      href="/services/gestion-locative-paris"
                      className="text-[#002395] font-medium hover:underline"
                    >
                      En savoir plus sur la gestion locative à Paris →
                    </Link>
                  </div>

                  <div className="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                    <h3 className="text-xl font-medium mb-3">Gestion Locative en Île-de-France</h3>
                    <p className="mb-4">Nos services de gestion locative pour les propriétaires en Île-de-France.</p>
                    <Link
                      href="/services/gestion-locative-ile-de-france"
                      className="text-[#002395] font-medium hover:underline"
                    >
                      En savoir plus sur la gestion locative en Île-de-France →
                    </Link>
                  </div>
                </div>
              </div>
            </section>

            {/* Section des avantages */}
            <section id="avantages" className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">
                Pourquoi confier la gestion de votre bien à un professionnel ?
              </h2>
              <div className="grid md:grid-cols-3 gap-6">
                {[
                  {
                    icon: <Clock className="h-8 w-8 text-[#002395] mb-3" />,
                    title: "Gain de temps",
                    description: "Déléguez les tâches chronophages et concentrez-vous sur l'essentiel.",
                  },
                  {
                    icon: <FileText className="h-8 w-8 text-[#002395] mb-3" />,
                    title: "Expertise juridique",
                    description:
                      "Bénéficiez de notre connaissance approfondie des lois et réglementations immobilières.",
                  },
                  {
                    icon: <Coins className="h-8 w-8 text-[#002395] mb-3" />,
                    title: "Optimisation financière",
                    description: "Maximisez votre rentabilité grâce à une gestion professionnelle de votre bien.",
                  },
                  {
                    icon: <Users className="h-8 w-8 text-[#002395] mb-3" />,
                    title: "Sélection rigoureuse",
                    description: "Des locataires soigneusement sélectionnés pour minimiser les risques d'impayés.",
                  },
                  {
                    icon: <Settings className="h-8 w-8 text-[#002395] mb-3" />,
                    title: "Suivi technique",
                    description: "Un entretien régulier de votre bien pour préserver sa valeur dans le temps.",
                  },
                  {
                    icon: <Shield className="h-8 w-8 text-[#002395] mb-3" />,
                    title: "Tranquillité d'esprit",
                    description: "Une gestion complète pour vous libérer des contraintes de la gestion locative.",
                  },
                ].map((item, index) => (
                  <div key={index} className="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                    {item.icon}
                    <h3 className="text-lg font-medium mb-2 text-[#002395]">{item.title}</h3>
                    <p className="text-gray-700">{item.description}</p>
                  </div>
                ))}
              </div>
            </section>

            {/* Section des formules */}
            <section id="formules" className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Nos formules de gestion locative</h2>
              <div className="grid md:grid-cols-3 gap-6">
                <div className="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                  <h3 className="text-xl font-medium mb-3 text-[#002395]">Formule Essentielle</h3>
                  <p className="text-2xl font-bold mb-4">2% HT</p>
                  <p className="text-sm text-gray-500 mb-4">des loyers encaissés</p>
                  <ul className="space-y-2 mb-6">
                    <li className="flex items-start">
                      <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Gestion administrative</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Encaissement des loyers</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Révision annuelle des loyers</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Régularisation des charges</span>
                    </li>
                  </ul>
                  <Link
                    href="/contact"
                    className="block w-full bg-[#002395] hover:bg-[#001875] text-white py-2 px-4 rounded text-center"
                  >
                    Demander un devis
                  </Link>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-md border-2 border-[#002395] relative">
                  <div className="absolute top-0 right-0 bg-[#002395] text-white px-3 py-1 text-sm font-medium rounded-bl">
                    Recommandé
                  </div>
                  <h3 className="text-xl font-medium mb-3 text-[#002395]">Formule Sérénité</h3>
                  <p className="text-2xl font-bold mb-4">3,9% HT</p>
                  <p className="text-sm text-gray-500 mb-4">des loyers encaissés</p>
                  <ul className="space-y-2 mb-6">
                    <li className="flex items-start">
                      <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Tous les services Essentiels</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Gestion technique du bien</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Suivi des travaux</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Visite technique annuelle</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Gestion des sinistres</span>
                    </li>
                  </ul>
                  <Link
                    href="/contact"
                    className="block w-full bg-[#002395] hover:bg-[#001875] text-white py-2 px-4 rounded text-center"
                  >
                    Demander un devis
                  </Link>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                  <h3 className="text-xl font-medium mb-3 text-[#002395]">Formule Premium</h3>
                  <p className="text-2xl font-bold mb-4">6,9% HT</p>
                  <p className="text-sm text-gray-500 mb-4">des loyers encaissés</p>
                  <ul className="space-y-2 mb-6">
                    <li className="flex items-start">
                      <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Tous les services Sérénité</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Garantie loyers impayés</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Garantie dégradations</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Protection juridique</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Conseils fiscaux personnalisés</span>
                    </li>
                  </ul>
                  <Link
                    href="/contact"
                    className="block w-full bg-[#002395] hover:bg-[#001875] text-white py-2 px-4 rounded text-center"
                  >
                    Demander un devis
                  </Link>
                </div>
              </div>
            </section>

            {/* Section FAQ */}
            <section id="faq" className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Questions fréquentes</h2>
              <div className="space-y-4">
                {faqItems.map((item, index) => (
                  <div key={index} className="bg-white rounded-lg shadow-sm p-6 border border-gray-100">
                    <h3 className="text-lg font-semibold mb-2">{item.question}</h3>
                    <p className="text-gray-700">{item.answer}</p>
                  </div>
                ))}
              </div>
            </section>

            {/* CTA final */}
            <div className="bg-gradient-to-r from-[#002395] to-[#001875] text-white p-8 rounded-lg">
              <h2 className="text-2xl font-bold mb-4">Prêt à nous confier la gestion de votre bien ?</h2>
              <p className="mb-6">
                Contactez-nous dès aujourd'hui pour discuter de vos besoins et obtenir un devis personnalisé.
              </p>
              <div className="flex flex-col sm:flex-row gap-4">
                <Link
                  href="/contact"
                  className="bg-white text-[#002395] hover:bg-gray-100 py-3 px-6 rounded-md font-medium text-center"
                >
                  Nous contacter
                </Link>
                <Link
                  href="tel:0184809810"
                  className="border border-white text-white hover:bg-white/10 py-3 px-6 rounded-md font-medium text-center"
                >
                  Appeler au 01 84 80 98 10
                </Link>
              </div>
            </div>
          </div>

          {/* Sidebar */}
          <div className="lg:w-1/3">
            {/* Table des matières */}
            {/* Sidebar avec les widgets dans le bon ordre */}
            <div className="lg:col-span-1">
              <TableOfContentsWidget
                items={[
                  { id: "presentation", title: "Présentation" },
                  { id: "services", title: "Nos services" },
                  { id: "avantages", title: "Avantages" },
                  { id: "tarifs", title: "Tarifs" },
                  { id: "faq", title: "Questions fréquentes" },
                  { id: "contact", title: "Contact" },
                ]}
              />

              <ManagementFeeCalculator />

              <ContactWidget />

              <ServicesSidebarWidgets />
            </div>
          </div>
        </div>
      </div>
    </>
  )
}
