import type { Metadata } from "next"
import Image from "next/image"
import Link from "next/link"
import { Check, Building2, Users, TrendingUp, FileText, Award, ArrowRight } from "lucide-react"

// Replace PageHeader import with ServiceHeader
import ServiceHeader from "@/components/service-header"
import TableOfContentsWidget from "@/components/table-of-contents-widget"
import ContactWidget from "@/components/contact-widget"
import RelatedServicesWidget from "@/components/related-services-widget"
import { ConsultationCTA } from "@/components/consultation-cta"
import { Card, CardContent } from "@/components/ui/card"

export const metadata: Metadata = {
  title: "Services Immobiliers pour Professionnels | DOGES Administration de Biens",
  description:
    "Solutions immobilières complètes pour les professionnels : gestion d'actifs, property management, conseil en investissement et optimisation de patrimoine.",
}

export default function ProfessionnelsPage() {
  // Définir les éléments de la table des matières
  const tocItems = [
    { id: "presentation", title: "Nos services pour professionnels" },
    { id: "solutions", title: "Nos solutions sur mesure" },
    { id: "avantages", title: "Pourquoi nous choisir" },
    { id: "secteurs", title: "Secteurs d'expertise" },
    { id: "processus", title: "Notre approche" },
    { id: "temoignages", title: "Témoignages clients" },
    { id: "faq", title: "Questions fréquentes" },
  ]

  // Définir les services associés
  const relatedServices = [
    {
      title: "Service Commercial",
      description: "Commercialisation et valorisation de vos actifs immobiliers",
      link: "/services/service-commercial",
    },
    {
      title: "Gestion Immobilière",
      description: "Gestion quotidienne et optimisation de votre patrimoine",
      link: "/services/gestion-immobiliere-professionnelle",
    },
    {
      title: "Service Juridique",
      description: "Conseil et accompagnement juridique spécialisé",
      link: "/services/juridique",
    },
  ]

  return (
    <>
      {/* Replace PageHeader component with ServiceHeader */}
      <ServiceHeader
        title="Services pour Professionnels"
        description="Solutions immobilières complètes pour les entreprises et investisseurs institutionnels"
        breadcrumbItems={[
          { name: "Accueil", url: "/" },
          { name: "Services", url: "/services" },
          { name: "Professionnels", url: "/services/professionnels" },
        ]}
        backgroundImage="/images/professional-services.png"
      />

      <div className="container mx-auto px-4 py-12">
        <div className="flex flex-col lg:flex-row gap-8">
          {/* Contenu principal */}
          <div className="lg:w-2/3">
            {/* Section de présentation */}
            <section id="presentation" className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Nos services immobiliers pour professionnels</h2>
              <p className="text-lg mb-4">
                Chez DOGES, nous proposons une gamme complète de services immobiliers dédiés aux professionnels,
                entreprises et investisseurs institutionnels. Notre expertise couvre l'ensemble des besoins immobiliers
                des acteurs économiques, de la gestion d'actifs au conseil stratégique.
              </p>
              <p className="mb-6">
                Notre équipe de spécialistes comprend les enjeux spécifiques des professionnels et vous accompagne dans
                l'optimisation de votre patrimoine immobilier, qu'il s'agisse de bureaux, commerces, locaux d'activité
                ou immeubles de rapport.
              </p>

              <div className="relative h-64 rounded-xl overflow-hidden mb-8">
                <Image
                  src="/images/professional-services.png"
                  alt="Services immobiliers pour professionnels"
                  fill
                  className="object-cover"
                />
              </div>

              <div className="bg-blue-50 p-6 rounded-lg border border-blue-100 my-8">
                <h3 className="text-xl font-medium mb-3">Notre approche pour les professionnels</h3>
                <ul className="space-y-2">
                  <li className="flex items-start">
                    <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                    <span>Une compréhension approfondie des enjeux business de votre secteur</span>
                  </li>
                  <li className="flex items-start">
                    <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                    <span>Des solutions sur mesure adaptées à vos objectifs stratégiques</span>
                  </li>
                  <li className="flex items-start">
                    <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                    <span>Une équipe dédiée aux clients professionnels</span>
                  </li>
                  <li className="flex items-start">
                    <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                    <span>Un reporting transparent et des outils de pilotage performants</span>
                  </li>
                  <li className="flex items-start">
                    <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                    <span>Une vision à long terme pour valoriser votre patrimoine</span>
                  </li>
                </ul>
              </div>
            </section>

            {/* Section des solutions */}
            <section id="solutions" className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Nos solutions sur mesure</h2>
              <div className="grid md:grid-cols-2 gap-6">
                <Card className="bg-white shadow-sm border border-gray-100">
                  <CardContent className="p-6">
                    <div className="flex items-center mb-4">
                      <Building2 className="h-6 w-6 text-[#002395] mr-3" />
                      <h3 className="text-lg font-medium">Asset Management</h3>
                    </div>
                    <p className="text-gray-700 mb-4">
                      Optimisez la performance de vos actifs immobiliers grâce à notre expertise en gestion d'actifs.
                    </p>
                    <ul className="space-y-2 text-gray-700">
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Stratégie d'investissement et d'arbitrage</span>
                      </li>
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Optimisation des revenus locatifs</span>
                      </li>
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Valorisation du patrimoine</span>
                      </li>
                    </ul>
                  </CardContent>
                </Card>

                <Card className="bg-white shadow-sm border border-gray-100">
                  <CardContent className="p-6">
                    <div className="flex items-center mb-4">
                      <Users className="h-6 w-6 text-[#002395] mr-3" />
                      <h3 className="text-lg font-medium">Property Management</h3>
                    </div>
                    <p className="text-gray-700 mb-4">
                      Confiez-nous la gestion quotidienne de vos biens immobiliers pour vous concentrer sur votre cœur
                      de métier.
                    </p>
                    <ul className="space-y-2 text-gray-700">
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Gestion locative complète</span>
                      </li>
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Suivi technique et maintenance</span>
                      </li>
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Gestion administrative et comptable</span>
                      </li>
                    </ul>
                  </CardContent>
                </Card>

                <Card className="bg-white shadow-sm border border-gray-100">
                  <CardContent className="p-6">
                    <div className="flex items-center mb-4">
                      <TrendingUp className="h-6 w-6 text-[#002395] mr-3" />
                      <h3 className="text-lg font-medium">Conseil en investissement</h3>
                    </div>
                    <p className="text-gray-700 mb-4">
                      Bénéficiez de notre expertise pour vos projets d'acquisition, de cession ou de restructuration
                      d'actifs.
                    </p>
                    <ul className="space-y-2 text-gray-700">
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Études de marché et d'opportunité</span>
                      </li>
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Due diligence immobilière</span>
                      </li>
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Montage d'opérations complexes</span>
                      </li>
                    </ul>
                  </CardContent>
                </Card>

                <Card className="bg-white shadow-sm border border-gray-100">
                  <CardContent className="p-6">
                    <div className="flex items-center mb-4">
                      <FileText className="h-6 w-6 text-[#002395] mr-3" />
                      <h3 className="text-lg font-medium">Facility Management</h3>
                    </div>
                    <p className="text-gray-700 mb-4">
                      Optimisez la gestion technique et les services de vos immeubles pour améliorer le confort des
                      occupants.
                    </p>
                    <ul className="space-y-2 text-gray-700">
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Pilotage des prestataires techniques</span>
                      </li>
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Optimisation des charges</span>
                      </li>
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Gestion des services aux occupants</span>
                      </li>
                    </ul>
                  </CardContent>
                </Card>
              </div>
            </section>

            {/* Section pourquoi nous choisir */}
            <section id="avantages" className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Pourquoi choisir DOGES pour vos actifs ?</h2>
              <div className="grid md:grid-cols-3 gap-6">
                {[
                  {
                    icon: <Award className="h-8 w-8 text-[#002395] mb-3" />,
                    title: "Expertise sectorielle",
                    description:
                      "Une connaissance approfondie des différents segments du marché immobilier professionnel.",
                  },
                  {
                    icon: <Users className="h-8 w-8 text-[#002395] mb-3" />,
                    title: "Équipe dédiée",
                    description:
                      "Des interlocuteurs spécialisés par secteur d'activité pour répondre à vos besoins spécifiques.",
                  },
                  {
                    icon: <TrendingUp className="h-8 w-8 text-[#002395] mb-3" />,
                    title: "Vision stratégique",
                    description:
                      "Une approche globale qui intègre les dimensions financières, techniques et juridiques.",
                  },
                  {
                    icon: <Building2 className="h-8 w-8 text-[#002395] mb-3" />,
                    title: "Réseau étendu",
                    description: "Des partenariats solides avec les acteurs clés du marché immobilier professionnel.",
                  },
                  {
                    icon: <FileText className="h-8 w-8 text-[#002395] mb-3" />,
                    title: "Reporting transparent",
                    description:
                      "Des outils de pilotage performants pour suivre la performance de vos actifs en temps réel.",
                  },
                  {
                    icon: <Check className="h-8 w-8 text-[#002395] mb-3" />,
                    title: "Engagement RSE",
                    description:
                      "Une démarche responsable intégrant les enjeux environnementaux et sociétaux dans nos solutions.",
                  },
                ].map((item, index) => (
                  <div key={index} className="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                    {item.icon}
                    <h3 className="text-lg font-medium mb-2">{item.title}</h3>
                    <p className="text-gray-700">{item.description}</p>
                  </div>
                ))}
              </div>
            </section>

            {/* Section secteurs d'expertise */}
            <section id="secteurs" className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Nos secteurs d'expertise</h2>
              <div className="grid md:grid-cols-2 gap-6">
                <div className="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                  <h3 className="text-xl font-semibold mb-4">Bureaux</h3>
                  <p className="text-gray-700 mb-4">
                    Gestion complète de vos immeubles de bureaux, de la commercialisation à l'exploitation technique, en
                    passant par la relation avec les locataires.
                  </p>
                  <ul className="space-y-2">
                    <li className="flex items-start">
                      <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Immeubles mono ou multi-locataires</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Espaces de coworking</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Centres d'affaires</span>
                    </li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                  <h3 className="text-xl font-semibold mb-4">Commerces</h3>
                  <p className="text-gray-700 mb-4">
                    Valorisation et gestion de vos actifs commerciaux, avec une attention particulière à la
                    commercialisation et au mix commercial.
                  </p>
                  <ul className="space-y-2">
                    <li className="flex items-start">
                      <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Boutiques en pied d'immeuble</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Centres commerciaux</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Retail parks</span>
                    </li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                  <h3 className="text-xl font-semibold mb-4">Locaux d'activité</h3>
                  <p className="text-gray-700 mb-4">
                    Gestion adaptée à vos locaux d'activité, entrepôts et bâtiments industriels, avec une expertise
                    technique spécifique.
                  </p>
                  <ul className="space-y-2">
                    <li className="flex items-start">
                      <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Entrepôts logistiques</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Locaux mixtes</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Bâtiments industriels</span>
                    </li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                  <h3 className="text-xl font-semibold mb-4">Immeubles de rapport</h3>
                  <p className="text-gray-700 mb-4">
                    Optimisation de la rentabilité de vos immeubles de rapport, avec une gestion locative rigoureuse et
                    une valorisation patrimoniale.
                  </p>
                  <ul className="space-y-2">
                    <li className="flex items-start">
                      <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Immeubles résidentiels</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Immeubles mixtes</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Résidences gérées</span>
                    </li>
                  </ul>
                </div>
              </div>
            </section>

            {/* Section processus */}
            <section id="processus" className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Notre approche pour les professionnels</h2>
              <div className="space-y-6">
                {[
                  {
                    step: "1",
                    title: "Analyse de vos besoins",
                    description:
                      "Nous commençons par une analyse approfondie de vos objectifs, de votre patrimoine et de vos contraintes pour définir une stratégie adaptée.",
                  },
                  {
                    step: "2",
                    title: "Élaboration d'une stratégie",
                    description:
                      "Nous élaborons une stratégie sur mesure pour optimiser la performance de vos actifs immobiliers en fonction de vos objectifs.",
                  },
                  {
                    step: "3",
                    title: "Mise en œuvre opérationnelle",
                    description:
                      "Notre équipe dédiée met en œuvre la stratégie définie, avec un suivi rigoureux des actions et des résultats.",
                  },
                  {
                    step: "4",
                    title: "Reporting et pilotage",
                    description:
                      "Nous vous fournissons un reporting régulier et transparent sur la performance de vos actifs, avec des indicateurs clés personnalisés.",
                  },
                  {
                    step: "5",
                    title: "Optimisation continue",
                    description:
                      "Nous adaptons en permanence notre stratégie en fonction de l'évolution du marché et de vos objectifs pour maximiser la performance de vos actifs.",
                  },
                ].map((step, index) => (
                  <div key={index} className="flex">
                    <div className="mr-6">
                      <div className="w-10 h-10 rounded-full bg-[#002395] text-white flex items-center justify-center font-bold">
                        {step.step}
                      </div>
                    </div>
                    <div>
                      <h3 className="text-xl font-medium mb-2">{step.title}</h3>
                      <p className="text-gray-700">{step.description}</p>
                    </div>
                  </div>
                ))}
              </div>
            </section>

            {/* Section témoignages */}
            <section id="temoignages" className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Témoignages de nos clients professionnels</h2>
              <div className="grid md:grid-cols-2 gap-6">
                {[
                  {
                    name: "Groupe Immocorp",
                    role: "Foncière commerciale",
                    testimonial:
                      "DOGES gère notre portefeuille d'actifs commerciaux depuis 5 ans avec un professionnalisme exemplaire. Leur expertise nous a permis d'optimiser significativement le taux d'occupation et la rentabilité de nos centres commerciaux.",
                    rating: 5,
                  },
                  {
                    name: "Invest Capital",
                    role: "Société d'investissement immobilier",
                    testimonial:
                      "L'équipe de DOGES nous accompagne dans nos acquisitions avec une expertise pointue du marché. Leur due diligence rigoureuse et leurs conseils stratégiques nous ont permis de réaliser des investissements performants.",
                    rating: 5,
                  },
                  {
                    name: "Tech Solutions",
                    role: "Entreprise technologique",
                    testimonial:
                      "En tant qu'entreprise en forte croissance, nous avons confié à DOGES la recherche et l'aménagement de nos nouveaux bureaux. Leur compréhension de nos besoins et leur accompagnement ont été déterminants dans le succès de notre projet.",
                    rating: 4,
                  },
                  {
                    name: "Patrimoine & Associés",
                    role: "Family office",
                    testimonial:
                      "DOGES gère notre patrimoine immobilier diversifié avec une approche personnalisée et une grande réactivité. Leur vision stratégique et leur expertise technique nous permettent de valoriser nos actifs sur le long terme.",
                    rating: 5,
                  },
                ].map((testimonial, index) => (
                  <div key={index} className="bg-white rounded-lg shadow-sm p-6 border border-gray-100">
                    <div className="flex items-center mb-4">
                      {[...Array(testimonial.rating)].map((_, i) => (
                        <svg
                          key={i}
                          className="w-5 h-5 text-yellow-400"
                          fill="currentColor"
                          viewBox="0 0 20 20"
                          xmlns="http://www.w3.org/2000/svg"
                        >
                          <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                      ))}
                    </div>
                    <p className="text-gray-700 mb-4 italic">"{testimonial.testimonial}"</p>
                    <div>
                      <p className="font-semibold">{testimonial.name}</p>
                      <p className="text-sm text-gray-500">{testimonial.role}</p>
                    </div>
                  </div>
                ))}
              </div>
            </section>

            {/* Section FAQ */}
            <section id="faq" className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Questions fréquentes</h2>
              <div className="space-y-4">
                {[
                  {
                    question: "Quels types d'actifs immobiliers pouvez-vous gérer ?",
                    answer:
                      "Nous gérons tous types d'actifs immobiliers professionnels : bureaux, commerces, locaux d'activité, entrepôts, immeubles de rapport, résidences gérées, etc. Notre expertise couvre l'ensemble du marché immobilier professionnel à Paris et en Île-de-France.",
                  },
                  {
                    question: "Comment sont structurés vos honoraires pour les clients professionnels ?",
                    answer:
                      "Nos honoraires sont adaptés à chaque mission et dépendent de la nature et de l'ampleur des services fournis. Nous proposons différentes structures d'honoraires : forfait, pourcentage des loyers, success fees, etc. Nous établissons un devis personnalisé après analyse de vos besoins spécifiques.",
                  },
                  {
                    question: "Proposez-vous des services de conseil en investissement immobilier ?",
                    answer:
                      "Oui, nous proposons des services de conseil en investissement immobilier pour les professionnels. Notre équipe vous accompagne dans l'identification d'opportunités, la réalisation de due diligence, l'analyse de rentabilité et la structuration de vos acquisitions. Nous pouvons également vous conseiller sur votre stratégie d'arbitrage.",
                  },
                  {
                    question: "Comment assurez-vous le reporting pour vos clients professionnels ?",
                    answer:
                      "Nous mettons à votre disposition des outils de reporting personnalisés et adaptés à vos besoins. Vous bénéficiez d'un accès à une plateforme en ligne sécurisée où vous retrouvez l'ensemble des indicateurs clés de performance de vos actifs, des rapports d'activité réguliers et des analyses détaillées. Nous organisons également des réunions de suivi périodiques avec votre interlocuteur dédié.",
                  },
                  {
                    question: "Pouvez-vous gérer des actifs immobiliers dans toute la France ?",
                    answer:
                      "Notre expertise principale se concentre sur Paris et l'Île-de-France, où nous disposons d'une connaissance approfondie du marché. Cependant, grâce à notre réseau de partenaires, nous pouvons également vous accompagner dans la gestion d'actifs situés dans les principales métropoles françaises. Nous adaptons notre offre en fonction de la localisation de vos biens.",
                  },
                ].map((item, index) => (
                  <div key={index} className="bg-white rounded-lg shadow-sm p-6 border border-gray-100">
                    <h3 className="text-lg font-semibold mb-2">{item.question}</h3>
                    <p className="text-gray-700">{item.answer}</p>
                  </div>
                ))}
              </div>
              <div className="mt-6 text-center">
                <Link href="/faq" className="text-[#002395] font-medium hover:underline inline-flex items-center">
                  Voir toutes les questions fréquentes
                  <ArrowRight className="ml-2 h-4 w-4" />
                </Link>
              </div>
            </section>
          </div>

          {/* Sidebar */}
          <div className="lg:w-1/3">
            {/* Table des matières */}
            <div className="mb-6">
              <TableOfContentsWidget items={tocItems} />
            </div>

            {/* Widget de contact */}
            <div className="mb-6">
              <ContactWidget />
            </div>

            {/* Services associés */}
            <div className="mb-6">
              <RelatedServicesWidget services={relatedServices} />
            </div>

            {/* Widget d'information */}
            <div className="mb-6">
              <Card className="border border-gray-200">
                <CardContent className="p-6">
                  <h3 className="text-xl font-bold mb-4">Nos références</h3>
                  <p className="text-gray-700 mb-4">
                    DOGES accompagne de nombreux clients professionnels dans la gestion et l'optimisation de leur
                    patrimoine immobilier :
                  </p>
                  <ul className="space-y-2">
                    <li className="flex items-start">
                      <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Foncières immobilières</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Investisseurs institutionnels</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Family offices</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Entreprises utilisatrices</span>
                    </li>
                    <li className="flex items-start">
                      <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                      <span>Promoteurs immobiliers</span>
                    </li>
                  </ul>
                  <div className="mt-4 pt-4 border-t border-gray-200">
                    <Link
                      href="/contact"
                      className="text-[#002395] font-medium hover:underline inline-flex items-center"
                    >
                      Demander une présentation de nos références
                      <ArrowRight className="ml-2 h-4 w-4" />
                    </Link>
                  </div>
                </CardContent>
              </Card>
            </div>
          </div>
        </div>

        {/* CTA final */}
        <div className="mt-12">
          <ConsultationCTA
            title="Besoin d'une solution immobilière sur mesure pour votre entreprise ?"
            description="Contactez notre équipe dédiée aux professionnels pour une étude personnalisée de vos besoins."
            buttonText="Prendre rendez-vous"
            buttonLink="/contact"
          />
        </div>
      </div>
    </>
  )
}
