import type { Metadata } from "next"
import { Check, Building2, Users, TrendingUp, FileText, Award } from "lucide-react"

import ServiceHeader from "@/components/service-header"
import TableOfContentsWidget from "@/components/table-of-contents-widget"
import ContactWidget from "@/components/contact-widget"
import RelatedServicesWidget from "@/components/related-services-widget"
import { ConsultationCTA } from "@/components/consultation-cta"
import { Card, CardContent } from "@/components/ui/card"

export const metadata: Metadata = {
  title: "Service Commercial Immobilier | DOGES Administration de Biens",
  description:
    "Découvrez notre service commercial spécialisé en immobilier. Maximisez la rentabilité de vos biens avec notre équipe d'experts en marketing et négociation.",
}

export default function ServiceCommercialPage() {
  // Définir les éléments de la table des matières
  const tocItems = [
    { id: "presentation", title: "Présentation du service commercial" },
    { id: "expertises", title: "Nos expertises commerciales" },
    { id: "pourquoi-nous", title: "Pourquoi choisir notre service commercial" },
    { id: "processus", title: "Notre processus commercial" },
    { id: "faq", title: "Questions fréquentes" },
    { id: "temoignages", title: "Ce que disent nos clients" },
  ]

  // Définir les services associés
  const relatedServices = [
    {
      title: "Transaction immobilière",
      description: "Notre service d'accompagnement complet pour vos transactions immobilières",
      link: "/services/transaction",
    },
    {
      title: "Gestion locative",
      description: "Confiez-nous la gestion quotidienne de vos biens immobiliers",
      link: "/services/gestion-locative",
    },
    {
      title: "Service juridique",
      description: "Un accompagnement juridique pour sécuriser vos opérations immobilières",
      link: "/services/juridique",
    },
  ]

  return (
    <>
      <ServiceHeader
        title="Service Commercial"
        description="Maximisez la rentabilité de vos biens immobiliers avec notre expertise commerciale"
        breadcrumbItems={[
          { name: "Accueil", url: "/" },
          { name: "Services", url: "/services" },
          { name: "Service Commercial", url: "/services/service-commercial" },
        ]}
        backgroundImage="/images/commercial-service.webp"
      />

      <div className="container mx-auto px-4 py-12">
        <div className="flex flex-col lg:flex-row gap-8">
          {/* Contenu principal */}
          <div className="lg:w-2/3">
            {/* Section de présentation */}
            <section id="presentation" className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Notre service commercial immobilier</h2>
              <p className="text-lg mb-4">
                Chez DOGES, notre service commercial est dédié à la valorisation et à l'optimisation de votre patrimoine
                immobilier. Notre équipe d'experts en immobilier commercial vous accompagne dans toutes vos démarches
                pour maximiser la rentabilité de vos biens.
              </p>
              <p className="mb-6">
                Que vous soyez propriétaire d'un local commercial, d'un immeuble de bureaux ou d'un portefeuille
                d'actifs immobiliers, nous mettons à votre disposition notre expertise du marché parisien et francilien
                pour vous proposer des solutions commerciales adaptées à vos objectifs.
              </p>

              <div className="bg-blue-50 p-6 rounded-lg border border-blue-100 my-8">
                <h3 className="text-xl font-medium mb-3">Les points forts de notre service commercial</h3>
                <ul className="space-y-2">
                  <li className="flex items-start">
                    <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                    <span>Une connaissance approfondie du marché immobilier commercial</span>
                  </li>
                  <li className="flex items-start">
                    <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                    <span>Des stratégies de commercialisation sur mesure</span>
                  </li>
                  <li className="flex items-start">
                    <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                    <span>Un réseau étendu de partenaires et d'investisseurs</span>
                  </li>
                  <li className="flex items-start">
                    <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                    <span>Des outils marketing innovants pour valoriser vos biens</span>
                  </li>
                  <li className="flex items-start">
                    <Check className="h-5 w-5 text-green-600 mr-2 mt-1 flex-shrink-0" />
                    <span>Une équipe de négociateurs expérimentés</span>
                  </li>
                </ul>
              </div>
            </section>

            {/* Section des expertises */}
            <section id="expertises" className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Nos expertises commerciales</h2>
              <div className="grid md:grid-cols-2 gap-6">
                <Card className="bg-white shadow-sm border border-gray-100">
                  <CardContent className="p-6">
                    <div className="flex items-center mb-4">
                      <Building2 className="h-6 w-6 text-[#002395] mr-3" />
                      <h3 className="text-lg font-medium">Commercialisation de biens</h3>
                    </div>
                    <p className="text-gray-700 mb-4">
                      Nous mettons en place des stratégies de commercialisation efficaces pour louer ou vendre vos biens
                      immobiliers dans les meilleures conditions.
                    </p>
                    <ul className="space-y-2 text-gray-700">
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Étude de marché approfondie</span>
                      </li>
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Valorisation optimale de votre bien</span>
                      </li>
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Diffusion ciblée sur les plateformes spécialisées</span>
                      </li>
                    </ul>
                  </CardContent>
                </Card>

                <Card className="bg-white shadow-sm border border-gray-100">
                  <CardContent className="p-6">
                    <div className="flex items-center mb-4">
                      <Users className="h-6 w-6 text-[#002395] mr-3" />
                      <h3 className="text-lg font-medium">Prospection et négociation</h3>
                    </div>
                    <p className="text-gray-700 mb-4">
                      Notre équipe de négociateurs expérimentés prospecte activement pour trouver les meilleurs
                      locataires ou acquéreurs pour vos biens.
                    </p>
                    <ul className="space-y-2 text-gray-700">
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Prospection ciblée selon vos critères</span>
                      </li>
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Négociation optimale des conditions</span>
                      </li>
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Sélection rigoureuse des candidats</span>
                      </li>
                    </ul>
                  </CardContent>
                </Card>

                <Card className="bg-white shadow-sm border border-gray-100">
                  <CardContent className="p-6">
                    <div className="flex items-center mb-4">
                      <TrendingUp className="h-6 w-6 text-[#002395] mr-3" />
                      <h3 className="text-lg font-medium">Conseil en investissement</h3>
                    </div>
                    <p className="text-gray-700 mb-4">
                      Nous vous conseillons dans vos projets d'investissement immobilier pour optimiser la rentabilité
                      de votre patrimoine.
                    </p>
                    <ul className="space-y-2 text-gray-700">
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Analyse des opportunités d'investissement</span>
                      </li>
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Étude de rentabilité détaillée</span>
                      </li>
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Stratégies d'optimisation fiscale</span>
                      </li>
                    </ul>
                  </CardContent>
                </Card>

                <Card className="bg-white shadow-sm border border-gray-100">
                  <CardContent className="p-6">
                    <div className="flex items-center mb-4">
                      <FileText className="h-6 w-6 text-[#002395] mr-3" />
                      <h3 className="text-lg font-medium">Gestion commerciale</h3>
                    </div>
                    <p className="text-gray-700 mb-4">
                      Nous assurons la gestion commerciale de vos biens pour maintenir leur attractivité et optimiser
                      leur occupation.
                    </p>
                    <ul className="space-y-2 text-gray-700">
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Suivi des baux commerciaux</span>
                      </li>
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Optimisation du mix commercial</span>
                      </li>
                      <li className="flex items-start">
                        <Check className="h-4 w-4 text-green-600 mr-2 mt-1 flex-shrink-0" />
                        <span>Gestion des relations avec les locataires</span>
                      </li>
                    </ul>
                  </CardContent>
                </Card>
              </div>
            </section>

            {/* Section pourquoi nous choisir */}
            <section id="pourquoi-nous" className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Pourquoi choisir notre service commercial ?</h2>
              <div className="grid md:grid-cols-3 gap-6">
                {[
                  {
                    icon: <Award className="h-8 w-8 text-[#002395] mb-3" />,
                    title: "Expertise reconnue",
                    description:
                      "Plus de 15 ans d'expérience dans l'immobilier commercial à Paris et en Île-de-France.",
                  },
                  {
                    icon: <Users className="h-8 w-8 text-[#002395] mb-3" />,
                    title: "Réseau étendu",
                    description: "Un réseau de partenaires, d'investisseurs et d'entreprises à la recherche de locaux.",
                  },
                  {
                    icon: <TrendingUp className="h-8 w-8 text-[#002395] mb-3" />,
                    title: "Approche sur mesure",
                    description:
                      "Des stratégies commerciales adaptées à vos objectifs et aux spécificités de vos biens.",
                  },
                  {
                    icon: <Building2 className="h-8 w-8 text-[#002395] mb-3" />,
                    title: "Connaissance du marché",
                    description: "Une veille constante du marché immobilier commercial pour anticiper les tendances.",
                  },
                  {
                    icon: <FileText className="h-8 w-8 text-[#002395] mb-3" />,
                    title: "Transparence",
                    description: "Un reporting régulier et détaillé sur les actions menées et les résultats obtenus.",
                  },
                  {
                    icon: <Check className="h-8 w-8 text-[#002395] mb-3" />,
                    title: "Résultats prouvés",
                    description: "Un taux de satisfaction client de 95% et des délais de commercialisation optimisés.",
                  },
                ].map((item, index) => (
                  <div key={index} className="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                    {item.icon}
                    <h3 className="text-lg font-medium mb-2">{item.title}</h3>
                    <p className="text-gray-700">{item.description}</p>
                  </div>
                ))}
              </div>
            </section>

            {/* Section processus commercial */}
            <section id="processus" className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Notre processus commercial</h2>
              <div className="space-y-6">
                {[
                  {
                    step: "1",
                    title: "Analyse et évaluation",
                    description:
                      "Nous analysons votre bien et le marché local pour déterminer sa valeur optimale et définir la meilleure stratégie de commercialisation.",
                  },
                  {
                    step: "2",
                    title: "Préparation et valorisation",
                    description:
                      "Nous préparons votre bien pour la commercialisation avec des photos professionnelles, des plans et une documentation commerciale attractive.",
                  },
                  {
                    step: "3",
                    title: "Diffusion et promotion",
                    description:
                      "Nous diffusons votre offre sur les plateformes spécialisées et activons notre réseau de partenaires et d'investisseurs.",
                  },
                  {
                    step: "4",
                    title: "Visites et négociation",
                    description:
                      "Nous organisons les visites avec des candidats qualifiés et négocions les meilleures conditions pour vous.",
                  },
                  {
                    step: "5",
                    title: "Finalisation et suivi",
                    description:
                      "Nous finalisons la transaction et assurons le suivi administratif et juridique jusqu'à la signature définitive.",
                  },
                ].map((step, index) => (
                  <div key={index} className="flex">
                    <div className="mr-6">
                      <div className="w-10 h-10 rounded-full bg-[#002395] text-white flex items-center justify-center font-bold">
                        {step.step}
                      </div>
                    </div>
                    <div>
                      <h3 className="text-xl font-medium mb-2">{step.title}</h3>
                      <p className="text-gray-700">{step.description}</p>
                    </div>
                  </div>
                ))}
              </div>
            </section>

            {/* Section FAQ */}
            <section id="faq" className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Questions fréquentes</h2>
              <div className="space-y-4">
                {[
                  {
                    question: "Quels types de biens commercialisez-vous ?",
                    answer:
                      "Nous commercialisons tous types de biens immobiliers : bureaux, commerces, locaux d'activité, entrepôts, immeubles entiers, etc. Notre expertise couvre l'ensemble du marché immobilier commercial à Paris et en Île-de-France.",
                  },
                  {
                    question: "Quels sont vos honoraires de commercialisation ?",
                    answer:
                      "Nos honoraires de commercialisation varient selon le type de bien et la prestation demandée. Pour une location commerciale, ils représentent généralement entre 10% et 30% du loyer annuel HT HC. Pour une vente, ils sont compris entre 2% et 5% du prix de vente. Nous vous proposons un devis personnalisé après étude de votre bien.",
                  },
                  {
                    question: "Combien de temps faut-il pour louer ou vendre un bien commercial ?",
                    answer:
                      "Le délai de commercialisation dépend de nombreux facteurs : type de bien, localisation, état, prix, etc. En moyenne, il faut compter entre 3 et 6 mois pour louer un local commercial et entre 6 et 12 mois pour vendre un immeuble. Grâce à notre expertise et notre réseau, nous nous efforçons de réduire ces délais au maximum.",
                  },
                  {
                    question: "Proposez-vous des services de conseil en investissement ?",
                    answer:
                      "Oui, nous proposons des services de conseil en investissement immobilier commercial. Nous vous aidons à identifier les opportunités d'investissement correspondant à vos objectifs, réalisons des études de rentabilité détaillées et vous accompagnons dans toutes les étapes de votre projet d'acquisition.",
                  },
                  {
                    question: "Comment valorisez-vous un bien commercial vacant ?",
                    answer:
                      "Pour valoriser un bien commercial vacant, nous mettons en place plusieurs actions : réalisation de photos et vidéos professionnelles, création de supports marketing attractifs, diffusion ciblée sur les plateformes spécialisées, activation de notre réseau de partenaires, organisation de visites virtuelles, etc. Nous pouvons également vous conseiller sur d'éventuels travaux à réaliser pour augmenter l'attractivité de votre bien.",
                  },
                ].map((item, index) => (
                  <div key={index} className="bg-white rounded-lg shadow-sm p-6 border border-gray-100">
                    <h3 className="text-lg font-semibold mb-2">{item.question}</h3>
                    <p className="text-gray-700">{item.answer}</p>
                  </div>
                ))}
              </div>
            </section>

            {/* Section témoignages */}
            <section id="temoignages" className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Ce que disent nos clients</h2>
              <div className="grid md:grid-cols-2 gap-6">
                {[
                  {
                    name: "Jean-Pierre M.",
                    role: "Propriétaire d'un immeuble de bureaux",
                    testimonial:
                      "L'équipe commerciale de DOGES a réussi à louer l'intégralité de mon immeuble de bureaux en moins de 4 mois, alors qu'il était vacant depuis plus d'un an. Leur approche proactive et leur réseau ont fait toute la différence.",
                    rating: 5,
                  },
                  {
                    name: "Sophie L.",
                    role: "Investisseur immobilier",
                    testimonial:
                      "Je fais confiance à DOGES pour la commercialisation de tous mes biens. Leur connaissance du marché et leur capacité à négocier les meilleures conditions me permettent d'optimiser la rentabilité de mon patrimoine.",
                    rating: 5,
                  },
                  {
                    name: "Groupe Immocorp",
                    role: "Foncière commerciale",
                    testimonial:
                      "Nous collaborons avec DOGES depuis plus de 5 ans pour la commercialisation de nos actifs en Île-de-France. Leur professionnalisme et leur réactivité en font un partenaire de confiance pour notre développement.",
                    rating: 4,
                  },
                  {
                    name: "Marc D.",
                    role: "Propriétaire d'une boutique",
                    testimonial:
                      "Après plusieurs mois sans succès avec une autre agence, DOGES a trouvé un locataire sérieux pour ma boutique en seulement 6 semaines. Je recommande vivement leur service commercial.",
                    rating: 5,
                  },
                ].map((testimonial, index) => (
                  <div key={index} className="bg-white rounded-lg shadow-sm p-6 border border-gray-100">
                    <div className="flex items-center mb-4">
                      {[...Array(testimonial.rating)].map((_, i) => (
                        <svg
                          key={i}
                          className="w-5 h-5 text-yellow-400"
                          fill="currentColor"
                          viewBox="0 0 20 20"
                          xmlns="http://www.w3.org/2000/svg"
                        >
                          <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                      ))}
                    </div>
                    <p className="text-gray-700 mb-4 italic">"{testimonial.testimonial}"</p>
                    <div>
                      <p className="font-semibold">{testimonial.name}</p>
                      <p className="text-sm text-gray-500">{testimonial.role}</p>
                    </div>
                  </div>
                ))}
              </div>
            </section>
          </div>

          {/* Sidebar */}
          <div className="lg:w-1/3">
            {/* Table des matières */}
            <div className="mb-6">
              <TableOfContentsWidget items={tocItems} />
            </div>

            {/* Widget de contact */}
            <div className="mb-6">
              <ContactWidget />
            </div>

            {/* Services associés */}
            <div className="mb-6">
              <RelatedServicesWidget services={relatedServices} />
            </div>
          </div>
        </div>

        {/* CTA final */}
        <div className="mt-12">
          <ConsultationCTA
            title="Besoin d'un service commercial efficace pour votre bien immobilier ?"
            description="Contactez notre équipe d'experts pour une évaluation personnalisée et une stratégie commerciale sur mesure."
            buttonText="Nous contacter"
            buttonLink="/contact"
          />
        </div>
      </div>
    </>
  )
}
