import Image from "next/image"
import { Quote, Star, ArrowRight } from "lucide-react"
import { Button } from "@/components/ui/button"
import PageHeader from "@/components/page-header"

export default function TemoignagesPage() {
  // Témoignages clients
  const testimonials = [
    {
      name: "Jean-Marc Dupont",
      role: "Propriétaire à Paris 16ème",
      image: "/placeholder.svg?height=100&width=100",
      rating: 5,
      text: "DOGES gère mes trois appartements depuis plus de 10 ans. Leur professionnalisme et leur réactivité m'ont permis de ne jamais avoir de période de vacance locative. Je recommande vivement leurs services à tous les propriétaires qui cherchent une gestion sans souci de leur patrimoine.",
      date: "Janvier 2024",
    },
    {
      name: "Sophie Lefebvre",
      role: "Propriétaire à Neuilly-sur-Seine",
      image: "/placeholder.svg?height=100&width=100",
      rating: 5,
      text: "Après plusieurs mauvaises expériences avec d'autres agences, j'ai confié la gestion de mon bien à DOGES il y a 5 ans. Quelle différence ! Une équipe à l'écoute, réactive et professionnelle. Les loyers sont versés régulièrement et je reçois des rapports détaillés sur la gestion de mon bien. Je ne peux que les recommander.",
      date: "Décembre 2023",
    },
    {
      name: "Philippe Martin",
      role: "Propriétaire à Boulogne-Billancourt",
      image: "/placeholder.svg?height=100&width=100",
      rating: 4,
      text: "Je suis client de DOGES depuis 3 ans pour la gestion de mon appartement à Boulogne. J'apprécie particulièrement leur transparence sur les frais et leur réactivité en cas de problème. Les locataires qu'ils ont sélectionnés sont sérieux et respectueux du bien. Un seul petit bémol sur la communication qui pourrait être plus régulière.",
      date: "Novembre 2023",
    },
    {
      name: "Marie Dubois",
      role: "Propriétaire à Paris 8ème",
      image: "/placeholder.svg?height=100&width=100",
      rating: 5,
      text: "DOGES a géré la vente de mon appartement dans le 8ème arrondissement. Leur estimation était juste et la vente s'est conclue rapidement à un prix supérieur à mes attentes. L'accompagnement tout au long du processus a été exemplaire. Je n'hésiterai pas à faire appel à eux pour mes futurs projets immobiliers.",
      date: "Octobre 2023",
    },
    {
      name: "Laurent Bernard",
      role: "Investisseur immobilier",
      image: "/placeholder.svg?height=100&width=100",
      rating: 5,
      text: "En tant qu'investisseur possédant plusieurs biens à Paris, je cherchais un gestionnaire capable de m'offrir un service complet et personnalisé. DOGES a parfaitement répondu à mes attentes. Leur forfait Sérénité me permet de déléguer entièrement la gestion de mes biens tout en maximisant ma rentabilité. Un partenaire de confiance.",
      date: "Septembre 2023",
    },
    {
      name: "Isabelle Moreau",
      role: "Propriétaire à Paris 11ème",
      image: "/placeholder.svg?height=100&width=100",
      rating: 5,
      text: "J'ai fait appel à DOGES pour la mise en location de mon studio dans le 11ème. Le bien a été loué en moins d'une semaine à un excellent locataire. Les honoraires sont raisonnables et le service impeccable. Je recommande sans hésitation.",
      date: "Août 2023",
    },
    {
      name: "Pierre Durand",
      role: "Syndic de copropriété",
      image: "/placeholder.svg?height=100&width=100",
      rating: 4,
      text: "Notre copropriété a changé de syndic il y a 2 ans pour DOGES. La différence est notable : meilleure communication, transparence dans les comptes et réactivité dans la gestion des problèmes. Les copropriétaires sont globalement très satisfaits de ce changement.",
      date: "Juillet 2023",
    },
    {
      name: "Catherine Leroy",
      role: "Propriétaire à Paris 15ème",
      image: "/placeholder.svg?height=100&width=100",
      rating: 5,
      text: "DOGES gère mon appartement depuis 7 ans maintenant. J'apprécie particulièrement leur service client : toujours disponibles, à l'écoute et efficaces. Les problèmes sont résolus rapidement et les comptes-rendus sont clairs et détaillés. Une gestion sans stress pour moi qui habite à l'étranger.",
      date: "Juin 2023",
    },
    {
      name: "Thomas Petit",
      role: "Propriétaire à Levallois-Perret",
      image: "/placeholder.svg?height=100&width=100",
      rating: 5,
      text: "J'ai confié la gestion de mon appartement à DOGES après une recommandation d'un ami. Je ne regrette pas mon choix ! Leur équipe est professionnelle, les honoraires sont transparents et compétitifs, et la qualité du service est au rendez-vous. Un grand merci à toute l'équipe.",
      date: "Mai 2023",
    },
  ]

  // Statistiques de satisfaction
  const satisfactionStats = [
    { label: "Clients satisfaits", value: "98%" },
    { label: "Recommandation", value: "96%" },
    { label: "Fidélité client", value: "8 ans" },
    { label: "Réactivité", value: "24h" },
  ]

  return (
    <>
      <PageHeader
        title="Témoignages Clients"
        description="Découvrez ce que nos clients disent de nos services"
        breadcrumbs={[{ label: "Témoignages", href: "/temoignages" }]}
        backgroundImage="https://images.unsplash.com/photo-1573497019940-1c28c88b4f3e?q=80&w=2070&auto=format&fit=crop"
      >
        <script
          type="application/ld+json"
          dangerouslySetInnerHTML={{
            __html: JSON.stringify({
              "@context": "https://schema.org",
              "@type": "ItemList",
              itemListElement: testimonials.map((testimonial, index) => ({
                "@type": "ListItem",
                position: index + 1,
                item: {
                  "@type": "Review",
                  reviewRating: {
                    "@type": "Rating",
                    ratingValue: testimonial.rating,
                    bestRating: "5",
                  },
                  author: {
                    "@type": "Person",
                    name: testimonial.name,
                  },
                  datePublished: testimonial.date,
                  reviewBody: testimonial.text,
                  itemReviewed: {
                    "@type": "RealEstateAgent",
                    name: "DOGES",
                    url: "https://www.doges.fr",
                  },
                },
              })),
            }),
          }}
        />
      </PageHeader>

      {/* Statistiques de satisfaction */}
      <section className="py-12 bg-gray-50">
        <div className="container mx-auto px-4">
          <div className="grid grid-cols-2 md:grid-cols-4 gap-6">
            {satisfactionStats.map((stat, index) => (
              <div key={index} className="bg-white rounded-xl shadow-sm p-6 text-center">
                <div className="text-4xl font-bold text-[#002395] mb-2">{stat.value}</div>
                <div className="text-gray-600">{stat.label}</div>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Témoignages */}
      <section className="py-16">
        <div className="container mx-auto px-4">
          <h2 className="text-3xl font-bold mb-12 text-center text-[#002395]">Ce que disent nos clients</h2>

          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            {testimonials.map((testimonial, index) => (
              <div key={index} className="bg-white rounded-xl shadow-lg p-8">
                <Quote className="h-8 w-8 text-[#002395] mb-4 opacity-50" />
                <div className="flex mb-4">
                  {Array.from({ length: 5 }).map((_, i) => (
                    <Star
                      key={i}
                      className={`h-5 w-5 ${
                        i < testimonial.rating ? "text-yellow-400 fill-yellow-400" : "text-gray-300"
                      }`}
                    />
                  ))}
                </div>
                <p className="text-gray-700 mb-6">{testimonial.text}</p>
                <div className="flex items-center">
                  <div className="relative w-12 h-12 mr-4">
                    <Image
                      src={testimonial.image || "/placeholder.svg"}
                      alt={testimonial.name}
                      fill
                      className="object-cover rounded-full"
                    />
                  </div>
                  <div>
                    <p className="font-semibold">{testimonial.name}</p>
                    <p className="text-sm text-gray-600">{testimonial.role}</p>
                  </div>
                  <div className="ml-auto text-sm text-gray-500">{testimonial.date}</div>
                </div>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Vidéo témoignage */}
      <section className="py-16 bg-gray-50">
        <div className="container mx-auto px-4">
          <h2 className="text-3xl font-bold mb-12 text-center text-[#002395]">Témoignages Vidéo</h2>

          <div className="grid md:grid-cols-2 gap-12 items-center">
            <div className="relative h-[400px] rounded-xl overflow-hidden shadow-lg">
              {/* Placeholder pour une vidéo */}
              <div className="absolute inset-0 bg-gray-800 flex items-center justify-center">
                <div className="w-20 h-20 rounded-full bg-white/20 flex items-center justify-center">
                  <div className="w-16 h-16 rounded-full bg-white flex items-center justify-center">
                    <ArrowRight className="h-8 w-8 text-[#002395] ml-1" />
                  </div>
                </div>
              </div>
            </div>

            <div>
              <h3 className="text-2xl font-bold mb-4">L'expérience DOGES racontée par nos clients</h3>
              <p className="text-lg text-gray-700 mb-6">
                Écoutez les témoignages de nos clients satisfaits qui partagent leur expérience avec DOGES. Découvrez
                comment notre équipe les a accompagnés dans la gestion de leur patrimoine immobilier.
              </p>
              <p className="text-lg text-gray-700 mb-6">
                De la recherche de locataires à la gestion quotidienne, en passant par les aspects administratifs et
                techniques, nos clients témoignent de notre professionnalisme et de notre engagement à leur offrir un
                service d'excellence.
              </p>
              <Button className="bg-gradient-to-r from-[#002395] to-[#001875]">
                Voir plus de témoignages vidéo
                <ArrowRight className="ml-2 h-4 w-4" />
              </Button>
            </div>
          </div>
        </div>
      </section>

      {/* Partagez votre expérience */}
      <section className="py-16">
        <div className="container mx-auto px-4 text-center">
          <h2 className="text-3xl font-bold mb-6 text-[#002395]">Partagez votre expérience</h2>
          <p className="text-lg text-gray-700 mb-8 max-w-2xl mx-auto">
            Vous êtes client de DOGES ? Nous serions ravis de connaître votre expérience avec nos services. Votre
            témoignage nous aide à nous améliorer et à mieux servir nos clients.
          </p>
          <Button className="bg-gradient-to-r from-[#002395] to-[#001875]">
            Laisser un témoignage
            <ArrowRight className="ml-2 h-4 w-4" />
          </Button>
        </div>
      </section>

      {/* CTA */}
      <section className="py-16 bg-gradient-to-r from-[#002395] to-[#001875] text-white">
        <div className="container mx-auto px-4 text-center">
          <h2 className="text-3xl font-bold mb-6">Prêt à rejoindre nos clients satisfaits ?</h2>
          <p className="text-xl mb-8 max-w-2xl mx-auto">
            Contactez-nous dès aujourd'hui pour découvrir comment nous pouvons vous aider à gérer votre patrimoine
            immobilier.
          </p>
          <div className="flex flex-col sm:flex-row justify-center gap-4">
            <Button className="bg-white text-[#002395] hover:bg-gray-100">
              Demander un devis
              <ArrowRight className="ml-2 h-4 w-4" />
            </Button>
            <Button variant="outline" className="border-white text-white hover:bg-white hover:text-[#002395]">
              Nous contacter
            </Button>
          </div>
        </div>
      </section>
    </>
  )
}
