import Image from "next/image"
import Link from "next/link"

interface BlogAuthorProps {
  author?: {
    name: string
    role: string
    image: string
    bio: string
    linkedin?: string
  }
  compact?: boolean
  showLinkedin?: boolean
  className?: string
}

export function BlogAuthor({
  author = {
    name: "Bedis Iddir",
    role: "Expert en gestion immobilière",
    image: "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/image-bHQ2aX36fn3BBNh0aqRaeaBzjc1xSy.png",
    bio: "Plus de 13 ans d'expérience en gestion immobilière et en gestion de patrimoine immobilier.",
    linkedin: "https://www.linkedin.com/in/bedis-iddir/",
  },
  compact = false,
  showLinkedin = true,
  className = "",
}: BlogAuthorProps) {
  return (
    <div className={`bg-white rounded-xl shadow-sm p-6 border border-gray-100 ${className}`}>
      <h3 className="text-xl font-bold mb-4">À propos de l'auteur</h3>
      <div className="flex items-center mb-4">
        <div className="relative w-16 h-16 mr-4">
          <Image
            src={author.image || "/placeholder.svg"}
            alt={author.name}
            fill
            className="object-cover rounded-full"
          />
        </div>
        <div>
          <p className="font-semibold">{author.name}</p>
          <p className="text-sm text-gray-600">{author.role}</p>
        </div>
      </div>

      {!compact && <p className="text-gray-700 text-sm">{author.bio}</p>}

      {showLinkedin && author.linkedin && (
        <Link
          href={author.linkedin}
          target="_blank"
          rel="noopener noreferrer"
          className="text-blue-600 hover:underline text-sm flex items-center mt-2"
        >
          <svg
            xmlns="http://www.w3.org/2000/svg"
            width="16"
            height="16"
            viewBox="0 0 24 24"
            fill="currentColor"
            className="mr-1"
          >
            <path d="M19 0h-14c-2.761 0-5 2.239-5 5v14c0 2.761 2.239 5 5 5h14c2.762 0 5-2.239 5-5v-14c0-2.761-2.238-5-5-5zm-11 19h-3v-11h3v11zm-1.5-12.268c-.966 0-1.75-.79-1.75-1.764s.784-1.764 1.75-1.764 1.75.79 1.75 1.764-.783 1.764-1.75 1.764zm13.5 12.268h-3v-5.604c0-3.368-4-3.113-4 0v5.604h-3v-11h3v1.765c1.396-2.586 7-2.777 7 2.476v6.759z" />
          </svg>
          Voir son profil LinkedIn
        </Link>
      )}
    </div>
  )
}

// Exporter également comme export par défaut pour la compatibilité
export default BlogAuthor
