"use client"

import { useState, useEffect } from "react"
import Link from "next/link"
import { ChevronLeft } from "lucide-react"

interface BlogHeaderProps {
  title: string
  date?: string
  category?: string
  readingTime?: string
  image?: string
}

export default function BlogHeader({ title, date, category, readingTime, image }: BlogHeaderProps) {
  const [isScrolled, setIsScrolled] = useState(false)

  useEffect(() => {
    const handleScroll = () => {
      setIsScrolled(window.scrollY > 100)
    }

    window.addEventListener("scroll", handleScroll)
    return () => window.removeEventListener("scroll", handleScroll)
  }, [])

  return (
    <div className="relative w-full">
      {/* Image de fond */}
      <div
        className="absolute inset-0 bg-cover bg-center"
        style={{
          backgroundImage: `url(${image || "/default-article-image.jpg"})`,
          filter: "brightness(0.4)",
        }}
      />

      {/* Contenu du header */}
      <div className="relative container mx-auto px-4 py-16 md:py-24 text-white">
        <Link href="/blog" className="inline-flex items-center text-white hover:text-gray-200 transition-colors mb-6">
          <ChevronLeft className="h-4 w-4 mr-1" />
          Retour au blog
        </Link>

        <h1 className="text-3xl md:text-5xl font-bold mb-4 max-w-4xl">{title}</h1>

        <div className="flex flex-wrap items-center gap-x-4 gap-y-2 text-sm md:text-base">
          {date && <span>{date}</span>}
          {category && (
            <>
              <span className="hidden md:inline">•</span>
              <Link href={`/blog/categories/${encodeURIComponent(category.toLowerCase())}`} className="hover:underline">
                {category}
              </Link>
            </>
          )}
          {readingTime && (
            <>
              <span className="hidden md:inline">•</span>
              <span>{readingTime}</span>
            </>
          )}
        </div>
      </div>
    </div>
  )
}
