import Link from "next/link"
import { ChevronRight } from "lucide-react"
import { type BreadcrumbItem, BreadcrumbSchema } from "./schema/breadcrumb-schema"

interface BreadcrumbProps {
  items: BreadcrumbItem[]
  className?: string
}

export function Breadcrumb({ items, className = "" }: BreadcrumbProps) {
  // Ne pas afficher le fil d'Ariane s'il n'y a pas d'éléments
  if (!items || items.length === 0) return null

  return (
    <>
      {/* Ajouter le schéma structuré pour le fil d'Ariane */}
      <BreadcrumbSchema items={items} />

      {/* Afficher le fil d'Ariane visuellement */}
      <nav aria-label="Fil d'Ariane" className={`text-sm ${className}`}>
        <ol className="flex flex-wrap items-center">
          <li className="flex items-center">
            <Link href="/" className="hover:text-white transition-colors">
              Accueil
            </Link>
          </li>

          {items.map((item, index) => (
            <li key={index} className="flex items-center">
              <ChevronRight className="h-4 w-4 mx-2 text-white/70" />
              {index === items.length - 1 ? (
                <span className="font-medium text-white">{item.name}</span>
              ) : (
                <Link href={item.url} className="hover:text-white transition-colors">
                  {item.name}
                </Link>
              )}
            </li>
          ))}
        </ol>
      </nav>
    </>
  )
}

export default Breadcrumb
