"use client"

import type React from "react"

import { useState } from "react"
import { Button } from "@/components/ui/button"
import { Input } from "@/components/ui/input"
import { MessageCircle, X, Send } from "lucide-react"

export default function ChatWidget() {
  const [isOpen, setIsOpen] = useState(false)
  const [messages, setMessages] = useState<{ text: string; sender: "user" | "agent" }[]>([
    { text: "Bonjour ! Comment puis-je vous aider ?", sender: "agent" },
  ])
  const [input, setInput] = useState("")

  const sendMessage = (e: React.FormEvent) => {
    e.preventDefault()
    if (!input.trim()) return

    setMessages((prev) => [...prev, { text: input, sender: "user" }])
    setInput("")

    // Simuler une réponse de l'agent
    setTimeout(() => {
      setMessages((prev) => [
        ...prev,
        {
          text: "Un agent va vous répondre dans quelques instants.",
          sender: "agent",
        },
      ])
    }, 1000)
  }

  return (
    <div className="fixed bottom-4 right-4 z-50">
      {isOpen ? (
        <div className="bg-white rounded-lg shadow-2xl w-80 h-96 flex flex-col">
          <div className="p-4 bg-gradient-to-r from-[#002395] to-[#001875] text-white rounded-t-lg flex justify-between items-center">
            <h3 className="font-semibold">Chat en direct</h3>
            <Button
              variant="ghost"
              size="sm"
              className="text-white hover:text-white/80"
              onClick={() => setIsOpen(false)}
            >
              <X className="h-4 w-4" />
            </Button>
          </div>
          <div className="flex-1 overflow-y-auto p-4 space-y-4">
            {messages.map((message, i) => (
              <div key={i} className={`flex ${message.sender === "user" ? "justify-end" : "justify-start"}`}>
                <div
                  className={`p-2 rounded-lg max-w-[80%] ${
                    message.sender === "user" ? "bg-[#002395] text-white" : "bg-gray-100 text-gray-800"
                  }`}
                >
                  {message.text}
                </div>
              </div>
            ))}
          </div>
          <form onSubmit={sendMessage} className="p-4 border-t flex gap-2">
            <Input
              value={input}
              onChange={(e) => setInput(e.target.value)}
              placeholder="Votre message..."
              className="flex-1"
            />
            <Button type="submit" variant="gradient" size="icon" className="text-white">
              <Send className="h-4 w-4" />
            </Button>
          </form>
        </div>
      ) : (
        <Button
          onClick={() => setIsOpen(true)}
          className="rounded-full w-12 h-12 bg-gradient-to-r from-[#002395] to-[#001875] flex items-center justify-center"
          aria-label="Ouvrir le chat"
        >
          <MessageCircle className="h-6 w-6 text-white" />
        </Button>
      )}
    </div>
  )
}
