"use client"

import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"

export default function ComponentStandardizationAudit() {
  const componentIssues = [
    {
      category: "Calculateurs",
      issues: [
        "4 composants calculateurs avec logique similaire",
        "Props non standardisées entre calculateurs",
        "Code de validation dupliqué",
      ],
      recommendation: "Créer un composant BaseCalculator réutilisable",
    },
    {
      category: "Headers",
      issues: [
        "PageHeader, BlogHeader, ServiceHeader font la même chose",
        "Props différentes pour le même résultat",
        "Styles inconsistants",
      ],
      recommendation: "Unifier en un seul composant Header avec variants",
    },
    {
      category: "Cards",
      issues: [
        "ServiceCard, PropertyCard, VilleCard très similaires",
        "Logique d'image dupliquée",
        "Boutons CTA non standardisés",
      ],
      recommendation: "Créer un composant Card générique avec slots",
    },
    {
      category: "Forms",
      issues: [
        "ContactForm, DevisForm, SmartContactForm redondants",
        "Validation non centralisée",
        "Gestion d'erreurs différente",
      ],
      recommendation: "Utiliser React Hook Form avec un wrapper standardisé",
    },
  ]

  return (
    <div className="space-y-6">
      <h2 className="text-2xl font-bold">Audit de Standardisation des Composants</h2>

      {componentIssues.map((item, index) => (
        <Card key={index}>
          <CardHeader>
            <CardTitle className="text-lg">{item.category}</CardTitle>
          </CardHeader>
          <CardContent>
            <div className="space-y-3">
              <div>
                <h4 className="font-medium text-red-600 mb-2">Problèmes détectés:</h4>
                <ul className="text-sm space-y-1">
                  {item.issues.map((issue, i) => (
                    <li key={i} className="flex items-start gap-2">
                      <span className="text-red-500 mt-1">•</span>
                      <span>{issue}</span>
                    </li>
                  ))}
                </ul>
              </div>

              <div className="p-3 bg-green-50 border border-green-200 rounded">
                <h4 className="font-medium text-green-800 mb-1">Recommandation:</h4>
                <p className="text-sm text-green-700">{item.recommendation}</p>
              </div>
            </div>
          </CardContent>
        </Card>
      ))}
    </div>
  )
}
