"use client"
import { Button } from "@/components/ui/button"
import { Mail, FileText } from "lucide-react"

interface ContactTabsProps {
  activeTab: "contact" | "devis"
  onChange: (tab: "contact" | "devis") => void
}

export function ContactTabs({ activeTab, onChange }: ContactTabsProps) {
  return (
    <div className="flex w-full rounded-t-lg overflow-hidden mb-6 border-b border-gray-200">
      <Button
        variant="ghost"
        className={`flex-1 rounded-none py-4 ${
          activeTab === "contact"
            ? "bg-[#002395] text-white hover:bg-[#001d80]"
            : "bg-gray-100 text-gray-700 hover:bg-gray-200"
        }`}
        onClick={() => onChange("contact")}
      >
        <Mail className="mr-2 h-5 w-5" />
        Contact
      </Button>
      <Button
        variant="ghost"
        className={`flex-1 rounded-none py-4 ${
          activeTab === "devis"
            ? "bg-[#002395] text-white hover:bg-[#001d80]"
            : "bg-gray-100 text-gray-700 hover:bg-gray-200"
        }`}
        onClick={() => onChange("devis")}
      >
        <FileText className="mr-2 h-5 w-5" />
        Demande de devis
      </Button>
    </div>
  )
}
