import Link from "next/link"
import { Phone, Mail, MapPin } from "lucide-react"
import { Card, CardContent } from "@/components/ui/card"

export function ContactWidget() {
  return (
    <Card className="bg-white rounded-lg shadow-sm border border-gray-100 mb-6">
      <CardContent className="p-4 sm:p-6">
        <h3 className="text-lg sm:text-xl font-bold mb-2 sm:mb-3">Contact rapide</h3>
        <p className="text-sm sm:text-base text-gray-600 mb-4">Notre équipe vous répond sous 24h</p>

        <div className="space-y-3 sm:space-y-4 mb-4 sm:mb-6">
          <div className="flex items-center">
            <Phone className="h-4 w-4 sm:h-5 sm:w-5 text-[#002395] mr-2 sm:mr-3 flex-shrink-0" />
            <a href="tel:0184809810" className="text-sm sm:text-base hover:text-[#002395] transition-colors">
              01 84 80 98 10
            </a>
          </div>
          <div className="flex items-center">
            <Mail className="h-4 w-4 sm:h-5 sm:w-5 text-[#002395] mr-2 sm:mr-3 flex-shrink-0" />
            <a
              href="mailto:contact@dogesadb.fr"
              className="text-sm sm:text-base hover:text-[#002395] transition-colors break-all"
            >
              contact@dogesadb.fr
            </a>
          </div>
          <div className="flex items-start">
            <MapPin className="h-4 w-4 sm:h-5 sm:w-5 text-[#002395] mr-2 sm:mr-3 mt-1 flex-shrink-0" />
            <address className="not-italic text-sm sm:text-base">92, Avenue de Saint-Mandé, Paris 12e</address>
          </div>
        </div>

        <Link
          href="/contact"
          className="block w-full bg-[#002395] hover:bg-[#001875] text-white py-2 sm:py-3 px-4 rounded text-center font-medium text-sm sm:text-base transition-colors"
        >
          Nous contacter
        </Link>
      </CardContent>
    </Card>
  )
}

export default ContactWidget
