"use client"

import Link from "next/link"
import { ArrowRight } from "lucide-react"

interface CTASectionProps {
  title?: string
  description?: string
  buttonText?: string
  buttonLink?: string
}

export default function CTASection({
  title = "Prêt à nous confier votre bien ?",
  description = "Bénéficiez de notre expertise et de notre engagement pour une gestion optimale de votre patrimoine immobilier.",
  buttonText = "Demander un devis",
  buttonLink = "/contact",
}: CTASectionProps) {
  return (
    <section className="py-16 bg-gradient-to-r from-[#002395] to-[#001875] text-white">
      <div className="container mx-auto px-4 text-center">
        <h2 className="text-3xl font-bold mb-6">{title}</h2>
        <p className="text-xl mb-8 max-w-2xl mx-auto">{description}</p>
        <div className="flex flex-col sm:flex-row justify-center gap-4">
          <Link
            href={buttonLink}
            className="inline-block bg-white text-[#002395] hover:bg-gray-100 px-4 py-2 rounded-md font-medium transition-colors"
          >
            {buttonText}
            <ArrowRight className="ml-2 h-4 w-4 inline" />
          </Link>
          <Link
            href="/contact"
            className="inline-block border-2 border-white text-white hover:bg-white hover:text-[#002395] px-4 py-2 rounded-md font-medium transition-colors"
          >
            Nous contacter
          </Link>
        </div>
      </div>
    </section>
  )
}
