"use client"

import { useState, useEffect } from "react"
import { Button } from "@/components/ui/button"

export default function FloatingCTAButton() {
  const [isVisible, setIsVisible] = useState(false)

  useEffect(() => {
    const handleScroll = () => {
      // Afficher le bouton après avoir défilé de 300px
      if (window.scrollY > 300) {
        setIsVisible(true)
      } else {
        setIsVisible(false)
      }
    }

    window.addEventListener("scroll", handleScroll)
    return () => window.removeEventListener("scroll", handleScroll)
  }, [])

  return (
    <div
      className={`fixed bottom-6 right-6 z-50 transition-all duration-300 ${
        isVisible ? "translate-y-0 opacity-100" : "translate-y-20 opacity-0"
      }`}
    >
      <Button
        className="bg-[#002395] hover:bg-[#001875] text-white px-6 py-6 rounded-lg shadow-lg font-medium text-sm"
        onClick={() => (window.location.href = "/contact")}
      >
        CONFIEZ-NOUS VOTRE BIEN
      </Button>
    </div>
  )
}
