import Link from "next/link"
import Image from "next/image"

interface FranceVilleCardProps {
  nom: string
  slug: string
  region: string
  description?: string
  imagePath?: string
}

export default function FranceVilleCard({ nom, slug, region, description, imagePath }: FranceVilleCardProps) {
  return (
    <Link
      href={`/services/gestion-locative-france/${slug}`}
      className="block bg-white rounded-lg overflow-hidden shadow-md hover:shadow-lg transition-shadow"
      title={`Agence immobilière et gestion locative à ${nom}`}
    >
      <div className="relative h-48">
        <Image
          src={imagePath || "/immobilier-scene.png"}
          alt={`Agence de gestion locative à ${nom} - DOGES`}
          fill
          className="object-cover"
        />
        <div className="absolute inset-0 bg-gradient-to-t from-black/70 to-transparent"></div>
        <div className="absolute bottom-0 left-0 p-4">
          <h3 className="text-xl font-bold text-white">Gestion Locative à {nom}</h3>
          <p className="text-white/90 text-sm">{region}</p>
        </div>
      </div>
      <div className="p-4">
        <p className="text-gray-700 line-clamp-3">
          {description ||
            `Découvrez nos services d'agence immobilière et de gestion locative à ${nom}. Confiez-nous la gestion de votre appartement ou maison et bénéficiez de notre expertise locale.`}
        </p>
        <div className="mt-3 text-[#002395] font-medium flex items-center">
          En savoir plus
          <svg
            xmlns="http://www.w3.org/2000/svg"
            className="h-4 w-4 ml-1"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
          >
            <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 5l7 7-7 7" />
          </svg>
        </div>
      </div>
    </Link>
  )
}
