import Link from "next/link"
import { SafeImage } from "@/components/safe-image"

export interface RelatedArticle {
  slug: string
  title: string
  description: string
  image: string
  date: string
}

interface RelatedArticlesCardsProps {
  articles: RelatedArticle[]
}

export function RelatedArticlesCards({ articles }: RelatedArticlesCardsProps) {
  if (!articles || articles.length === 0) return null

  return (
    <div className="mt-10">
      <h2 className="text-2xl font-bold mb-6">Articles liés</h2>
      <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
        {articles.map((article, index) => (
          <Link
            href={`/blog/articles/${article.slug}`}
            key={index}
            className="group flex flex-col md:flex-row gap-4 hover:bg-gray-50 p-2 rounded-lg transition-colors"
          >
            <div className="w-full md:w-1/3 aspect-[4/3] relative overflow-hidden rounded-lg">
              <SafeImage
                src={article.image}
                alt={article.title}
                className="object-cover w-full h-full group-hover:scale-105 transition-transform duration-300"
                width={200}
                height={150}
              />
            </div>
            <div className="w-full md:w-2/3">
              <h3 className="font-bold text-lg group-hover:text-blue-600 transition-colors">{article.title}</h3>
              <p className="text-gray-600 text-sm mt-1 line-clamp-2">{article.description}</p>
              <p className="text-gray-500 text-xs mt-2">{article.date}</p>
            </div>
          </Link>
        ))}
      </div>
    </div>
  )
}
