import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import Link from "next/link"
import { ArrowRight } from "lucide-react"

interface RelatedService {
  title: string
  description?: string
  link: string
}

interface RelatedServicesWidgetProps {
  title?: string
  services: RelatedService[]
}

export default function RelatedServicesWidget({ title = "Services associés", services }: RelatedServicesWidgetProps) {
  return (
    <Card className="border border-gray-100 shadow-sm mb-6">
      <CardHeader className="pb-3">
        <CardTitle className="text-lg font-bold">{title}</CardTitle>
      </CardHeader>
      <CardContent className="p-4">
        <div className="space-y-4">
          {services.map((service, index) => (
            <Link
              key={index}
              href={service.link}
              className="block p-3 rounded-lg border border-gray-100 hover:border-blue-100 hover:bg-blue-50/30 transition-colors"
            >
              <h4 className="font-medium text-[#002395]">{service.title}</h4>
              <p className="text-sm text-gray-600 mt-1">{service.description}</p>
              <div className="flex items-center text-sm text-[#002395] mt-2 font-medium">
                En savoir plus <ArrowRight className="ml-1 h-3 w-3" />
              </div>
            </Link>
          ))}
        </div>
      </CardContent>
    </Card>
  )
}
