"use client"

import Image from "next/image"
import { useState } from "react"

interface SafeImageProps {
  src: string
  alt: string
  className?: string
  width?: number
  height?: number
  fill?: boolean
  priority?: boolean
}

export function SafeImage({ src, alt, className, width, height, fill, priority }: SafeImageProps) {
  const [error, setError] = useState(false)

  // Utilisez une image par défaut en cas d'erreur
  const imageSrc = error ? "/default-article-image.jpg" : src

  return (
    <Image
      src={imageSrc || "/placeholder.svg"}
      alt={alt}
      className={className}
      width={width || 800}
      height={height || 450}
      priority={priority}
      onError={() => setError(true)}
    />
  )
}

export default SafeImage
