"use client"

import { useEffect } from "react"

export interface BreadcrumbItem {
  name: string
  url: string
}

interface BreadcrumbSchemaProps {
  items: BreadcrumbItem[]
}

export function BreadcrumbSchema({ items }: BreadcrumbSchemaProps) {
  useEffect(() => {
    if (!items || items.length === 0) return

    const breadcrumbSchema = {
      "@context": "https://schema.org",
      "@type": "BreadcrumbList",
      itemListElement: items.map((item, index) => ({
        "@type": "ListItem",
        position: index + 1,
        name: item.name,
        item: item.url,
      })),
    }

    // Créer et ajouter le script JSON-LD
    const script = document.createElement("script")
    script.type = "application/ld+json"
    script.text = JSON.stringify(breadcrumbSchema)
    script.id = "breadcrumb-schema"

    // Supprimer tout script existant avec le même ID
    const existingScript = document.getElementById("breadcrumb-schema")
    if (existingScript) {
      document.head.removeChild(existingScript)
    }

    document.head.appendChild(script)

    // Nettoyer lors du démontage du composant
    return () => {
      const scriptToRemove = document.getElementById("breadcrumb-schema")
      if (scriptToRemove) {
        document.head.removeChild(scriptToRemove)
      }
    }
  }, [items])

  return null
}

// Ajouter un export par défaut pour la compatibilité
export default BreadcrumbSchema
