"use client"

import { useEffect } from "react"

export interface FAQItem {
  question: string
  answer: string
}

interface FAQSchemaProps {
  faqs: FAQItem[]
}

export function FAQSchema({ faqs }: FAQSchemaProps) {
  useEffect(() => {
    if (!faqs || faqs.length === 0) return

    const faqSchema = {
      "@context": "https://schema.org",
      "@type": "FAQPage",
      mainEntity: faqs.map((faq) => ({
        "@type": "Question",
        name: faq.question,
        acceptedAnswer: {
          "@type": "Answer",
          text: faq.answer,
        },
      })),
    }

    // Créer et ajouter le script JSON-LD
    const script = document.createElement("script")
    script.type = "application/ld+json"
    script.text = JSON.stringify(faqSchema)
    script.id = "faq-schema"

    // Supprimer tout script existant avec le même ID
    const existingScript = document.getElementById("faq-schema")
    if (existingScript) {
      document.head.removeChild(existingScript)
    }

    document.head.appendChild(script)

    // Nettoyer lors du démontage du composant
    return () => {
      const scriptToRemove = document.getElementById("faq-schema")
      if (scriptToRemove) {
        document.head.removeChild(scriptToRemove)
      }
    }
  }, [faqs])

  return null
}
