"use client"

import { useEffect } from "react"

interface HowToStep {
  name: string
  text: string
  image?: string
  url?: string
}

interface HowToSchemaCalculateursProps {
  name: string
  description: string
  steps: HowToStep[]
}

export function HowToSchemaCalculateurs({ name, description, steps }: HowToSchemaCalculateursProps) {
  useEffect(() => {
    const howToSchema = {
      "@context": "https://schema.org",
      "@type": "HowTo",
      name,
      description,
      step: steps.map((step, index) => ({
        "@type": "HowToStep",
        url: step.url || `https://dogesadb.fr/calculateurs#step-${index + 1}`,
        name: step.name,
        itemListElement: {
          "@type": "HowToDirection",
          text: step.text,
        },
        ...(step.image && { image: step.image }),
      })),
    }

    // Créer et ajouter le script JSON-LD
    const script = document.createElement("script")
    script.type = "application/ld+json"
    script.text = JSON.stringify(howToSchema)
    script.id = "howto-schema-calculateurs"

    // Supprimer tout script existant avec le même ID
    const existingScript = document.getElementById("howto-schema-calculateurs")
    if (existingScript) {
      document.head.removeChild(existingScript)
    }

    document.head.appendChild(script)

    // Nettoyer lors du démontage du composant
    return () => {
      const scriptToRemove = document.getElementById("howto-schema-calculateurs")
      if (scriptToRemove) {
        document.head.removeChild(scriptToRemove)
      }
    }
  }, [name, description, steps])

  return null
}
