"use client"

import Link from "next/link"
import { usePathname } from "next/navigation"
import { Phone } from "lucide-react"
import { Button } from "@/components/ui/button"
import { useState } from "react"
import { Menu, X } from "lucide-react"

export default function TransparentHeader() {
  const [mobileMenuOpen, setMobileMenuOpen] = useState(false)
  const pathname = usePathname()

  const isActive = (path: string) => {
    if (path === "/" && pathname !== "/") return false
    return pathname === path || pathname.startsWith(`${path}/`)
  }

  return (
    <>
      <header
        className="fixed top-0 left-0 right-0 z-50"
        style={{
          backgroundColor: "rgba(0, 0, 0, 0.2)",
          backdropFilter: "blur(10px)",
          WebkitBackdropFilter: "blur(10px)",
        }}
      >
        <div className="container mx-auto px-4">
          <div className="flex items-center justify-between h-24">
            <Link href="/" className="flex items-center space-x-3">
              <div className="relative w-14 h-14">
                <div className="absolute inset-0 bg-gradient-to-br from-[#002395] to-[#001875] flex items-center justify-center text-white font-bold text-2xl rounded-lg shadow-lg">
                  D
                </div>
              </div>
              <div className="flex flex-col">
                <span className="text-2xl font-bold bg-gradient-to-r from-[#002395] to-[#001875] bg-clip-text text-transparent">
                  DOGES.
                </span>
                <span className="text-sm uppercase tracking-wider text-white">Administrateur de biens</span>
              </div>
            </Link>

            {/* Navigation Links */}
            <nav className="hidden lg:flex items-center space-x-6">
              {[
                { name: "ACCUEIL", href: "/" },
                { name: "À PROPOS", href: "/a-propos" },
                { name: "SERVICES", href: "/services" },
                { name: "TARIFS", href: "/tarifs" },
                { name: "TÉMOIGNAGES", href: "/temoignages" },
                { name: "BLOG", href: "/blog" },
                { name: "FAQ", href: "/faq" },
                { name: "CONTACT", href: "/contact" },
              ].map((item) => (
                <Link
                  key={item.name}
                  href={item.href}
                  className="text-sm font-medium text-white hover:text-[#002395] transition-all duration-300 relative"
                >
                  {item.name}
                  <span
                    className={`absolute bottom-0 left-0 h-0.5 bg-gradient-to-r from-[#002395] to-[#001875] transition-all duration-300 w-0 hover:w-full ${
                      isActive(item.href) ? "w-full" : ""
                    }`}
                  />
                </Link>
              ))}
              <Button
                variant="gradient"
                className="text-white flex items-center space-x-2 shadow-lg transition-all duration-300 transform hover:scale-105"
                onClick={() => window.open("https://www.ringover.me/EU_X6dOeNDCcD+g58Q", "_blank")}
              >
                <Phone className="h-4 w-4" />
                <span>APPELEZ NOUS</span>
              </Button>
            </nav>

            {/* Mobile Menu Button */}
            <button
              className="lg:hidden p-2 rounded-lg hover:bg-white/10 transition-colors"
              onClick={() => setMobileMenuOpen(!mobileMenuOpen)}
              aria-label={mobileMenuOpen ? "Fermer le menu" : "Ouvrir le menu"}
            >
              <Menu className="text-white" />
            </button>
          </div>
        </div>
      </header>

      {/* Mobile Menu */}
      {mobileMenuOpen && (
        <div
          className="fixed top-24 left-0 right-0 z-50 lg:hidden"
          style={{
            backgroundColor: "rgba(0, 0, 0, 0.2)",
            backdropFilter: "blur(10px)",
            WebkitBackdropFilter: "blur(10px)",
          }}
        >
          <div className="container mx-auto px-4 py-4">
            <div className="flex justify-end mb-4">
              <button
                className="p-2 rounded-lg hover:bg-white/10 transition-colors"
                onClick={() => setMobileMenuOpen(false)}
                aria-label="Fermer le menu"
              >
                <X className="text-white" />
              </button>
            </div>
            <nav className="flex flex-col space-y-4">
              {[
                { name: "ACCUEIL", href: "/" },
                { name: "À PROPOS", href: "/a-propos" },
                { name: "SERVICES", href: "/services" },
                { name: "TARIFS", href: "/tarifs" },
                { name: "TÉMOIGNAGES", href: "/temoignages" },
                { name: "BLOG", href: "/blog" },
                { name: "FAQ", href: "/faq" },
                { name: "CONTACT", href: "/contact" },
              ].map((item) => (
                <Link
                  key={item.name}
                  href={item.href}
                  className="text-sm font-medium text-white hover:text-[#002395] transition-colors"
                  onClick={() => setMobileMenuOpen(false)}
                >
                  {item.name}
                </Link>
              ))}
              <Button
                variant="gradient"
                className="text-white flex items-center justify-center space-x-2 mt-2"
                onClick={() => window.open("https://www.ringover.me/EU_X6dOeNDCcD+g58Q", "_blank")}
              >
                <Phone className="h-4 w-4" />
                <span>APPELEZ NOUS</span>
              </Button>
            </nav>
          </div>
        </div>
      )}
    </>
  )
}
