"use client"

import Image from "next/image"
import Link from "next/link"
import { Card, CardContent } from "@/components/ui/card"

interface VilleCardProps {
  nom: string
  slug: string
  description: string
}

export default function VilleCard({ nom, slug, description }: VilleCardProps) {
  // Générer une image appropriée pour chaque ville
  const getVilleImage = (villeSlug: string) => {
    const imageMap: { [key: string]: string } = {
      "neuilly-sur-seine": "/villes/neuilly-sur-seine.png",
      "levallois-perret": "/villes/levallois-perret.png",
      "boulogne-billancourt": "/villes/boulogne-billancourt.png",
      "issy-les-moulineaux": "/villes/issy-les-moulineaux.png",
      "saint-cloud": "/villes/saint-cloud.png",
      sevres: "/villes/sevres.png",
      versailles: "/villes/versailles.png",
      "saint-germain-en-laye": "/villes/saint-germain-en-laye.png",
      "rueil-malmaison": "/villes/rueil-malmaison.png",
      courbevoie: "/villes/courbevoie.png",
      puteaux: "/villes/puteaux.png",
      suresnes: "/villes/suresnes.png",
      nanterre: "/villes/nanterre.png",
      vincennes: "/villes/vincennes.png",
      "saint-mande": "/villes/saint-mande.png",
      montreuil: "/villes/montreuil.png",
      "asnieres-sur-seine": "/villes/asnieres-sur-seine.png",
      clichy: "/villes/clichy.png",
      "la-defense": "/villes/la-defense.png",
      antony: "/villes/antony.png",
    }

    return imageMap[villeSlug] || "/villes/default-ville.png"
  }

  return (
    <Card className="overflow-hidden hover:shadow-lg transition-shadow">
      <div className="relative h-48 w-full">
        <Image
          src={getVilleImage(slug) || "/placeholder.svg"}
          alt={`Gestion locative ${nom}`}
          fill
          className="object-cover"
        />
      </div>
      <CardContent className="p-4">
        <h3 className="text-lg font-semibold mb-2">{nom}</h3>
        <p className="text-gray-600 text-sm mb-4">{description}</p>
        <Link
          href={`/services/gestion-locative-ile-de-france/${slug}`}
          className="inline-block bg-[#002395] hover:bg-[#001875] text-white px-4 py-2 rounded text-sm transition-colors"
        >
          Découvrir nos services
        </Link>
      </CardContent>
    </Card>
  )
}
