// Images unifiées avec correction pour l'encadrement des loyers
export const articleImages = {
  // GESTION LOCATIVE - Images unifiées
  "guide-proprietaire-bailleur-2025": "/professional-property-management.jpg",
  "erreurs-gestion-locative-eviter": "/property-management-team-discuss.png",
  "colocation-avantages-fiscaux-gestion": "/shared-living-space.png",
  "eviter-impayes-loyer-guide": "/rental-income-protection-security.png",
  "gestion-locative-soi-meme-ou-deleguer": "/property-keys-handover.jpg",

  // FISCALITÉ - Images unifiées
  "optimisation-fiscale-proprietaires-2025": "/fiscal-calculation-meeting.png",
  "lmnp-lmp-comparaison-statuts": "/real-lmnp-lmp-comparison.jpg",
  "avantages-fiscaux-location-meublee": "/real-furnished-rental.jpg",
  "ifi-immobilier-locatif": "/ifi-tax-calculation.png",

  // INVESTISSEMENT - Images unifiées
  "investir-immobilier-ile-de-france-2025": "/paris-investment-2025.png",
  "meilleurs-quartiers-paris-investir-2025": "/paris-arrondissements-map.png",
  "calculer-rentabilite-investissement-locatif-paris": "/rentabilite-calcul-professionnel.png",
  "investir-ancien-vs-neuf-ile-de-france": "/real-old-vs-new-property.jpg",

  // RÉGLEMENTATION - Images diversifiées avec CORRECTION
  "obligations-energetiques-proprietaires-2025": "/dpe-diagnostic-complet.png",
  "dpe-2024-changements-proprietaires": "/maison-verte-dpe.png",
  "encadrement-loyers-paris-bilan": "/paris-arrondissements-map.png", // CORRIGÉ - Image existante
  "obligations-transition-energetique": "/dpe-energy-label.png",

  // ASSURANCE - Images unifiées
  "assurance-loyers-impayes-2024": "/real-rent-insurance-2024.jpg",

  // RÉNOVATION - Images unifiées
  "travaux-renovation-valeur-locative": "/renovation-in-progress.png", // MODIFIÉ - Nouvelle image de rénovation
}

// Fonction pour obtenir l'image d'un article par son slug
export function getArticleImage(slug: string): string {
  return articleImages[slug] || "/default-article-image.jpg"
}

// Export nommé pour blogImages (alias pour articleImages)
export const blogImages = articleImages
