const { execSync } = require("child_process")
const fs = require("fs")

function checkForCommonErrors() {
  console.log("🔍 Checking for common build errors...")

  // Check for incorrect Image imports
  try {
    const result = execSync(
      'grep -r "next/Image" app/ components/ --include="*.tsx" --include="*.ts" --include="*.jsx" --include="*.js" || true',
      { encoding: "utf8" },
    )
    if (result.trim()) {
      console.log("❌ Found incorrect Image imports:")
      console.log(result)
      return false
    } else {
      console.log("✅ No incorrect Image imports found")
    }
  } catch (error) {
    console.log("✅ No incorrect Image imports found")
  }

  // Check for other common issues
  try {
    const result = execSync(
      'grep -r "import.*Image.*from.*next/Image" app/ components/ --include="*.tsx" --include="*.ts" || true',
      { encoding: "utf8" },
    )
    if (result.trim()) {
      console.log("❌ Found more incorrect Image imports:")
      console.log(result)
      return false
    }
  } catch (error) {
    // No matches found, which is good
  }

  return true
}

if (require.main === module) {
  const isClean = checkForCommonErrors()
  process.exit(isClean ? 0 : 1)
}

module.exports = { checkForCommonErrors }
