const fs = require("fs")
const path = require("path")

// Créer un fichier de redirection pour next/Image
function createRedirectModule() {
  const nodeModulesPath = path.join(process.cwd(), "node_modules")
  const nextImagePath = path.join(nodeModulesPath, "next", "Image")

  // Créer le dossier si nécessaire
  if (!fs.existsSync(path.dirname(nextImagePath))) {
    fs.mkdirSync(path.dirname(nextImagePath), { recursive: true })
  }

  // Contenu du fichier de redirection
  const redirectContent = `
// Ce fichier est une redirection pour corriger les imports incorrects
// Il redirige next/Image vers next/image
module.exports = require('next/image');
`

  // Écrire le fichier
  fs.writeFileSync(nextImagePath + ".js", redirectContent)
  console.log("✅ Created redirect module at:", nextImagePath + ".js")
}

// Fonction principale
function main() {
  console.log("🔧 Creating redirect module for next/Image...")
  createRedirectModule()
  console.log("✅ Done!")
}

// Exécuter si appelé directement
if (require.main === module) {
  main()
}

module.exports = { createRedirectModule }
