#!/bin/bash

echo "🚀 Starting comprehensive fix for Image imports..."

# Étape 1: Rechercher tous les fichiers avec next/Image
echo "🔍 Step 1: Finding all files with incorrect imports..."
find . -type f $$ -name "*.ts" -o -name "*.tsx" -o -name "*.js" -o -name "*.jsx" $$ \
  ! -path "./node_modules/*" \
  ! -path "./.next/*" \
  ! -path "./.git/*" \
  -exec grep -l "next/Image" {} \; 2>/dev/null > /tmp/files_to_fix.txt

if [ -s /tmp/files_to_fix.txt ]; then
  echo "❌ Found files with incorrect imports:"
  cat /tmp/files_to_fix.txt
  
  echo ""
  echo "🔧 Step 2: Fixing all incorrect imports..."
  
  # Étape 2: Corriger tous les imports
  while IFS= read -r file; do
    echo "Fixing: $file"
    sed -i.bak 's/next\/Image/next\/image/g' "$file"
    rm -f "$file.bak"
  done < /tmp/files_to_fix.txt
  
  echo ""
  echo "🔍 Step 3: Verifying fixes..."
  
  # Étape 3: Vérifier que tout est corrigé
  find . -type f $$ -name "*.ts" -o -name "*.tsx" -o -name "*.js" -o -name "*.jsx" $$ \
    ! -path "./node_modules/*" \
    ! -path "./.next/*" \
    ! -path "./.git/*" \
    -exec grep -l "next/Image" {} \; 2>/dev/null > /tmp/remaining_errors.txt
  
  if [ -s /tmp/remaining_errors.txt ]; then
    echo "❌ Still found files with errors:"
    cat /tmp/remaining_errors.txt
    echo ""
    echo "Showing problematic lines:"
    while IFS= read -r file; do
      echo "File: $file"
      grep -n "next/Image" "$file" 2>/dev/null || true
      echo ""
    done < /tmp/remaining_errors.txt
  else
    echo "✅ All imports have been successfully corrected!"
  fi
  
  # Nettoyage
  rm -f /tmp/files_to_fix.txt /tmp/remaining_errors.txt
else
  echo "✅ No files found with incorrect Image imports!"
fi

echo ""
echo "🏗️ Step 4: Testing build..."
echo "Running: npm run build"
